@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 60% !important;
    }
    .v-select .selected-tag {
        height: 26px !important;
        margin: 4px 1px 0 3px !important;
    }
    .v-select .selected-tag > button >span{
        display: none !important;
    }
</style>
@endsection
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'memberExchangeList'" @closed="closeModal">
            <div slot="body">
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1" style="border: 1px solid rgb(225, 225, 225); padding:20px  15px;border-radius: 10px;">
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.SelectMember') </label>
                                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch" :options="member" :multiple="true"> </v-select>
                                    {{-- <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id"> --}}
                                    <input type="hidden" name="member_id" :value="member_id.length > 0 ? member_id:null">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.SelectClass')</label>
                                    <v-select class="vue-select2" v-model="selected_class" label="name" :options="member_class"></v-select>
                                    <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                        <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                    </div>
                                    <div class="col-md-6" style="padding-right: 0px !important; padding-left: 0px !important;">
                                        @if(getFinancialClass() =='true') 
                                        @permission('financialClass-list')
                                        <div class="col-md-12">
                                            <label class="control-label"> @lang('menu.FinancialClass')</label>
                                            <select name="financial_class_id" class="form-control" >
                                                <option value="">@lang('layout.SelectClass')</option>
                                                <option value="Unclassified">Unclassified</option>
                                                <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                            </select>
                                        </div>
                                        @endpermission
                                        @endif
                                    </div>
                                    @if(systemConfig()[29] == 1)
                                    <div class="col-md-1">
                                        <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline"> 
                                                <input type="checkbox" name="transaction_confirm" value="On">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            <div class="row" style="padding-bottom:15px;margin-top:10px">
                                <div class="col-md-12">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    <div class="input-group">
                                      <input class="form-control" autocomplete="off" name="from_number">
                                      <span class="input-group-addon"> @lang('layout.To') </span>
                                      <input class="form-control" autocomplete="off" name="to_number">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="control-label"> @lang('layout.Date')</label>
                                            <div class="input-group">
                                                <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                <input class="form-control date" id="range-to-example" name="to_date">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2"> 
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                        @csrf
                                        <input type="hidden" name="part_name" value="member_exchange_index">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px; margin-bottom: 10px;" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <!-- <label> @{{ row.Name }}</label>
                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                    <label class="switch">
                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                        :checked="row.checkedColumn" >
                                                        <span class="slider round"></span>
                                                    </label> -->
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue" title="@lang('layout.Storage')"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.MemberExchangeList') </span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                 
                    <span id="anchore-modal">
                       <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                          <i class="fa fa-print"></i>
                       </a>
                    </span>

                    <a href="{{route('memberExchange.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>

                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="transferAccounts">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.OutAmount') </th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.InAmount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('member_exchange_index')!!};
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#transferAccounts').DataTable({
                ajax: '{{route("memberExchange.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:7}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'number'},
                    {data: 'member', name: 'member'},
                    {data: 'type', name: 'type'},
                    {data: 'pamount', name: 'pamount'},
                    {data: 'punit', name: 'punit'},
                    {data: 'prate', name: 'prate'},
                    {data: 'amount', name: 'amount'},
                    {data: 'unit', name: 'unit'},
                    {data: 'rate', name: 'rate'},
                    {data: 'date', name: 'date'},
                    {data: 'hour', name: 'member_exchanges.hour',searchable: false},
                    {data: 'user', name: 'user'},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', searchable: false, orderable: false},
                ]
            });
        });
        Vue.component('v-select', VueSelect.VueSelect)
        var currency2 ={!! $currency !!}
        var member_class  = {!!json_encode($member_class)!!}

        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('memberExchange.report') !!}',
                excelRoute: '{!! route('memberExchange.report') !!}',
                selectedMember: [],
                member: [],
                member_id:[],
                currency:currency2,
                selectedCurrency: null,
                financial_classes: {!!getFinancialClassList()!!},
                selected_class:null,
                member_class:member_class,
                customReportData: 
                [
                    {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',
                    column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                    {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',
                    column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',
                    column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                    {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',
                    column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',
                    column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                    {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',
                    column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
                    {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',
                    column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                    {Name: '@lang("layout.OutAmount")', column_name: 'outAmount',checkedColumn:(cust_rep.outAmount)?'checked':'',
                    column_percentage:(cust_rep.outAmount___percent)?cust_rep.outAmount___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',
                    column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                    {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',
                    column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                    {Name: '@lang("layout.InAmount")', column_name: 'InAmount',checkedColumn:(cust_rep.InAmount)?'checked':'',
                    column_percentage:(cust_rep.InAmount___percent)?cust_rep.InAmount___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency1',checkedColumn:(cust_rep.currency1)?'checked':'',
                    column_percentage:(cust_rep.currency1___percent)?cust_rep.currency1___percent:''},
                    {Name: '@lang("layout.Rate")', column_name: 'rate1',checkedColumn:(cust_rep.rate1)?'checked':'',
                    column_percentage:(cust_rep.rate1___percent)?cust_rep.rate1___percent:''},
                    {Name: '@lang("layout.TransactionConfirm")', column_name: 'transactionConfirm',checkedColumn:(cust_rep.transactionConfirm)?'checked':'',
                    column_percentage:(cust_rep.transactionConfirm___percent)?cust_rep.transactionConfirm___percent:''},
                    {Name: '@lang("layout.MonetarySource")', column_name: 'monetarySource',checkedColumn:(cust_rep.monetarySource)?'checked':'',
                    column_percentage:(cust_rep.monetarySource___percent)?cust_rep.monetarySource___percent:''},
                    {Name: '@lang("layout.TransactionType")', column_name: 'transactionType',checkedColumn:(cust_rep.transactionType)?'checked':'',
                    column_percentage:(cust_rep.transactionType___percent)?cust_rep.transactionType___percent:''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',
                    column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                    {Name: '@lang("layout.Currency")', column_name: 'currency2',checkedColumn:(cust_rep.currency2)?'checked':'',
                    column_percentage:(cust_rep.currency2___percent)?cust_rep.currency2___percent:''},
                    {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',
                    column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                    {Name: '@lang("layout.Amount") $', column_name: 'amount1',checkedColumn:(cust_rep.amount1)?'checked':'',
                    column_percentage:(cust_rep.amount1___percent)?cust_rep.amount1___percent:''},
                    {Name: '@lang("layout.AverageRate") $', column_name: 'averageRate',checkedColumn:(cust_rep.averageRate)?'checked':'',
                    column_percentage:(cust_rep.averageRate___percent)?cust_rep.averageRate___percent:''},
                ],
                cust_rep:cust_rep
            },
            watch: {
                selectedMember: function (newVal, oldVal) {
                    let x = [];
                    newVal.forEach(function (e) {
                        x.push(e.id);
                    });
                    this.member_id = x;
                }
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
    </script>
@endpush
