@extends('layouts.app')
@section('style')
    <link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@stop
@section('content')
    <div class="">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.MemberExchangeCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"></div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="member-transfer" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::model($memberExchange,array('route' => ['memberExchange.update',$memberExchange->id],'method'=>'patch','class'=>'form-horizontal','id'=>'member-transfer-form')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <div class="row" style="margin-bottom: 20px; padding-bottom: 20px;">
                        <div class="col-lg-8 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 15px 0px;">
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-lg-12">
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Member')</label>
                                        <v-select @input="getSummary" v-model="selectedFromMember" label="name" @search="MemberSearch" :options="fromMember">
                                        </v-select>
                                        <input type="hidden" name="member_id"
                                               v-model.number="(!selectedFromMember)?null:selectedFromMember.id"
                                               v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                        <span class="required">@{{errors.first('member_id')}}</span>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Type')</label>
                                                <select class="form-control"  v-model="pay_type" @input="setAmount()" @click="setAmount()" name="pay_type" v-validate="'required'" data-vv-as="@lang('layout.Type')" >
                                                    <option value="" disabled>@lang('layout.SelectType')</option>
                                                    <option value="Payable">@lang('layout.Payable')</option>
                                                    <option value="Receivable">@lang('layout.Receivable')</option>
                                                </select>
                                                <span class="required">@{{ errors.first('pay_type') }}</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" class="form-control" name="number" v-validate="'required'" value="{{ $memberExchange->number }}"
                                            data-vv-as="@lang('layout.Number')" />
                                        <span class="required">@{{ errors.first('number') }}</span>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select label="code" :options="currency" v-model="selected_currency" @input="setAmount()"></v-select>
                                        <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                        <span class="required">@{{ errors.first('currency') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Rate')</label>
                                        <input type="number" name="currency_rate" v-validate="'required'"
                                            data-vv-as="@lang('layout.Rate')" @input="setAmount()"
                                            v-model="!selected_currency?0:selected_currency.rate"
                                            class="form-control">
                                        <span class="required">@{{ errors.first('currency_rate') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="amount"
                                            :max="99999999999999"
                                            :currency="selected_currency.code"
                                            :precision="precision()"
                                            @input="get_exchange()"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" v-validate="'required'" data-vv-as="@lang('layout.Amount')" class="form-control" name="amount" v-model="amount" />
                                        <span class="required">@{{ errors.first('amount') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Balance')</label>
                                        <input type="number" readonly   class="form-control" name="maxAmount" v-model="maxAmount" />
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.ToCurrency2')</label>
                                        <v-select label="code" :options="currency" v-model="selected_currency2" @input="get_exchange()"></v-select>
                                        <input type="hidden" name="currency2" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency2.code">
                                        <span class="required">@{{ errors.first('currency2') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.ToRate')</label>
                                        <input type="number" name="currency_rate2" v-validate="'required'" data-vv-as="@lang('layout.Rate')" @input="get_exchange()" v-model="!selected_currency2?0:selected_currency2.rate"class="form-control">
                                        <span class="required">@{{ errors.first('currency_rate2') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <div class="input-group">
                                            <vue-numeric
                                                class="form-control"
                                                v-model="exchange_amount"
                                                :max="99999999999999"
                                                :currency="selected_currency2.code"
                                                :precision="precision()"
                                                @input="set_rate()"
                                                >
                                            </vue-numeric>
                                            <input type="hidden" v-model="exchange_amount" name="exchange_amount" class="form-control" min="0" step="any" v-validate="'required'" data-vv-as="@lang('layout.ExchangedAmount')" />
                                            <span class="input-group-addon">@{{selected_currency2.symbol}}</span>
                                        </div>
                                        <span class="required">@{{ errors.first('receivable') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        <input type="text" class="form-control date" autocomplete="off" name="date" value="{{ $memberExchange->date }}">
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="col-lg-2">
                                        <label class="control-label">@lang('layout.Hour')</label>
                                        <div class="input-group">
                                            @if(getHourType() == 24)
                                            <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$memberExchange->hour}}">
                                            @else
                                            <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$memberExchange->hour}}" >
                                            @endif
                                            <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.MonetarySource')</label>
                                        {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.TransactionType')</label>
                                        {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                    </div>
                                    @if(systemConfig()[29] == 1)
                                        <div class="col-lg-2">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                    <input type="checkbox" name="transaction_confirm" v-model="show_transaction_confirm_checked" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')">
                                                    <span></span>
                                                </label>
                                            </div>
                                            <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                        </div>
                                    @endif
                                    <div class="col-lg-9">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        <textarea name="description" rows="1" class="form-control">{{ $memberExchange->description }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12 col-sm-12">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;padding: 0px !important; padding: 19px 15px 50px 15px;">
                                <div class="panel panel-default"
                                 style="position: relative;top: 24px;padding: 10px;">
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">@lang('layout.Currency') </th>
                                                    <th class="text-center">@lang('layout.Payable')</th>
                                                    <th class="text-center">@lang('layout.Receivable')</th>
                                                    <th class="text-center">@lang('layout.AverageRate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedFromMember">
                                                    <tr v-for="summ in summary">
                                                        <td class="highlight text-center">
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td class="text-center"> 
                                                            @{{ format_number(Number(summ.payment)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.invoice)) }}
                                                        </td>
                                                        <td class="text-center">
                                                            @{{format_number(Number(summ.rate))}}
                                                        </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                        @if(systemConfig()[22] == 1) 
                                        <br/>
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr v-if="selectedFromMember">
                                                    <th style="background-color: #add8e6;text-align: center;" v-if="selectedFromMember.risk_step">
                                                        @lang('layout.RiskStep')
                                                    </th>
                                                    <th v-if="selectedFromMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                    <th v-if="selectedFromMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                    <th v-if="selectedFromMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                                </tr>
                                            </thead>
                                        </table>    
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 text-center">
                    <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                    <a href="{{route('memberExchange.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    <hr>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
    <script>
        /**
         * for creating shortcuts
         */
        @if(App::getLocale())
        Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
        Vue.component('v-select', VueSelect.VueSelect);
        Vue.use(VueNumeric.default);
        var code = '{!! getHomeCurrency()["code"] !!}';
        var currency ={!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var selectedCurrency2 = {!! $selectedCurrency2 !!};
        var memberExchange = {!! $memberExchange !!};
        let vm = new Vue({
            el: '#member-transfer',
            data: {
                fromMember: [],
                toMember: [],
                selectedFromMember: null,
                selectedToMember: null,
                summary: [],
                summary2: [],
                memberExchange: memberExchange,
                selectedCurrency: selectedCurrency,
                selectedCurrency2: selectedCurrency2,
                currency: currency,
                selected_currency: defaultCurrency(),
                selected_currency2: defaultCurrency(),
                show_transaction_confirm_checked: "{{$memberExchange->transaction_confirm == 'On'}}",
                payable: 0,
                receivable: 0,
                payable2: 0,
                receivable2: 0,
                maxpayable: 0,
                maxreceivable: 0,
                amount: 0,
                maxAmount: 0,
                exchange_amount: 0,
                code: code,
                pay_type: '',
                payable_flag: false,
                receivable_flag: false,
            },
            mounted: function () {
                if (this.memberExchange) {
                    @if($selectedMember)
                    this.selectedFromMember = {!! $selectedMember !!};
                    @endif
                    this.selected_currency = this.selectedCurrency;
                    this.selected_currency2 = this.selectedCurrency2;
                    this.pay_type = this.memberExchange.type;
                    setTimeout(function () {
                            this.amount = this.memberExchange.pamount;
                            this.maxAmount = (this.maxAmount + this.memberExchange.pamount);
                            this.exchange_amount = this.memberExchange.amount;
                    }.bind(this), 2000);
                }
            },
            methods: {
                setAmount() {
                    this.payable = 0;
                    this.receivable = 0;
                    this.maxpayable = 0;
                    this.maxreceivable = 0;
                    if (this.selected_currency && this.selectedFromMember && this.pay_type) {
						// this.selected_currency2 = this.selected_currency;
                        this.amount = 0;
                        this.maxAmount = 0;
                        this.exchange_amount = 0;
                        if (this.summary.length > 0) {
                            for (var i = 0; i < this.summary.length; i++) {
                                if (this.summary[i].currency == this.selected_currency.code) {
                                    // console.log(32,this.summary[i]);
                                    this.payable = this.summary[i].payment;
                                    this.receivable = this.summary[i].invoice;
                                    if (this.payable > 0 && this.pay_type == 'Payable') {
                                        this.amount = this.payable;
                                        this.maxAmount = this.payable;
                                        this.get_exchange();
                                    } else if (this.receivable > 0 && this.pay_type == 'Receivable') {
                                        this.amount = this.receivable;
                                        this.maxAmount = this.receivable;
                                        this.get_exchange();
                                    }
                                    else {
                                        this.amount = 0;
                                        this.maxAmount = 0;
                                    }
                                }
                            }
                        }
                    }else{
                        this.amount = 0;
                        this.maxAmount = 0;
                    }
                },
                set_rate() { 
                    let vm = this;
                    if (vm.selected_currency2.code == vm.selected_currency.code) {
                        if (vm.exchange_amount > 0) {
                            vm.amount = myRound(vm.exchange_amount);
                        }
                    } else if (vm.selected_currency2.code == vm.code) {
                        if (vm.exchange_amount > 0 && vm.amount > 0) {
                            @if(systemConfig()[30] == 1)
                            vm.selected_currency.rate = myRound((vm.amount / vm.selected_currency.rate *  vm.selected_currency.static_rate) / (vm.exchange_amount * vm.selected_currency2.static_rate  ));
                            @else 
                            vm.selected_currency.rate = myRound((vm.amount) / (vm.exchange_amount));
                            @endif
                        }
                    } else {
                        if(vm.exchange_amount > 0 && vm.selected_currency2 && vm.selected_currency){
                            if(vm.selected_currency.rate > 0){
                                @if(systemConfig()[30] == 1)
                                vm.selected_currency2.rate = myRound(((vm.amount / vm.selected_currency.static_rate * vm.selected_currency.rate) / vm.exchange_amount) * vm.selected_currency2.static_rate);
                                @else 
                                vm.selected_currency2.rate = myRound((vm.exchange_amount) / (vm.amount / vm.selected_currency.rate));
                                 @endif 
                            }
                           
                        }
                    } 
                    // let vm = this;
                    // if (vm.selected_currency2.code == vm.selected_currency.code) {
                    //     if (vm.exchange_amount > 0 && vm.amount > 0) {
                    //         vm.amount = myRound(vm.exchange_amount);
                    //     }
                    // } else if (vm.selected_currency2.code == vm.code) {
                    //     if (vm.exchange_amount > 0 && vm.amount > 0) {
                    //         vm.selected_currency.rate = myRound((vm.amount) / (vm.exchange_amount));
                    //     }
                    // } else {
                    //     if(vm.exchange_amount > 0 && vm.selected_currency2 && vm.selected_currency){
                    //         if(vm.selected_currency.rate > 0){
                    //             vm.selected_currency2.rate = myRound((vm.exchange_amount)/ (vm.amount / vm.selected_currency.rate));
                    //         }
                    //     }
                    // }
				},
                get_exchange() {
                    let vm = this;
                    if(vm.amount > 0 && vm.selected_currency2 && vm.selected_currency){
                        if(vm.selected_currency2.rate > 0 && vm.selected_currency.rate > 0){
                            @if(systemConfig()[30] == 1)
                            vm.exchange_amount = Number.parseFloat(((vm.amount/ vm.selected_currency.static_rate * vm.selected_currency.rate) *  vm.selected_currency2.static_rate) / vm.selected_currency2.rate).toFixed(8);
                            @else 
                            vm.exchange_amount = Number.parseFloat((vm.amount * vm.selected_currency2.rate)/ vm.selected_currency.rate).toFixed(8);
                            // console.log(vm.exchange_amount, 'Exchange');
                            @endif
                        }
                    }
  

                    // let vm = this;
                    // if(vm.amount > 0 && vm.selected_currency2 && vm.selected_currency){
                    //     if(vm.selected_currency2.rate > 0 && vm.selected_currency.rate > 0){
                    //         vm.exchange_amount = Number.parseFloat((vm.amount * vm.selected_currency2.rate)/ vm.selected_currency.rate).toFixed(8);
                    //     }
                    // }
				},
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);  
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.fromMember = [];
                            vm.fromMember = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),
                getSummary() {
                    if (this.selectedFromMember) {
                        // this.fillToMember();
                        this.getSummaryRecor(this.selectedFromMember.id, this);
                    }
                },
                getSummaryRecor(id, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                        .then(function (response) {
                            if (response.data.length > 0) {
                                vm.summary = response.data;
                                // console.log(34, response.data);
                                if (vm.selected_currency != null) {
                                    vm.setAmount();
                                }
                            }
                        })
                        .catch(function (error) {
                            console.log(error);
                        });
                },
                handleSubmit(e) {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {
                                @if(systemConfig()[30] == 1)
                                var v = (Number.parseFloat(vm.amount) / vm.selected_currency.static_rate *  vm.selected_currency.rate).toFixed(precision());
                                var u = (Number.parseFloat(vm.exchange_amount) / vm.selected_currency2.static_rate * vm.selected_currency2.rate).toFixed(precision())
                                @else 
                                var v = (Number.parseFloat(vm.amount) / vm.selected_currency.rate).toFixed(precision());
                                var u = (Number.parseFloat(vm.exchange_amount) / vm.selected_currency2.rate).toFixed(precision())
                                @endif

                                if (v != u) {
									// console.log(3451235499, Number.parseFloat(vm.amount), Number.parseFloat(vm.maxAmount), vm.selected_currency.rate, vm.selected_currency2.rate, (Number.parseFloat(vm.amount) / vm.selected_currency.rate) , (Number.parseFloat(vm.exchange_amount) / vm.selected_currency2.rate));
                                   
                                    var message = "{{__('message.Warning')}}";
                                    toastr.warning('', message);
                                }
                                else {
                                    regForm(e.target);
                                }
                            }
                        })
                },
            }
        })
    </script>
@endpush