@extends('layouts.app')

@section('content')
<!-- BEGIN CONTENT -->
<!-- BEGIN PAGE BAR -->
<!-- END PAGE BAR -->
@include('measures.modal')
<!-- use the modal component, pass in the prop -->




@if (count($errors) > 0)

<div class="m-heading-1 border-green m-bordered">

{{--</div>--}}
{{--<div class="alert alert-danger">--}}
    {{--<ul>--}}
        @foreach ($errors->all() as $error)
        <p>{{ $error }}</p>
        @endforeach
    {{--</ul>--}}
</div>

@endif

<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.MeasureList')</span>
            </div>
            <div class="tools">
            </div>
            <div class="btn-group pull-right">
                {{--<a href="{{route('measure.create')}}">--}}
                    {{--<button id="sample_editable_1_new" class="btn green btn-sm btn-outline">--}}
                        {{--<i class="fa fa-plus"></i> Add New--}}
                    {{--</button>--}}
                {{--</a>--}}
                <div id="measure" v-cloak>
                    @permission('measure-create')
                    <button class="btn btn-success" type=button id="show-modal"
                    v-on:click="showModal = true"><i class="fa fa-plus"></i> @lang('layout.AddNew')
                </button>
                <a href="{{route('measureImport.create')}}">
                    <button id="sample_editable_1_new" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('menu.ImportExcel')
                    </button>
                </a>
                @endpermission

                <modal v-if="showModal" @close="showModal = false">
                    <div slot="header">
                        <div class="col-md-4">
                            <h3>
                                @lang('layout.AddNewMeasure')
                            </h3>
                        </div>
                        <div class="col-md-4">
                            <div v-if="fieldErrors.length > 0">
                                <p class="text-danger" fieldErrors>
                                    <spna v-text="fieldErrors"></spna>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div slot="body">
                        <div class="row">
                            <div class="col-md-3">
                                <h4>@lang('layout.MetricType')</h4>
                                <span v-for="metric in metricList">
                                    <div class="mt-radio-list">
                                        <label class="mt-radio"> @{{ metric.name }}

                                            <input name="metric" type="radio" v-bind:value="metric"
                                            v-model="selectedMetric" v-on:change="selectedMeasure = {}">

                                            <span></span>
                                        </label>
                                    </div>
                                </span>
                            </div>
                            <div class="col-md-3">
                                <h4>@lang('layout.Measure') </h4>

                                <span v-for="measure1 in selectedMetric.measure">
                                    <div class="mt-radio-list">
                                        <span v-if="measure1.text=='Other'">@lang('layout.OtherMeasure') </span>
                                        <span v-if="measure1.text !='Other'">@{{ measure1.text }} </span>
                                        <label class="mt-radio"> 

                                            <input name="measureds" type="radio" v-bind:value="measure1"
                                            v-model="selectedMeasure">

                                            <span></span>
                                        </label>
                                    </div>
                                </span>

                            </div>








                            <div class="col-md-6">
                                <span v-if="selectedMeasure.text == 'Other'">
                                    <h4 class="text-center">@lang('layout.OtherMeasure') </h4>
                                    <div>
                                        <div class="form-group">
                                            <label class="control-label col-md-5">
                                            @lang('layout.MeasureName')</label>
                                            <div class="col-md-7">
                                                <input type="text" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureName')"
                                                v-model.trim="selectedMeasure.name">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label class="control-label col-md-5">
                                                @lang('layout.MeasureAmount')
                                            </label>
                                            <div class="col-md-7">
                                                <input type="number" class="form-control"
                                                placeholder="Enter Measure uint"
                                                v-model.number="selectedMeasure.unit">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>
                                        <div class="form-group ">
                                            <label class="control-label col-md-5">
                                                @lang('layout.MeasureSymbol')
                                            </label>
                                            <div class="col-md-7">
                                                <input type="text" class="form-control"
                                                placeholder="@lang('layout.EnterMeasureSymbol')"
                                                v-model.trim="selectedMeasure.symbol">
                                                <span class="help-block">  </span>
                                            </div>
                                        </div>
                                    </div>

                                </span>
                            </div>

                        </div>
                    </div>


                    <div slot="footer">
                        <button type=button class="btn btn-success" v-on:click="addMeasure">
                            @lang('layout.OK')
                        </button>
                        <button type=button class="btn btn-danger"
                        v-on:click="showModal = false ,measure = null , type=null">
                        @lang('layout.Cancel')
                    </button>
                </div>
            </modal>
        </div>
    </div>
</div>
<div class="portlet-body">
    <table class="table table-striped table-bordered table-hover" id="myTable1">
        <thead>
            <tr>
                <th>@lang('layout.MetricName')</th>
                <th>@lang('layout.BaseUnit')</th>
                <th>@lang('layout.MeasureName')</th>
                <th>@lang('layout.Unit')</th>
                <th>@lang('layout.Symbol')</th>
                <th>@lang('layout.Actions')</th>

            </tr>
        </thead>
        
    </table>
</div>
</div>
<!-- END EXAMPLE TABLE PORTLET-->

</div>

<!-- BEGIN TAB PORTLET-->
{{--<div class="row">--}}
    {{--<div class="portlet light bordered">--}}
        {{--<div class="page-toolbar">--}}
            {{--<div class="btn-group pull-right">--}}

                {{--<a href="{{route('measure.create')}}">--}}
                    {{--<button id="sample_editable_1_new" class="btn green btn-sm btn-outline">--}}
                        {{--<i class="fa fa-plus"></i> Add New--}}
                    {{--</button></a>--}}
                {{--</div>--}}
            {{--</div>--}}
            {{--<table id="myTable1" class="table table-striped table-bordered" cellspacing="0" width="100%">--}}
                {{--<thead>--}}
                    {{--<tr>--}}
                        {{--<th>Account Number</th>--}}
                        {{--<th>Account Name</th>--}}
                        {{--<th>Account type</th>--}}
                        {{--<th>Description</th>--}}
                        {{--<th>Currency</th>--}}
                        {{--<th>Balance</th>--}}
                    {{--</tr>--}}
                {{--</thead>--}}

            {{--</table>--}}


        {{--</div>--}}
    {{--</div>--}}
    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->



    @stop

    @push('scripts')
    <script src="{{url('/vue/vue-resource.js')}}"></script>
    <script src="{{url('/js/measures.js')}}"></script>


    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#myTable1').DataTable({
                ajax: '{{route("measure.index")}}',
                pageLength:'{{getPageRows()}}',
                paging: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                server: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                {data: 'quantities', name: 'quantities'},
                {data: 'base', name: 'base'},
                {data: 'name', name: 'name'},
                {data: 'unit', name: 'unit'},
                {data: 'symbol', name: 'symbol'},
                {data: 'actions', name: 'actions',orderable:false,searchable:false}
                ]
            });


        });


        Vue.http.headers.common['X-CSRF-TOKEN'] = document.querySelector('#token').getAttribute('value');

        Vue.component('modal', {
            template: '#customer-template'
        })


        Vue.component('modal', {
            template: '#modal-template'
        })

        
        let vu = new Vue({
            el: '#measure',
            data: {
                showModal: false,
                fieldErrors: [],
                selectedMetric: {},
                senddata: {},
                selectedMeasure: {},
                metricList: {!!json_encode(getMeasures())!!},

            },
            methods: {
                addMeasure: function () {

                    let senddata = _.clone(this.selectedMetric);

                    senddata.measure = _.clone(this.selectedMeasure);

                    var req = axios.post("{{route('measure.store')}}",senddata)
                    .then(function (response) {
                        vu.showModal = false;
                        vu.fieldErrors = [];
                        vu.selectedMetric = {};
                        vu.selectedMeasure = {};


                        $('#myTable1').DataTable().ajax.reload();

                    })
                    .catch(function (error) {

                        vu.fieldErrors = error.response.data

                    });

                },
            }

        });
    </script>


    @endpush
