@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title">
            <div class="caption">
                <i class=""></i>@lang('layout.BuildInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.BuildNumber')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.ItemName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa  fa-user"></i> @lang('layout.CreatedBy')
                        </th> 
                        <th>
                            <i class="fa fa-shopping-cart"></i> @lang('layout.Quantity')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Cost')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr> 
                        <td class="hidden-xs"> {{ $build[0]->b_number}}  </td>
                        <td class="hidden-xs"> {{ $build[0]->name}}  </td>
                        <td class="hidden-xs"> {{ $build[0]->username }}  </td>
                        <td class="hidden-xs"> {{ $build[0]->qty }}  </td>
                        <td class="hidden-xs"> {{ $build[0]->cost*$build[0]->qty}}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
     <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.BuildDetails')</span>
                    </div>
                        <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="build_Details"/>
                           <input type="hidden" name="id" value="{{$build[0]->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="build_Details"/>
                           <input type="hidden" name="id" value="{{$build[0]->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="builds">
                        <thead>
                        <tr>  
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.BuildNumber')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.MeasureName')</th>
                            <th>@lang('layout.Cost')</th>
                            <!-- <th>Action</th> -->
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')
 <script>
    $(document).ready(function () {
        $('#builds').DataTable({
           ajax:'{{route("build.show",$build[0]->id)}}',
            serverSide: true,
            scrollCollapse: true,
            paging: true,
            columns: [    
                { data: 'Name', name: 'items.name' },
                { data: 'Build_Number', name: 'builds.number' },
                { data: 'Date', name: 'Date',orderable:false,searchable:false },
                { data: 'Quantity', name: 'Quantity',orderable:false,searchable:false },
                { data: 'Measure', name: 'Measure',orderable:false,searchable:false },
                { data: 'Cost', name: 'Cost',orderable:false,searchable:false },
        
        ]

        });
    });

</script>
 
@endpush 