@extends('layouts.app')

@section('content')
@include('receives.modal')


<!-- END PAGE HEADER-->
@if (Session('message'))

<div class="m-heading-1 border-green m-bordered success-action">

  
  <ul class="success-body">

    <li>{{ Session('message') }}</li>

  </ul>

</div>

@endif


@if (count($errors) > 0)

<div class="m-heading-1 border-red m-bordered errors-action">

  <h4 class="error-title"><strong>Whoops!</strong>  There were some problems with your input</h4>
  <ul class="error-body">
    @foreach ($errors->all() as $error)
    <li>{{ $error }}</li>
    @endforeach
  </ul>

</div>

@endif
<!-- app -->



<!-- BEGIN TAB PORTLET-->
<div class="row">
  <!-- BEGIN EXAMPLE TABLE PORTLET-->
  <div class="portlet light bordered">
    <div class="portlet-title">
      <div class="caption font-dark">
        <i class="icon-settings font-dark"></i>
        <span class="caption-subject bold uppercase">  @lang('layout.AdvancePricingList')  </span>
      </div>
      <div class="tools"> </div>
      <div class="pull-right">
        @permission('account-export')
        <button type="submit" id="excell_all"  class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
        <button type="button" id="print_pdf_all" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
        @endpermission
        @permission('account-list')
        <a href="{{route('advancePricing.create')}}">
          <button id="sample_editable_1_new" class="btn btn-success">
            <i class="fa fa-plus"></i> @lang('layout.AddNew')
          </button></a>
          @endpermission 
        </div>
      </div>
      <div class="portlet-body">
        <table class="table table-striped table-bordered table-hover" id="sale">
          <thead>
            <tr>
             {{-- <th>@lang('layout.Number')</th>--}}
              <th>@lang('layout.Category')</th>
              <th>@lang('layout.ItemAmount')</th>
              <th>@lang('layout.Amount')</th>
              <th>@lang('layout.Type')</th>
              <th>@lang('layout.Date')</th>
              <th>@lang('layout.Description')</th>
              <th>@lang('layout.Actions')</th>
            </tr>
          </thead>
        </table>
      </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
  </div>


  <!-- END TAB PORTLET-->
  <iframe id="payframe" style="display: none;" ></iframe>
  <!-- END CONTENT BODY -->
  @stop

  @push('scripts')

  <script>
   Vue.component("v-select", VueSelect.VueSelect);
   @if (Session('receive_id'))
   printVoucher("{{Session('receive_id')}}")
   @endif
    function printVoucher(id) {

    var a=document.createElement('a');
    a.href="{{url('printReceive')}}/"+id;
    a.target="_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

   $(document).ready(function() {
    $('#sale').DataTable( {
      ajax:'{{route("advancePricing.index")}}',
      scrollCollapse: true,
      paging:         true,
      serverSide: true,
      columns: [
     /* { data: 'id',           name: 'advance_pricings.id' },*/
      { data: 'category',     name: 'inventory_categories.category' },
      { data: 'item_amount',  name: 'advance_pricing_details.item_amount'},
      { data: 'amount',       name: 'advance_pricings.amount' },
      { data: 'type',         name: 'type',orderable:false,searchable:false },
      { data: 'date',         name: 'date' ,orderable:false,searchable:false},
      { data: 'description',  name: 'receivable_payments.description'},
      { data: 'actions',      name: 'actions' ,orderable:false,searchable:false},
      ]
    });
  });


  //  function printVoucher(id){
  //   document.getElementById("payframe").src ="{{url('printReceive')}}/"+id+"";



  // }

  
   $('#excell_all').on('click',function(e){
     $('#show-modal2').click();
     e.preventDefault();
   })

 </script>
 @endpush
