@extends('layouts.app')
@section('style')
    <style>
        .v-select input[type=search], .v-select input[type=search]:focus {
            width: 50% !important;
        }
        .table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
            padding: 8px;
            padding: 4px 2px;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('menu.ImportExcel') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                
                <div class="pull-right">
                </div>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="tools text-center">
                        <a href="{{url('/')}}/import_file/simple_import_measure.xlsx" style="text-decoration: none; color: black;">--------
                           <button class="btn btn-success">
                           <i class="fa fa-download"></i>
                           @lang('layout.ImportExcelSample')
                           </button>
                        -------- </a>
                   </div>
                    <!-- BEGIN FORM-->
                    {{Form::open(['route'=>'measureImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form'])}}
                        {{ csrf_field() }}
                        <div class="form-body">
                            <div class="col-md-12">
                                <div class="form-group text-center" style="margin-top: 20px;">
                                    <label class="control-label col-md-5">@lang('layout.SelectFile') @lang('layout.Excel')
                                        :</label>
                                    <div class="col-md-7">
                                        {{Form::file('customer_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                            <button type="button" onClick="sendFormData(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                            </button>
                            <br/>
                            <br/>
                            <br/>
                            <br/>
                        </div>
                    {{Form::close()}}
                    <!-- end form -->
                </div>
                <div class="col-lg-4">
                    <ul class="text-danger">
                        <p class="text-danger">@lang('message.Info')</p>
                        <li class="text-danger">@lang('message.TipOne')</li>
                        <li class="text-danger">@lang('message.TipTwo')</li>
                        <li class="text-danger">@lang('message.TipThree')</li>
                    </ul>
                </div>
            </div>
            <div id="app" v-cloak>
                <h1 v-if="flag=='no'">@lang('layout.import_measure_msg')</h1>
                <div v-if="flag=='yes'" class="portlet-body form" style="margin-bottom:50%;">
                    <div v-if="record.length>0">
                        <div style="overflow-x:scroll; width: 100%">
                            <!-- begint table -->
 
                            {{Form::open(['route'=>'measureImport.store','method'=>'POST','class'=>'form-horizontal','enctype'=>'multipart/form-data','id'=>'import-form-second'])}}
                            {{csrf_field()}}
                            <div class="row">

                                <div class="col-md-12 col-md-12">
                                    <div class="col-md-12" style="height: 400px;">
                                        <table id="table_content" class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th class="text-center" style="width:20px;"> # </th>
                                                <th class="text-center" style="min-width: 200px;">
                                                    @lang('layout.MetricName')  
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.BaseUnit')
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.MeasureName')
                                                </th>  
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Unit')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Symbol')
                                                </th>
                                                
                                            </tr>
                                            </thead>
                                            <tr v-for="(obj,index) in record">
                                                <td class="td_one"><span class="badge badge3 badge-success badge-roundless">@{{index+1}} </span>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" readonly :name="'noname['+index+']'" v-model="obj.quan_unit">
                                                </td>

                                                <td class="td_one">
                                                    {{-- <input type="text" class="form-control" readonly :name="'quantity_unit['+index+']'" v-model="obj.quantity_unit"> --}}
                                                    <select class="form-control input-style" v-model="obj.quantity_id"
                                                    required="required"  :name="'quantity_id['+index+']'">
                                                        <option value="">@lang('layout.Select')</option>
                                                        <option v-if="category_list" 
                                                                v-for="cat in (category_list?category_list:null)"
                                                                :value="cat.id">
                                                            @{{cat.quantities}}
                                                        </option>
                                                    </select>
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'name['+index+']'" v-model="obj.name">                                                
                                                </td>
    
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'unit['+index+']'" v-model="obj.unit">                                                
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'symbol['+index+']'" v-model="obj.symbol">                                                
                                                </td>
                                               
                                                 
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>

                            </div>


                            <!-- end table -->
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                            <button type="button" @click="sendFormData(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                        </div>
                        {{Form::close()}}
                    </div>
                </div>


            </div>

        </div>
    </div>

@endsection
@push('scripts')


    <script>
        var data ={!! $data !!};
        var Category ={!! $metric !!};

        Vue.component('v-select', VueSelect.VueSelect);
        new Vue({ 
            el: '#app',
            data: {
                flag: 'yes',
                record: data,
                category_list: Category,
            },
            
            mounted(){
                for (var i = 0; i < data.length; i++) {
 
                }
            },
            

            methods: {
                sendFormData(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-second').submit();
                            return true;
                        }
                        return false;
                    });
                }
            },
            created: function () {
                console.log('ssssss', this.flag);
                for (var i = 0; i < this.record.length; i++) {
                    
                }
            }
        });

        function sendFormData(e) {
            var el = $(e);
            var form = el.parents('form').get(0);
            var data = $('#import-form').serialize();
            console.log('test 22', data);
            swal({
                title: "@lang('layout.AreYouSure?')",
                icon: 'warning',
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                dangerMode: true,
            }).then((wichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            });
        }


        // to send inventory data

        function sendData(element) {
            e = $(e);
            var form = e.parents('form').get(0);
            swal({
                'title': "@lang('layout.AreYouSure?')",
                'icon': 'dander',
                'buttons': ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                danderMode: true
            }).then((whichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            })
        }

        // end inventory data

    </script>


@endpush