@extends('layouts.app')
@section('style')

<style>

</style>
@stop
@section('content')


<div class="row" id="app" v-cloak>

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewInventoryCategory') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'advancePricing.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                <div class="col-md-12">
                                  <label class="control-label">@lang('Menu.InventoryCategory')</label>
                                     <select class="list-style form-control" @change="changeCategory(this)" name="inventory_category_id">
                                            <option value="">@lang('layout.Select')</option>
                                            <option v-for="cat in category" :value="cat.id">@{{cat.name}}</option>
                                     </select>
                                </div>
                            </div> 
                        </div>

                          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                 <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Type')</label>
                                     <select name="type" class="list-style form-control" 
                                     v-model="selected_type" >
                                            <option value="percent">%</option>
                                            <option value="currency">{{getHomeCurrency()["code"]}}</option>
                                     </select>
                                </div>
                            </div> 
                        </div>

                          <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Amount')</label>
                                    <input type="number" name="amount" class="form-control" v-model="amount">
                                </div>
                            </div> 
                        </div>

                        
                      </div>
                      <div class="row">
                          <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                            <div class="form-group">
                                
                                <div class="col-md-12">
                                  <label class="control-label">@lang('layout.Description')</label>
                                  {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div>
                      </div>
                                        
                      <table class="table table-striped table-bordered table-hover">
                          <thead>
                              <tr>
                                  <th><input type="checkbox" name="selectedItem" class="icheck" @change="selectAll(this)" v-model="selectedAll"> </th>
                                  <th>@lang('layout.Code') </th>
                                  <th>@lang('layout.ItemName') </th>
                                  <th class="hidden-xs">
                                       @lang('layout.Measure') </th>
                                  <th> @lang('layout.Amount') </th>
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in items">
                                  <input type="hidden" name="item[]" v-model="item.id">
                                  <td class="highlight">
                                      <div class="success"></div>
                                      <input type="checkbox" @click="toggleCheck(index)" :checked="item.selected">
                                      <input type="hidden" name="selected_item[]" :value="item.selected">
                                  </td>
                                    <td class="highlight">
                                      <div class="success"></div>
                                      @{{item.number}} 
                                  </td>
                                  <td class="highlight">
                                      <div class="success"></div>
                                      <a href="javascript:;"> @{{item.name}} </a>
                                  </td>
                                  <td class="hidden-xs"> @{{item.measure}} </td>
                                  <td> 
                                    <input type="number" name="amounts[]" :value="!item.selected?null:(Number(amount)+Number(item.amount))">
                                   </td>
                              </tr>
                          </tbody>
                      </table>
                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">


  var inventory_category = {!! $inventory_category !!}
  var items = {!!$items!!}
  new Vue({
    el: '#app',
    data: {
      category:inventory_category,
      items:items,
      amount:0,
      selected_type:'percent',
      selectedAll:false,

    },
    methods:
    {
      changeCategory(e)
      {
        var value=e.event.target.value;
        for(var i=0;i<this.items.length;i++)
        { 
           this.items[i].selected=null;
           if(this.items[i].inventory_category_id==value)
           {
              this.items[i].selected=true;
           }
        }
      },
      toggleCheck(index)
      {
        this.items[index].selected=!this.items[index].selected;
      },
      changeType()
      {
        console.log('test 22',this.selected_type);
      },
      amountChange()
      {
        console.log('ssss');
      },
      selectAll(e)
      {
        
         for(var i=0;i<this.items.length;i++)
        { 
           if(this.selectedAll==true)
           {
             this.items[i].selected=true;
           }
           else
           {
               this.items[i].selected=false;
           }
         
        }
      }
    },
    created:function()
    {
        console.log('test 22',this.record);
    }

  });

</script>


@endpush