@extends('layouts.app')

@section('content')
<!-- BEGIN TAB PORTLET-->
<div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.MaintenanceInfo')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>                            
                            <i class="fa  fa-bars"></i> @lang('layout.ID') 
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-text-width"></i> @lang('layout.ProjectName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-text-width"></i> @lang('layout.Description')
                        </th>
                         <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.ExpenseAccount')
                        </th> 
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.BankAccount')
                        </th>
                        <th> 
                            <i class="fa "></i> @lang('layout.TotalAmount') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Currency') 
                        </th>
                        <th>
                            <i class="fa  "></i> @lang('layout.Rate')
                        </th>        
                    </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class="hidden-xs"> {{ $expenseInfo->id}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->name }}  </td> 
                        <td class="hidden-xs"> {{ $expenseInfo->Description }}  </td> 
                        <td class="hidden-xs"> {{ convertDate($expenseInfo->Date) }} </td>
                        <td class="hidden-xs"> {{ $expenseInfo->expense_account }}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->Bank}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->amount}}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->Currency }}  </td>
                        <td class="hidden-xs"> {{ $expenseInfo->Rate }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
  <div class="tabbable-line tabbable-custom-profile">
  <ul class="nav nav-tabs"> 
   <li class="active">
      <a href="#out-item" data-toggle="tab" id="tab-out-item">
       <i class="fa fa-folder"></i><b> @lang('layout.MaintenanceDetails') </b></a>
     </li> 
    <li>
      <a href="#item" data-toggle="tab" id="tab-item">
       <i class="fa fa-database"></i><b> @lang('layout.Item') </b></a>
     </li> 
   </ul>  
   <div class="tab-content padding" style="padding: 0px;">
     <div class="tab-pane active" id="out-item">
   <div class="row">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light bordered">
        <div class="portlet-title">
          <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">@lang('layout.MaintenanceDetails')</span>
          </div>
           <div class="actions">
            @permission('maintenance-export') 
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="project_expense_Details"/>
                           <input type="hidden" name="id" value="{{$expenseInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="project_expense_Details"/>
                           <input type="hidden" name="id" value="{{$expenseInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}
            @endpermission  
                    </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-bordered table-hover" id="out-item-table">
            <thead>
              <tr>  
                <th>@lang('layout.Details')</th>
                <th>@lang('layout.Amount')</th>
                <th>@lang('layout.CreatedAt')</th>
             </tr>
            </thead>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
 </div>
    <div class="tab-pane" id="item">
     <div class="row">
      <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
          <div class="portlet-title">
            <div class="caption font-dark">
              <i class="icon-settings font-dark"></i>
              <span class="caption-subject bold uppercase">@lang('layout.MaintenanceDetails')</span>
            </div>
             <div class="actions">
              @permission('maintenance-export')
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="project_expense_Details_item"/>
                           <input type="hidden" name="id" value="{{$expenseInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="project_expense_Details_item"/>
                           <input type="hidden" name="id" value="{{$expenseInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
            @endpermission
                    </div>
          </div>
          <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="item-table">
              <thead>
                  <tr>  
                    <th>@lang('layout.ItemName')</th>
                    <th>@lang('layout.Details')</th>
                    <th>@lang('layout.Quantity')</th>
                    <th>@lang('layout.Price')</th>
                    <th>@lang('layout.TotalAmount')</th>
                    <th>@lang('layout.Measure')</th>
                  </tr>
              </thead>
            </table>
          </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
      </div>
    </div>
  </div> 
</div>
</div>
</div>
@endsection
@push('scripts')
<script>
var table=0;
$(document).ready(function(){
  $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

    table =$('#out-item-table').DataTable({  
      scrollCollapse: true,
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',
      serverSide: true,
      paging: true,
      ajax:'{{route("maintenance.show",$expenseInfo->id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                { data: 'description', name: 'expense_details.description' },
                { data: 'amount', name: 'amount',orderable:false,searchable:false },
                { data: 'created_at', name: 'created_at',orderable:false,searchable:false },
        ]
    });
  
    
});

var table=$('#item-table').DataTable({  
      scrollCollapse: true,
      responsive:'{{responsiveDataTable()}}',
      pagingType:'{{paginationType()}}',
      serverSide: true,
      paging: true,
     ajax:{
      url:'{{route("maintenance.show",$expenseInfo->id)}}',
      data:{type:'item'}
        },
            columns: [

                { data: 'name', name: 'name' },
                { data: 'description', name: 'expense_details.description' },
                { data: 'quantity', name: 'quantity',orderable:false,searchable:false },
                { data: 'price', name: 'price',orderable:false,searchable:false },
                { data: 'amount', name: 'amount',orderable:false,searchable:false },
                { data: 'measure', name: 'measure',orderable:false,searchable:false },
        ]
    });
  
  $('#tab-item').on('shown.bs.tab', function(event){

      table.draw();
      
  });

 

</script>
@endpush