@extends('layouts.app')
@section('content')
    @include('customers.modal')
    <!-- END PAGE HEADER-->
    <!-- BEGIN TAB PORTLET-->
    <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="Maintenance"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedproject" label="name"
                                      @search="onProjectSearch" :options="projectList">
                            </v-select>
                            <input type="hidden" name="project_id"
                                   v-model.number="(!selectedproject)?null:selectedproject.id">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control" id="range-to-example" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <!-- app -->
    <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="Maintenance"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                    </div>
                </div>

                <div class="row">
                    <div class="form-group">

                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectProject') </label>
                            <v-select class="vue-select2" v-model="selectedproject" label="name"
                                      @search="onProjectSearch" :options="projectList">
                            </v-select>
                            <input type="hidden" name="project_id"
                                   v-model.number="(!selectedproject)?null:selectedproject.id">
                        </div>

                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control" id="range-from-example2" name="from_date">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control" id="range-to-example2" name="to_date">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.MaintenanceList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('maintenance-export')
                    <button type="button" id="excell_all" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    <button type="button" id="print_pdf_all" class="btn btn-success"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    @endpermission

                    @permission('maintenance-create')
                    <a href="{{route('maintenance.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission

                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_all">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="maintenance">
                    <thead>
                        <tr>
                            <th>@lang('layout.ProjectName')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Rate')</th>
                            <th>@lang('layout.Free')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('groupCompanyFilter.select')
@push('scripts')
    <script>

        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#maintenance').DataTable({
                ajax: '{{route("maintenance.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:2}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'project_name', name: 'projects.name'},
                    {data: 'description', name: 'projects.description', orderable: false},
                    {data: 'Date', name: 'Date', searchable: false},
                    {data: 'unit', name: 'project_expenses.currency'},
                    {data: 'total', name: 'total', orderable: false, searchable: false},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'status', name: 'status', orderable: false, searchable: false},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });
        // register modal component
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
        new Vue({
            el: '#app',
            data: {
                showModal: false,
                selectedproject: null,
                projectList: [],

            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            'user_type': 'yes',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },

                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample: function () {



                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example").persianDatepicker(modelDate());
                            from = $("#range-from-example").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#print_pdf_all').on('click', function (e) {
            $('#show-modal').click();
            e.preventDefault();
        })

        new Vue({
            el: '#app2',
            data: {
                showModal: false,
                selectedproject: null,
                projectList: [],

            },
            methods: {
                onProjectSearch(search, loading) {
                    loading(true);
                    this.searchProject(search, loading, this);
                },

                //ajax call to get items
                searchProject(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            'search_column': 'name',
                            'table_name': 'projects',
                            'user_type': 'yes',
                            keyword: search,
                        }
                    })
                        .then(function (response) {
                            this.projectList = [];
                            if (response.data.length > 0) {
                                vm.projectList = response.data;
                                console.log('data', vm.projectList);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExample2: function () {



                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            var to, from;
                            to = $("#range-to-example2").persianDatepicker(modelDate());
                            from = $("#range-from-example2").persianDatepicker(modelDate());
                        });
                    })
                }
            },
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })

        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
    </script>
@endpush