@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">

@section('style')

<style>


</style>
@stop
@section('content')
@include("layouts.Cmodal")
<div class="row">
    <div class="portlet light bordered">
          <!-- BEGIN TAB PORTLET-->
          <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.Maintenance')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">
                          <div>
                            {{Form::open(['route' => 'maintenance.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                                  {{ csrf_field() }}
                               <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- BEGIN FORM-->
                                        <div class="form-body">
                                          <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                              <!-- begin inputs -->







                                            <div class="row">

											<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
												<div class="form-group">
													<div class="col-md-12">
														<label class="control-label"> @lang('layout.SelectProject')</label>
														<v-select label="name" v-model="selectedProject" :options="project_items"  @search="ProjectSearch"></v-select>
														<input type="hidden" name="project_id" :value="(!selectedProject)?null:selectedProject.project_id">
														<input type="hidden" name="expense_id" :value="(!selectedProject)?null:selectedProject.expense_account_id">
													</div>
												</div>
											</div>


                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Currency')</label>
                                                          <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                          <input type="hidden" name="currency" :value="selected_currency.code">
                                                      </div>
                                                  </div>
                                              </div>

                                               <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">

                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Rate')</label>
                                                           <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                      </div>
                                                  </div>
                                              </div>

                                            </div>

                                            <div class="row">
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Account')</label>

                                                           <v-select  label="name"  :options="approperiateBank" v-model="selected_banks"></v-select>
                                                           <input type="hidden" name="bank_account" :value="(this.selected_banks==null)?null:selected_banks.id">
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">

                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Date')</label>

                                                           <input type="text" name="date"  class="form-control date" autocomplete="off">
                                                      </div>
                                                  </div>
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                  <div class="form-group">
                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Description')</label>
                                                            <textarea  name="description" class="form-control" rows="1"></textarea>
                                                      </div>
                                                  </div>
                                              </div>
                                            </div>
                                            <div class="row">
                                             <div class="col-lg-4 col-md-10 col-sm-7 col-xs-12" style="">
                                              <div class="form-group">
                                               <div class="col-md-4">
                                                    <label class="mt-checkbox">
                                                      @lang('layout.Free')
                                                      <input type="checkbox" value="1" name="status">
                                                      <span></span>
                                                    </label>
                                              </div>
                                              </div>
                                            </div>
                                            </div>
                                              <!-- end inputs -->
                                          </div>
                                           <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                               <div class="dashboard-stat2 ">
                                                <table class="dashboard-tabel" width="100%">
                                              <tr>
                                                  <td>
                                                      <small>@lang('layout.Total'):</small>
                                                  </td>
                                                  <td class="text-right">
 
                                                      <span class="text-right" data-counter="counterup"
                                                      data-value="7800">
                                                      @{{ Number.parseFloat((subtotal+(otherExpense))).toFixed(precision())}}

                                                    </span>
                                                      <input type="hidden" name="total" :value="subtotal">
                                                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                  </td>
                                              </tr>
                                              <tr>
                                                  <td>
                                                      <small>@lang('layout.Sub-Total'):</small>
                                                  </td>
                                                  <td class="text-right">
                                                      <span class="text-right" data-counter="counterup"
                                                      data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                      <input type="hidden" name="total" :value="subtotal">
                                                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                  </td>
                                              </tr>
                                              <tr>
                                                  <td>
                                                      <small>@lang('layout.OtherSub-Total'):</small>
                                                  </td>
                                                  <td class="text-right">
                                                      <span class="text-right" data-counter="counterup"
                                                      data-value="7800">@{{ otherExpense.toFixed(precision())}}</span>
                                                      <input type="hidden" name="otherExpense" :value="otherExpense">
                                                      <input type="hidden" name="tTotal" :value="otherExpense+subtotal">
                                                      <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                  </td>
                                              </tr>
                                          </table>

                                               </div>

                                            <!-- end total -->
                                           </div>

                                          </div>

                                           <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                                            <div class="table-responsive333">
                                               <table id="table_content" class="table table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        <th>@lang('layout.Description') </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th style="min-width: 100px">@lang('layout.SalePrice') </th>
                                                        <th style="min-width: 100px">@lang('layout.Total') </th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="item.item" :options="temp_items" @click.native="addNew('inventory',index)" @search="onItemSearch"></v-select>
                                                            <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                                        </td>
                                                         <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                               <option value="null">@lang('layout.Select')</option>
                                                               <span v-if="(item.item != null)">
                                                                <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                  @{{site.site_name}}
                                                                </option> 
                                                              </span>
                                                            </select>

                                                            <input type="hidden" name="site_id[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td>
                                                           <input type="text" placeholder="@lang('layout.Description')" name="inventory_description[]" class="form-control">
                                                        </td>

                                                        <td>


                                                           <input type="number" name="inventory_qty[]" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
                                                        </td>

                                                        <td>
                                                        <!--    <input type="text" :value="(item.item==null)?null:saleItemQuantity(item.item,item.item.quantity)" class="form-control input-number" placeholder="@lang('layout.OnHand')"> -->
                                                           @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                        <td class="highlight">
                                                            <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                    @{{measure.measure_name}}
                                                                  </option> 
                                                                </span>


                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                          <div class="input-group">
                                                            <input type="number" name="inventory_price[]"  placeholder="@lang('layout.Price')"   :value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                                            <span class="input-group-addon">
                                                              @{{selected_currency.symbol}}
                                                            </span>
                                                          </div>

                                                        </td>
                                                        <td>
                                                               <div class="input-group">
                                                                  <input type="number" class="form-control inner_input"   :value="(item.item==null)?null:getItemTotals(item.item,selected_currency.rate, null,null,null,null,null,selected_currency.static_rate)" placeholder="@lang('layout.Total')" disabled>
                                                              <span class="input-group-addon" >
                                                                  <b>@{{selected_currency.symbol}} </b>
                                                              </span>
                                                               </div>
                                                        </td>
                                                        <td>
                                                             <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                          </div>
                                           <hr>
                                        <!-- end item -->


                                        <!-- begin other epense -->

                                              <div  v-if="other_expense.length>0" >
                                               <table id="table_content" class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="min-width: 130px">@lang('layout.Description') </th>
                                                        <th style="min-width: 100px">@lang('layout.Amount') </th>
                                                        <th></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                      <tr v-for="(item,index) in other_expense">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <input type="text" @keyup="addNew('other_expense',index)" v-on:click="addNew('other_expense',index)"   name="other_e_description[]" class="form-control">
                                                        </td>
                                                        <td class="highlight">
                                                            <input type="number" name="amount[]" v-model="(!item)?null:item.amount" class="form-control">
                                                        </td>
                                                         <td>
                                                             <span  v-on:click="deleteItem('other_expense',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                              </table>
                                            </div>
                                        <!-- end other expense --> 
                                           </div> 
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="!isError" @click="submitForm" class="btn green">@lang('layout.Submit')</button>
                                            <a href="{{route('maintenance.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                        </div>


                                </div>



                               {!! Form::close() !!}


                          </div>
                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
          </div>
          <!-- END TAB PORTLET-->
    </div>
</div>
@endsection
@push('scripts')


<script type="text/javascript">
      @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
  
  Vue.component('v-select', VueSelect.VueSelect);
  
  var currency={!! $currency !!};
  var banks = {!! $banks !!};
  var expense = {!! $expense !!}
  console.log('eee',this.expense);
  var v = new Vue({
    el: '#app',
    data: {
       showModal: false,
       defaultAmount:0,
       banks:banks,
       selected_expense:null,
       currency:currency,
       selected_currency: {!! json_encode(getHomeCurrency()) !!},
       rate:0,
       expenses: {!! $expense !!},
       expenseAmount: 0,
       totalExpense: null,
       expenseId: 0,
       discountFiled: 0,
       discountIsAmount:false,
       temp_items:[],
       totalAmountes: [],

	   project_items:[],
       selectedProject :null,

       newCost:[
       null,
       null,
       null,
       null],
       inventories:[
          {item:null},
          {item:null},
          {item:null},
          {item:null},
       ],
      other_expense:[
          {
            amount:null,
            description:null
        },
       ],


    },
    computed:{
      selectedRate()
      {
         this.rate= (this.selected_currency)?this.selected_currency.rate:0; 
      },


          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++)
                {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {

                        var quantity=this.inventories[i]['item']['quantity'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                          @if(systemConfig()[30] == 1) 
                           sum +=new_rate*quantity*this.selected_currency.static_rate / this.selected_currency.rate;
                          @else 
                           sum +=new_rate*quantity*this.selected_currency.rate;
                          @endif
                        }
                        else
                        {
                          @if(systemConfig()[30] == 1) 
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.static_rate / this.selected_currency.rate);
                          @else 
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                          @endif
                        }

                    }

                }
                //loop other_expense
                 // for(var o=0;o<this.other_expense.length;o++)
                 //  {
                 //    sum +=Number(this.other_expense[o].amount);

                 //  }

                return sum;
          },

          otherExpense: function()
          {
            var otherSum=0;
            for(var o=0;o<this.other_expense.length;o++)
            {
              otherSum +=Number(this.other_expense[o].amount);

            }
            return otherSum;
          },

          // check payed amount

            // check data validation
            isError: function ()
            {
                var isError = false;
                var flag=false;
                 // for (var i = 0; i < this.inventories.length; i++)
                 // {

                 //    if (this.inventories[i].item)
                 //    {
                 //      flag=true;
                 //      if(((this.inventories[i]['item']['rate'] <=0) ))
                 //      {
                 //        rate=this.inventories[i]['item']['rate'];
                 //        new_rate=this.inventories[i]['item']['new_rate'];
                 //        if(rate <=0 && new_rate <=0)
                 //        {
                 //             isError = true;
                 //        }

                 //      }
                 //    }
                 // }
                 if((this.inventories.length==0 && this.other_expense.length==0) || this.selected_currency==undefined || this.selected_currency==null || !this.selected_banks || this.selected_banks==null)
                 {
                    isError = true;
                 }
                return isError;


            },
            // filter the banks according to selected currency
            approperiateBank:function()
           {
                var bankCopy=this.banks.slice();
                var tempBank=bankCopy.filter((account)=>{
                    return (new RegExp(this.selected_currency.code.toLowerCase())).test(account.code.toLowerCase())
                });
                if(tempBank.length>0)
                {
                    this.selected_banks=tempBank[0];
                }
                return tempBank;
           },
    },
    mounted:function()
    {
      if(this.expenses)
      {
        this.selected_expense=this.expenses[0];
      }
    },
    methods:
    {
       // calculate item price based on measure change
       measureChange(index)
       {

           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;

            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

            }
       },


	   // Search Project

        ProjectSearch:_.debounce((search,loading)=>{
           v.project_items=[];
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'serarchProject',
              keyword:search,
            }
           })
           .then(function (response)
           {
             this.project_items=[];
             if(response.data.length>0)
             {
                v.project_items=response.data;
                console.log('test 22',v.project_items);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
        },getDebounceTime()),

           // calculate item price based on measure change

       // detect member change and searh
       memberChange()
       {
           if(this.selected_customer)
           {
            // get member contract
             this.contractSearch(this.selected_customer.id,this);
           }
       },
       // set new price
       setNewRate(type=null,index)
       {
          if(type=='inventory')
          {
              if(this.inventories[index].item)
              {
                @if(systemConfig()[30] == 1) 
                 this.inventories[index].item.new_rate = this.$refs.in[index].value/ this.selected_currency.static_rate * this.selected_currency.rate;
                 @else 
                 this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
                 @endif
              }
          }
          if(type=='service')
          {
              if(this.services[index].item)
              {
                @if(systemConfig()[30] == 1) 
                 this.services[index].item.new_rate = this.$refs.ser[index].value/ this.selected_currency.static_rate * this.selected_currency.rate;
                 @else 
                 this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.rate;
                @endif
              }
          }


       },

       //ajax call to get items
       onItemSearch:_.debounce((search,loading)=>{
           loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'itemSearchSale',
              keyword:search,
            }
           })
           .then(function (response)
           {
             v.temp_items=[];
             console.log('test 33',response.data);
             if(response.data.length>0)
             {
                v.temp_items=response.data;
                console.log('test 33',response.data);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),



       // end item search


       // generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null});
                }
             }
            if(type=='other_expense')
             {
                 if(this.other_expense[index+1]==undefined)
                {
                  this.other_expense.push({amount:null,description:null});
                }
             }

          }

       },

       // in here you can check and decide to allow duplicate bank for payment or not



       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {

             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
             if(type=='other_expense')
             {
                this.other_expense.splice(index,1);
             }

         }

       },
       // submit the form
       submitForm()
       {

          if(this.isError==true) {
            alert('there is no item');
            return false;
          }
          swal({
                title:"@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete)
                {
                    document.getElementById("sales-form").submit()

                }
                else
                {

                }
            });

        },
    },
        created(){
        this.expenseAmount = this.expenses[0].Amount;
        this.expenseId     = this.expenses[0].id;
    },

  });

</script>


@endpush