@extends('layouts.factor-master')
@section('content')
<?php
    $b = 1;
    $data_all = getCopyNumberFactorReceive();
?>
@foreach($data_all AS $d_all)
<h3 class="table-caption" style="text-align: center;">@lang('menu.DepositAndWithdrawal')</h3>
<table class="main-table">
    <tr>
        <th> @lang('layout.Customer')</th>
        <th> @lang('layout.Type')</th>
        <th> @lang('layout.Number')</th>
        <th> @lang('layout.ReferenceNumber')</th>
        <th> @lang('layout.ReferenceName')</th>
    </tr>
    <tr>
        <th class=""> {{ $loan->name}} </th>
        <th class=""> {{ __('type.' . $loan->type)}} </th>
        <th class=""> {{ $loan->loan_number}} </th>
        <th class=""> {{ $loan->ref_Number}} </th>
        <th class=""> {{ $loan->referencen_name}} </th>
    </tr>
</table>
@if(getHesabSabeqa() =='true')
<table class="main-table" style="margin-top: 1px;">
    <thead>
        <tr>
            <th> @lang('layout.Currency') | @lang('layout.Balance') </th>
            <th>@lang('layout.Receivable')</th>
            <th>@lang('layout.Payable')</th>
        </tr>
    </thead>
    <tbody>
        @foreach(getStatement($loan->member_id) as $value )
        @if($value['invoice'] > 0 || $value['payment'] > 0)
        <tr>
            <td class="center">
                {{$value['currency']}}
            </td>
            <td class="center">
                {{$value['invoice']}}
            </td>
            <td class="center">
                {{$value['payment']}}
            </td>
        </tr>
        @endif
        @endforeach
    </tbody>
</table>
@endif
<table class="main-table" style="margin-top: 2px;">
    <tr>
        <th> @lang('layout.Account')</th>
        <th> @lang('layout.Currency')</th>
        <th> @lang('layout.Rate')</th>
        <th> @lang('layout.Amount')</th>
        <th>@lang('layout.TotalInLeters')</th>
    </tr>
    <tr>
        <th class=""> {{ $loan->Account}} </th>
        <th class=""> {{ $loan->runit}} </th>
        <th class=""> {{ myRound($loan->payRate)}} </th>
        <th class=""><b> {{ myRound($loan->amount)}} </b> </th>
        <th>
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <span>{{notowo(abs(round($loan->amount)),'fa')}}</span>
            @else
            <span>{{notowo(abs(round($loan->amount)),'en')}}</span>
            @endif
        </th>
    </tr>
</table>
<table class="main-table" style="margin-top: 2px;">
    <thead>
        <tr>
            <th width="20%"> @lang('layout.Date') </th>
            <th width="20%">@lang('layout.Description')</th>
            @if(getcommission() =="true")
            <th width="10%"> @lang('layout.Commission') </th>
            @endif
            <th width="10%"> @lang('layout.ExchangedAmount') </th>
            
            {{-- <th width="40%">@lang('layout.MohrAndSignature')</th> --}}
        </tr>
    </thead>
    <tbody>
        <tr>
            <th>{{convertDate($loan->Date)}} --- {{$loan->Date}}</th>
            <th align="center">
                <?php
                $des = wordwrap($loan->description, 60, "<br/>\n", false);
                echo $des;
                ?>
            </th> 
            @if(getcommission() =="true")
            <th>{{myRound($loan->commission_amount)}} {{$loan->runit}}</th>
            @endif
            <th>{{myRound($loan->ExReamount)}} {{$loan->currency}}</th>
            {{-- <th style="height: 40px; float: left; text-align: left;">
                @if($loan->fingerprint != Null && $loan->fingerprint != '')
                <img src="{!!url('/uploads/fingerprint/'.$loan->fingerprint)!!}" style="width: 85px; height: 85px;">
                @endif
                <span>
                    <span>
                        @if(getUserSignature() == 'true') 
                            <span style="display:{{getUserSignature()}}  ">
                                @lang('layout.UserSignature')  
                            </span> 
                        @endif
                    </span>
                    <br>
                    <span>
                        @if(auth()->user()->signature)
                            @if(getUserSignature() == 'true')  
                                <img  src="{{public_path('/uploads/'. auth()->user()->signature)}}" width="70px" height="60px">
                            @endif   
                        @endif    
                    </span>  
                </span>
            </th> --}}
        </tr>
    </tbody>
</table>
@if(company()['exchange_message'])
<table width="100%">
    <tr>
        <th style="font-size: 14px;">{!!company()['exchange_message']!!}</th>
    </tr>
</table>
@endif
<!--  signature -->
<table class="main-table" style="margin-top: 20px;">
    <tr>
        <td style="text-align: left; width:10%; text-align: center; vertical-align:text-to">
            <i class=""></i> @lang('layout.User') : {{ $loan->user_name}}
        </td>  
        <td style="text-align: left; width:10%; text-align: center; vertical-align:text-to">
            <i class=""></i> @lang('layout.By') : {{ $loan->name}}
        </td>  
 
        @foreach(getCompanyInfo('sign','voucher') AS $info)
        <td style="text-align: left; width:10%; text-align: center;">
            <table >
                <tr>
                    <td align="right" style="height: 60px;border:none;vertical-align:text-to">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
        @break
        @endforeach  

    </tr>
    <tr>
          
        @foreach(getCompanyInfo('sign','voucher') AS $key => $value)
        @if($key == 0)
        @continue 
        @endif
        <td style="text-align: left; width:10%; text-align: center;">
            <table >
                <tr>
                    <td align="right" style="height: 80px;border:none;vertical-align:text-to">{{$value['name']}}</td>
                </tr>
            </table>
        </td>
        @endforeach                
                         
    </tr>
</table>
<!-- End signature -->
<?php
if ($b < count($data_all)) {
    echo "<pagebreak/>";
}
$b++;
?>
@endforeach
@endsection