@extends('layouts.app')
@section('content')
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.LoanDetails')
            </div>
            <div class=" pull-right hidden-print">
                <a type="button" class="btn green" name="btnprint" onclick="window.print()"  style="margin: 0px 5px 0px 5px"/><i class="fa fa-print"></i></a>
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover" id="loan_table" >
                    <thead> 
                        <tr>
                            <th>
                                <i class="fa  fa"></i> @lang('layout.ReferenceNumber') 
                            </th>
                            <th>
                                <i class="fa  fa-user"></i> @lang('layout.Name') 
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th> 
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                            </th> 
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.DueDate')
                            </th>
                            <th>
                                <i ></i> @lang('layout.ReferenceName')
                            </th>
                            @if(systemConfig()[20] == 1)
                            <th class="">
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Contract')
                            </th>
                            @endif
                            <th class="">
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                            </th>
                            <th> 
                                <i class="fa  "></i> @lang('layout.Amount') 
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Currency')
                            </th> 
                            <th>
                                <i class="fa "></i> @lang('layout.Rate')
                            </th> 
                    
                            <th>
                                <i class="fa "></i> @lang('layout.Type')
                            </th>  
                            <th>
                                <i class="fa "></i> @lang('layout.BillNumberCheque')
                            </th>  
                            <th>
                                <i class="fa "></i> @lang('layout.Category')
                            </th>    
                        </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class=""> {{ $loan->ref_Number}}  </td>
                        <td class=""> {{ $loan->name}}  </td>
                        <td class=""> {{ convertDate($loan->Date) }} </td>
                        @if(getHourType() == 24)
                        <td class=""> {{ (($loan->hour != null)?(date_format(date_create($loan->hour), 'H:i')):'') }} </td>
                        @else
                        <td class=""> {{ (($loan->hour != null)?(date_format(date_create($loan->hour), 'h:i a')):'') }} </td>
                        @endif
                        <td class=""> {{convertDate($loan->duedate)}} </td>
                        <td class=""> {{$loan->referencen_name}} </td>
                        @if(systemConfig()[20] == 1)
                        <td class=""> {{$loan->contract_name}} </td> 
                        @endif
                        <td class=""> {{$loan->Account}} </td> 
                        <td class=""> {{ $loan->amount}}  </td>
                        <td class=""> {{$loan->runit}}  </td>
                        <td class=""> {{$loan->payRate}}  </td>
                        <td class=""> @if($loan->type){{__('layout.'.ucfirst($loan->type))}}@endif </td>
                        <td class=""> {{$loan->bill_number}} </td>
                        <td class=""> @if($loan->category){{__('layout.'.ucfirst($loan->category))}}@endif </td>
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead> 
                        <tr>  
                            <th>
                                <i class="fa "></i> @lang('layout.Company')
                            </th>    
                            @if(getcommission() =="true")
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Commission')
                            </th> 
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Percentage') @lang('layout.Commission')
                            </th> 
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Type') @lang('layout.Commission')
                            </th> 
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Commission') @lang('layout.Description')
                            </th> 
                            @endif
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.MonetarySource')
                            </th> 
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.TransactionType')
                            </th> 
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Description')
                            </th> 
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Description')1
                            </th>  
                            <th>
                                <i class="fa fa-bars"></i> @lang('layout.Description')2
                            </th> 
                        </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        <td class=""> {{ $loan->company_name }}  </td>
                        @if(getcommission() =="true")
                        <td class=""> {{ $loan->commission_amount }}  </td>
                        <td class=""> {{ $loan->percentage }}  </td>
                        <td class=""> @if($loan->commission_type) @lang('layout.Income') @else @lang('layout.Expense') @endif </td>
                        <td class=""> {{ $loan->commission_description }}  </td>
                        @endif
                        <td class=""> {{ $loan->monetary_source }}  </td>
                        <td class=""> {{ $loan->trans_type }}  </td>
                        <td class=""> {{ $loan->description }}  </td>
                        <td class=""> {{ $loan->description1 }}  </td>
                        <td class=""> {{ $loan->description2 }}  </td>
                    </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover" id="loan_table" >
                    <thead> 
                        <tr>
                            @if(systemConfig()[29] == 1)
                            <th>
                                <i class="fa "></i> @lang('layout.TransactionConfirm')
                            </th> 
                            <th>
                                <i class="fa "></i> @lang('layout.Description')
                            </th>   
                            <th>
                                <i class="fa "></i> @lang('layout.Status')
                            </th>  
                            @endif      
                        </tr>
                    </thead>
                    <tbody>
                    <tr>  
                        @if(systemConfig()[29] == 1)
                        @if($loan->transaction_confirm)
                        <td class="">
                            @lang('layout.yes')
                        </td>
                        @else
                        <td class="">
                            @lang('layout.no')
                        </td>
                        @endif
                        <td class="">
                            {{$loan->position_description}}
                        </td>
                        <td class="">
                        @if($loan->position_status == 'accept')
                        @lang('type.accept')
                        @elseif($loan->position_status == 'true')
                        @lang('type.pending') &nbsp;&nbsp;&nbsp;&nbsp;
                        @if (getPositionCurrencyAmount() > $loan->exchanged_amount)
                        <form action="{{route('loan.position_status', ['id' => $loan->id, 'type' => 'accupt'])}}" method="post" class="inline">
                            <input type="hidden" name="_method" value="PATCH" />
                            <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                            <input type="text" name="position_description" required style="width: 40%;" />
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            <label class="mt-checkbox mt-checkbox-outline"  style="color: green;">
                                <input type="radio" value="accupt" required name="type"><span></span> @lang('layout.Accept')
                            </label>
                            &nbsp;&nbsp;
                            <label class="mt-checkbox mt-checkbox-outline" style="color: red;">
                                <input type="radio" value="reject" required name="type"><span></span> @lang('layout.Reject')
                            </label>
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            <button type="button" onclick="regForm(this)" class="btn btn-info " title="{{__('layout.Submit')}}" role="button">{{__('layout.Submit')}}</button>
                        </form>
                        {{-- &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; --}}
                        {{-- <form action="{{route('loan.position_status', ['id' => $loan->id, 'type' => 'false'])}}" method="post" class="inline">
                            <input type="hidden" name="_method" value="PATCH" />
                            <input type="hidden" name="_token" value="{{csrf_token()}}"/>
                            <input type="text" name="position_description" style="width: 35%;" />
                            <button type="button" onclick="regForm(this)" class="btn btn-warning " title="{{__('type.on')}}" role="button"><span class="fa fa-ban"></button>
                        </form>   --}}
                        @endif
                        @elseif($loan->position_status == 'reject')
                        @lang('type.Rejected')
                        @elseif($loan->position_status == 'false')
                        @lang('type.cancel')
                        @endif
                        </td>
                        @endif
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        @if($loan->runit!=$loan->currency)
            <h4>@lang('layout.ExchangedAmount')</h4>
            <div class="portlet-body">
                <div class="table-scrollable">
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                        <tr>
                            
                            <th> 
                                <i class="fa  "></i> @lang('layout.Amount') 
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Currency')
                            </th> 
                            <th>
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th> 
                            
                        </tr>
                        </thead>
                        <tbody>
                        <tr>  
                            <td class=""> {{ABS($loan->Examount)}}  </td>
                            <td class="">{{$loan->currency}}  </td>
                            <td class=""> {{$loan->Excurrency}} </td>

                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
</div>



    <div class="row hidden-print">
         <div class="tabbable tabbable-tabdrop">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
                @if(getInstallments()=="true")
                <li class="">
                    <a href="#tab3" data-toggle="tab" id="tab_invoice_payment">@lang('layout.Installments')</a>
                </li>
                @endif
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab2"> 
                        <div class="tab-pane" id="tab2"> 
                        <div class="portlet light bordered">
                    <div class="portlet-title">
                        <div class="caption font-dark">
                            <i class="icon-settings font-dark"></i>
                            <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <div class="col-md-9">
                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                                                <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data" style="padding: 0.5% 1%;">
                                                    @csrf
                                                    <input type="hidden" name="redirect_route" value="loan.show">
                                                    <input type="hidden" name="foreign_data_id" value="{{$loan->id}}">
                                                    <input type="hidden" name="path" value="uploads/Loan">
                                                    <input type="hidden" name="table_name" value="loans">
                                                    <div class="row">
                                                        <div class="col-lg-12">
                                                            <div class="form-group">
                                                                <label class="control-label"><i class="icon-settings font-dark"></i> @lang('layout.AttachmentTitle')</label>
                                                                <input type="text" name="title" class="form-control">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="8" style="resize: none;"></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                                    <div>
                                                                        <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            <input type="hidden" value="" name=""><input type="file" name="photo"> 
                                                                        </span>
                                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                    </div>
                                                                    <div class="fileinput-new thumbnail" style="width: 100%; height: 165px;">
                                                                        <img src="" alt=""> </div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 100%; max-height: 165px; line-height: 10px;"> 
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="margin-top-0 text-center">
                                                        <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                        <a href="{{route('receive.index')}}" class="btn default">@lang('layout.Cancel')</a>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                                                <form role="form" action="{{route('loan.store.fingerprint')}}" method="post" enctype="multipart/form-data" style="padding: 8% 1%;">
                                                    @csrf
                                                    <input type="hidden" name="loan_id" value="{{$loan->id}}">
                                                    <input type="hidden" name="path" value="uploads/fingerprint">
                                                        <div class="col-md-12">
                                                            <?php
                                                                $fingerprint = null;
                                                                if($loan && $loan->loan_fingerprint!=null)
                                                                {
                                                                    $fingerprint =  $loan->loan_fingerprint;
                                                                }
                                                            ?>
                                                            <div class="form-group">
                                                                <label class="control-label col-md-12 text-center"><i class="fa fa-thumbs-up"></i> @lang('layout.Fingerprint')</label>
                                                                <div class="fileinput fileinput-new" data-provides="fileinput" style="width: 100%;">
                                                                    <div>
                                                                        <span class="btn default btn-file">
                                                                            <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                            <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                            <input type="hidden" value="{{$fingerprint}}" name="loan_fingerprint1">
                                                                            <input type="file" name="loan_fingerprint"> </span>
                                                                        <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                                    </div>
                                                                    <div class="fileinput-new thumbnail" style="width: 100%; height: 150px;">
                                                                        <img src="{!!url('/uploads/fingerprint/'.$fingerprint)!!}" alt=""/>
                                                                    </div>
                                                                    <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> 
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                            
                                                    <div class="margin-top-10 text-center">
                                                        <button type="button" onclick="regForm(this)" class="btn green"> @lang('layout.Submit') </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </div>
                        <table class="table table-striped table-bordered table-hover" id="attachment">
                            <thead>
                            <tr>  
                            <th>@lang('layout.AttachmentTitle')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Action')</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab3">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Installments')</span>
                            </div>
                            <div class="tools"></div>
                                <div class="actions">
                                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="loan_installment"/>
                                    <input type="hidden" name="id" value="{{$loan->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                {{Form::close()}} 
        
                                    {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="loan_installment"/>
                                    <input type="hidden" name="id" value="{{$loan->id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                {{Form::close()}}  
                            </div>
                        </div>
                        
                        <div class="portlet-body">

                            <table class="table table-striped table-bordered table-hover" id="installment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Status') </th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


    </div>
</div>

 @endsection

 @push('scripts')

<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
          $('#attachment').DataTable({
                ajax:{
                    url:'{{route("loan.show",$loan->id)}}',
                    data:{type:'attachment'}
                  },
                
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    { data: 'title', name: 'attachments.title'},
                    { data: 'description', name: 'attachments.description'},
                    { data: 'actions',         name: 'actions', orderable:false,searchable:false},
            ]
        });


        $('#installment').DataTable({
            ajax: {
                    url: '{{route("loan.show",$loan->id)}}',
                    data: {type: 'installment'}
                },
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [ 
                { data: 'amount', name: 'amount', orderable:false,searchable:false  },
                { data: 'code', name: 'code', orderable:false,searchable:false  },
                { data: 'date', name: 'date', orderable:false,searchable:false  },
                { data: 'description', name: 'description', orderable:false,searchable:false  },
                { data: 'status', name: 'status', orderable:false,searchable:false  },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
                  ]
        });
    });
</script>
@endpush

 
