@extends('layouts.app')
@section('style')

@stop
@section('content')
    <div class="row" id="app">
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul> 
            </div>
        @endif 
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewContract') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'contract.store','method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }} 
                    <div class="form-body" v-cloak>
                        <div class="col-md-6">
                            <div class="col-md-12">
                                <label class="control-label ">@lang('layout.CompanyName')</label>
                                {{Form::text('name',null,['class' => 'form-control','placeholder' => __('layout.ContractName')])}}
                            </div>
                              <div class="col-md-6">
                                <label class="control-label">@lang('layout.Account')</label>
                                {{Form::select('account_id',$account,null,['class' => 'form-control'])}}
                            </div> 
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Amount')</label>
                                {{Form::number('amount',null,['class' => 'form-control'])}}
                            </div>
                            
                            <div class="col-md-12" style="padding: 0px;">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <select class="form-control" v-model="selectedCurrency">
                                        <option v-for="optionCurrency in currencyList"
                                            :value="optionCurrency">@{{optionCurrency}}
                                        </option> 
                                    </select>
                                    <input type="hidden" name="currency" v-bind:value="selectedCurrency"/>
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Rate')</label>
                                    {{Form::number('rate',null,['class' => 'form-control','min'=>'0'])}}
                                </div>
                            </div>
                        </div>  
                        <div class="col-md-6">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.ContractCode')</label>
                                {{Form::text('contract_no',null,['class' => 'form-control'])}}
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.SelectMember')</label>
                                {{Form::select('member_id',$member,null,['class' => 'form-control','placeholder' => __('layout.SelectMember')])}}
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Date')</label>
                                <input type="date" name="date" class="form-control">
                            </div>
                             <div class="col-md-6">
                                <label class="control-label">@lang('layout.Date')</label>
                                  <v-select :options="options"></v-select>
                            </div>

                             <div class="col-md-12">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => 'Description','class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                            </div> 
                        </div>
                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button type="submit" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('salaryDetails.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 
@endsection 
@push('scripts')
 
<script src="{{url('vue/vue@2.4.2.js')}}"></script>
<script src="{{url('vue/accounting.min.js')}}"></script>
<script src="{{url('vue/Sortable.js')}}"></script>
<script src="{{url('vue/select2/vue-select@2.2.0.js')}}"></script>

<script>
        var Currency = {!! $currency !!};
       
     Vue.component("v-select", VueSelect.VueSelect);
         
    new Vue({
        el: '#app',
        data: {
               selectedCurrency: {
                    id: parseInt('{{currency()->id}}'),
                    code: '{{getHomeCurrency()["code"]}}',
                    symbol: '{{getHomeCurrency()["symbol"]}}',
                    rate: '{{getHomeCurrency()["rate"]}}'
                },
                 options: [],

                currencyList: Currency,
            
        },
        computed: {
                  
            
            },
        methods: {
                
              
        }
    });   


</script>

@endpush
 