@extends('layouts.factor-master')
@section('content')
<h3 class="table-caption" style="text-align: center;">@lang('menu.DepositAndWithdrawal')</h3>

@if($info && $info !=[])
<table class="main-table">
      <tr>
          <td>@lang('layout.ReferenceNumber')</td>
          <td>@lang('layout.Name')</td>
          <td>@lang('layout.Date')</td> 
          <td>@lang('layout.Hour')</td> 
          <td>@lang('layout.DueDate')</td>
          <td>@lang('layout.Account')</td>
          <td>@lang('layout.Amount')</td>
          <td> @lang('layout.Currency')</td> 
          <td> @lang('layout.Rate')</td> 
          <td>@lang('layout.Type')</td>
      </tr>
  <tr>  
      <td > {{ $info->ref_Number}}  </td>
      <td > {{ $info->name}}  </td>
      <td > {{ convertDate($info->Date) }} </td>
      @if(getHourType() == 24)
      <td > {{ (($info->hour != null)?(date_format(date_create($info->hour), 'H:i')):'') }} </td>
      @else
      <td > {{ (($info->hour != null)?(date_format(date_create($info->hour), 'h:i a')):'') }} </td>
      @endif
      <td > {{convertDate($info->duedate)}} </td>
      <td > {{$info->Account}} </td> 
      <td > {{ $info->amount}}  </td>
      <td > {{$info->runit}}  </td>
      <td > {{$info->payRate}}  </td>
      <td > @if($info->type){{__('layout.'.ucfirst($info->type))}}@endif </td>
  </tr>
</table>
 @endif
<h3 class="table-caption" style="text-align: center;">@lang('layout.Installments')</h3>
<table class="report-table">


<tr class="bg">

<th> @lang('layout.Record') </th>
<th>@lang('layout.Amount')</th>
<th>@lang('menu.Currency')</th>
<th>@lang('layout.Status') </th>
<th>@lang('layout.Date')</th>
<th>@lang('layout.Description')</th>

</tr>
<?php
$count = 0;
foreach($data AS $record)
{
 $install_status = '';
 if($record->status ==0){
   $install_status = __('layout.Done');
 }
 elseif($record->status ==1){
  $install_status = __('layout.Undone');
 }
 elseif($record->status ==2){
  $install_status = __('layout.Canceled');
 }

?>
<tr>
<td class="center">{{++$count}}</td>

<td  class="center">{{$record->amount}}</td>
<td  class="center">{{$record->currency}}</td>
<td  class="center">{{$install_status}}</td>
<td  class="center">{{convertDate($record->date)}}</td>
<td  class="center">{{$record->description}}</td>
</tr>
<?php
}

?>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection