@extends('layouts.app')
@section('style')
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@stop
@section('content')
@include("layouts.Cmodal")
@include('loans.modal')
<style type="text/css">
    /* tr th {
        text-align: center;
    } */
    hr {
        border-top: 1px solid #b1adad;
    }
</style>
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'allLoanReports'" @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-3" >
                                            <label class="control-label ">@lang('layout.SelectClass')</label>
                                            <v-select class="vue-select2"
                                                      v-model="selected_class"
                                                      label="name"
                                                      :options="member_class">
                                            </v-select>
                                            <input type="hidden" name="class_id" :value="(!selected_class)?null:selected_class.id">
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.SelectMember') </label>
                                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="MemberSearch"  :options="member"> </v-select>
                                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="control-label ">@lang('layout.SelectType') </label>
                                            <select name="type_name" id="" class="form-control">
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="getLoan">@lang('layout.GetLoan')</option>
                                                <option value="payLoan">@lang('layout.PayLoan')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency" label="code" :options="currency" > </v-select>
                                            <input type="hidden" name="currency" v-bind:value="(!selectedCurrency)?null:selectedCurrency.code">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="control-label ">@lang('layout.ReferenceNumber') </label>
                                            <input type="text" name="ref_no" class="form-control" autocomplete="off" >
                                        </div>
                                    </div>
                                    <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                        @if(getFinancialClass() =='true') 
                                        @permission('financialClass-list')
                                        <div class="col-md-2">
                                            <label class="control-label"> @lang('menu.FinancialClass')</label>
                                            <select name="financial_class_id" class="form-control" >
                                                <option value="">@lang('layout.SelectClass')</option>
                                                <option value="Unclassified">Unclassified</option>
                                                <option v-for="cla in financial_classes" :value="cla.id" :key="cla.id" >@{{cla.name}}</option>
                                            </select>
                                        </div>
                                        @endpermission
                                        @endif
                                        <div class="col-md-2">
                                            <label class="control-label">@lang('layout.Category')</label>
                                            <select class="form-control" name="category" >
                                                <option value="">@lang('layout.SelectCategory')</option>
                                                <option value="salary">@lang('layout.Salary')</option>
                                                <option value="loan">@lang('layout.Loan')</option>
                                                <option value="prepaid">@lang('layout.Prepaid')</option>
                                                <option value="reward">@lang('layout.Reward')</option>
                                                <option value="personalPayAndReceive">@lang('layout.PersonalPayAndReceive')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <label class="control-label ">@lang('layout.Bank') </label>
                                            <v-select class="vue-select2"
                                                    v-model="selected_bank"
                                                    label="name"
                                                    :options="bank"
                                                    @search="searchAccount" >
                                            </v-select>
                                            <input type="hidden" name="bank_id" :value="(!selected_bank)?null:selected_bank.id">
                                        </div> 
                                        @if(systemConfig()[20] == 1)
                                        <div class="col-md-3">
                                            <label class="control-label">@lang('layout.ContractName')</label>
                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                    v-model="selectedContract" label="company_name"
                                                    :options="{{$contract}}">
                                            </v-select>
                                            <input type="hidden" name="id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                        </div>
                                        @endif
                                        <div class="col-md-2">
                                            <label class="control-label"> @lang('layout.Details')</label>
                                            <select name="as_person" class="form-control" >
                                                <option value="">@lang('layout.Select')</option>
                                                <option value="as_person"> @lang('layout.AsPersons') </option>
                                            </select>
                                        </div>
                                        
                                        @if(systemConfig()[29] == 1)
                                        <div class="col-md-1">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                    <input type="checkbox" name="transaction_confirm" value="On">
                                                    <span></span>
                                                </label>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                <div class="row" style="background-color: rgb(231, 227, 220); padding-bottom:15px;margin-top:10px">
                                    <div class="col-md-12">
                                        <label class="control-label ">@lang('layout.Number')</label>
                                        <div class="input-group">
                                          <input class="form-control" autocomplete="off" name="from_loan">
                                          <span class="input-group-addon"> @lang('layout.To') </span>
                                          <input class="form-control" autocomplete="off" name="to_loan">
                                        </div>
                                      </div>
                                </div>
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-8" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="loan_index">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn">
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    <!-- <label> @{{ row.Name }}</label>

                                                          <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                         <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                              <span class="slider round"></span>
                                                        </label> -->

                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
        </div>
    </report-modal>
</div>
<div class="row">
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                <div class="caption font-dark" >
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('menu.DepositAndWithdrawal') &nbsp; &nbsp; &nbsp; </span>
                </div>
            </div>
            <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12" style="display: flex; justify-content: center;" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn" style="background: #36c6d3;color: white;"  @Click="getData()"> @lang('layout.Search') </span>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                <div class="pull-right" >
                    <span onclick="getRecord();" class="btn blue">
                        <i class="fa fa-refresh"></i>
                    </span>
                    @permission(['loan-export'])
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
    
                    @permission('loan-create')
                    <a href="{{route('loantImport.create')}}">
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus "></i> @lang('menu.InventoryImport')
                        </button>
                    </a>
                    @endpermission  
                    <!-- <a href="{{route('loan.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a> -->
                    @permission(['loan-create'])
                    <span id="create-modal">
                        <a href="#" @click.prevent="showModal">
                            <button class="btn btn-success">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button>
                        </a>
                    </span>
                    @endpermission
                   
                </div>
            </div>
            
        </div>
        <div class="portlet-body">
            <template v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </template>
            <!-- BEGIN FORM-->
            @permission(['loan-create'])
            {!! Form::open(array('route' => 'loan.store','method'=>'POST','class'=>'form-horizontal','id'=>'loan-submit')) !!}
            {{ csrf_field() }}
            <div class="form-body  col-md-12" id="app" v-cloak>
                <div class="row" v-show="show_create" style="margin-bottom: 20px; border-bottom: 2px solid rgba(172, 171, 171, 0.877);padding-bottom: 20px;">
                    <div class="col-lg-8 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                        <input type="hidden" name="position_status" v-model="position_status" >
                        <div class="row" style="padding: 0.5% 1%;">
                            <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                                <div class="col-lg-3" v-show="showWhat('member_class')=='yes'">
                                    <label class="control-label">@lang('layout.MemberClass') </label>
                                    <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                    <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                </div>
                                <div class="col-lg-4">
                                    <label class="control-label ">@lang('layout.Member')</label>
                                    <div class="input-group">
                                        <v-select :class="selectMem + ' vue-select2 '" v-model="selectedMember" @input="getSummary()" label="name" :options="member" @search="MemberSearch" >
                                        </v-select>
                                        <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                        <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                            <i class="fa fa-plus" style="color: white"></i>
                                        </span> 
                                        @if (fingerprint() == 'true')
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="finger" @click="clearFinger('finger')" v-model="finger" placeholder="@lang('layout.Fingerprint')" >
                                            <span></span>
                                        </span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                    <div class="md-radio-inline" style="display: flex;justify-content: end">
                                        <div class="md-radio">
                                            <input type="radio" id="radio1" name="type" v-model="loanType" value="getLoan" class="md-radiobtn" :checked="loanType == 'getLoan'">
                                            <label for="radio1">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('layout.GetLoan') 
                                            </label>
                                        </div>
                                        <div class="md-radio">
                                            <input type="radio" id="radio2" name="type" v-model="loanType" value="payLoan" class="md-radiobtn" :checked="loanType == 'payLoan'">
                                            <label for="radio2">
                                                <span class="inc"></span>
                                                <span class="check"></span>
                                                <span class="box"></span> @lang('layout.PayLoan') 
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-2">
                                    <label class=" control-label">@lang('layout.BranchTransfer')</label>
                                    <div class="col-md-12 mt-checkbox">
                                        <label class="mt-checkbox mt-checkbox-outline">
                                            <input type="checkbox" name="branch_type" v-model="branch_type" value="on">
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-lg-12" >
                                    <div class="col-lg-12">
                                        <div class="row" v-if="branch_type" >
                                            <div class="col-md-12">
                                                <label class="control-label">@lang('layout.Company')</label>
                                                <v-select label="name" :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>
                                                <input type="hidden" name="company_id" :value="(!selected_company)?null:selected_company.id" >
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" v-model="number">
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.ReferenceName')</label>
                                    <input type="text" name="referencen_name" class="form-control">
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control" v-model='ref_no'>
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" id="getdate" class="form-control date" autocomplete="off" name="date" @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                    <span class="required">@{{ errors.first('date') }}</span>
                                </div> 
                            </div>
                            <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                                <div class="col-lg-3" style="padding: 0px !important;">
                                    <div :class="currency_len">
                                        <label class="control-label">@lang('layout.Currency')</label>
                                        <v-select v-model="selectedCurrency" label="code" :options="currency" @input="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                        <input type="hidden" name="currency" v-bind:value="selectedCurrency.code" />
                                    </div>
                                    <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':selectedCurrency.rate < 0}">
                                            <!-- <div class="input-group"> -->
                                            <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" 
                                            @keyup="check_code(paymentCurrency.code), get_exchange()" @click="check_code(paymentCurrency.code), get_exchange()" :readonly="averageRate">
                                            <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                            </div> -->
                                            <input type="hidden" name="currency_rate" :value="selected_rate">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.Amount') <span v-if="amount_to_word" class="text-danger">( @{{amount_to_word}} )</span></label>
                                    <vue-numeric
                                        class="form-control"
                                        v-model="amount"
                                        :max="99999999999999"
                                        :currency="selectedCurrency.code"
                                        :precision="precision()"
                                        @input="get_exchange(), getTranslateToWord(), calculateCamition()"
                                        >
                                    </vue-numeric>
                                    <input type="hidden" name="amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                    <span class="required">@{{ errors.first('amount') }}</span>
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.Account')</label>
                                    <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)" required v-validate="'required'" data-vv-as="@lang('layout.Account')">
                                        <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                        </option>
                                    </select>
                                    <span class="required">@{{ errors.first('account_id') }}</span>
                                </div>
                                <div class="col-lg-3">
                                    <span v-if="loanType == 'getLoan'" v-show="false">
                                        @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                    </span>
                                    <span v-else v-show="false">
                                        @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                    </span>
                                    <label class="control-label">@lang('layout.Balance')</label>
                                    <div class="input-group">
                                        <input class="form-control" disabled :value="balance.toFixed(precision())">
                                        <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                                <div class="col-lg-3" style="padding: 0px !important;">
                                    <div :class="pcurrency_len">
                                        <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                        <v-select v-model="paymentCurrency" label="code" :options="currency1" @input="setPaymentSize(paymentCurrency.code), get_exchange(), getTranslateToWordExchange()"> </v-select>
                                        <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code" />
                                    </div>
                                    <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                        <label class="control-label">@lang('layout.Rate') </label>
                                        <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                            <!-- <div class="input-group"> -->
                                            <input v-model="selected_rate1" class="form-control" type="number" min="0" step="any" @input="get_exchange()" :readonly="selectedCurrency.code==paymentCurrency.code">
                                            <!-- <span class="input-group-addon">@{{paymentCurrency.code}}</span>
                                            </div> -->
                                            <input type="hidden" name="rate" :value="selected_rate1">
                                        </div>
                                    </div>
                                </div>    
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                    <div class="input-group">
                                        <vue-numeric
                                            class="form-control"
                                            v-model="exchange_amount"
                                            :max="99999999999999"
                                            :currency="paymentCurrency.code"
                                            :precision="precision()"
                                            @input="set_rate(), getTranslateToWordExchange(), calculateCamition()">
                                        </vue-numeric>
                                        {{-- <input type="number" v-model="exchange_amount" @input="set_rate(), getTranslateToWordExchange()" class="form-control" min="0" step="any"> --}}
                                        {{-- <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(4)"> --}}
                                        <span class="input-group-addon">
                                            <input type="checkbox" name="change_amount" v-model="change_amount" title="{{ __('layout.SelectAmountByExchangedAmount') }}">
                                            <span></span>
                                        </span>
                                    </div>
                                    {{-- <span v-if="exchange_amount_to_word" >@{{exchange_amount_to_word}}</span> --}}
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.Category')</label>
                                    <select class="form-control" name="category" v-model="category" >
                                        <option disabled value="" >@lang('layout.SelectCategory')</option>
                                        <option value="salary">@lang('layout.Salary')</option>
                                        <option value="loan">@lang('layout.Loan')</option>
                                        <option value="prepaid">@lang('layout.Prepaid')</option>
                                        <option value="reward">@lang('layout.Reward')</option>
                                        <option value="personalPayAndReceive">@lang('layout.PersonalPayAndReceive')</option>
                                    </select>
                                </div>          
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.Hour')</label>
                                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                        @if(getHourType() == 24)
                                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @else
                                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                        @endif
                                        <span class="input-group-btn">
                                            <button class="btn default" type="button">
                                                <i class="fa fa-clock-o"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                                @if(getcommission() =="true")
                                    <div class="col-lg-3" v-show="!commission_type" >
                                        <label class="control-label">@lang('layout.Expense') </label>
                                        <div class="input-group">
                                            <v-select label="name" :options="expense" v-model="selectedExpense" ></v-select>
                                            <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="commission_type" v-model="commission_type" title="{{ __('layout.Income') }}">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div> 
                                    <div class="col-lg-3" v-show="commission_type" >
                                        <label class="control-label">@lang('layout.Income') </label>
                                        <div class="input-group">
                                            <v-select label="name" :options="income" v-model="selectedIncome" ></v-select>
                                            <input type="hidden" name="income_id" v-bind:value="(!selectedIncome)?null:selectedIncome.id" />
                                            <span class="input-group-addon">
                                                <input type="checkbox" name="commission_type" v-model="commission_type" title="{{ __('layout.Income') }}">
                                                <span></span>
                                            </span>
                                        </div>
                                    </div> 
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Commission')</label>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="commission_amount"
                                            :max="99999999999999"
                                            currency=" "
                                            :precision="precision()"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" name="commission_amount" v-bind:value="commission_amount" />
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Percentage') @lang('layout.Commission')</label>
                                        <input type="number" step="any" v-model="camition_percentage" @input="calculateCamition()" class="form-control" autocomplete="off" max="100" name="percentage">
                                   
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {{Form::textarea('commission_description',null,['class'=>'form-control','rows'=>'1'])}}
                                    </div>
                                @endif
                            </div>
                            <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;" >
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.DueDate')</label>
                                    <input type="text" id="dueDate" class="form-control date" autocomplete="off" name="dueDate">
                                </div>
                                @if(systemConfig()[20] == 1)
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.ContractName')</label>
                                        <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                v-model="selectedContract" label="company_name"
                                                :options="{{$contract}}">
                                        </v-select>
                                        <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                    </div>
                                @endif
                                <div class="col-md-2">
                                    <label class="control-label">@lang('layout.BillNumberCheque')</label>
                                    <input type="number" name="bill_number" class="form-control">
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.MonetarySource')</label>
                                        {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                </div>
                                <div class="col-lg-3">
                                    <label class="control-label">@lang('layout.TransactionType')</label>
                                        {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                </div>
                                @if(systemConfig()[29] == 1)
                                    <div class="col-lg-2">
                                        <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline"> 
                                                <input type="checkbox" name="transaction_confirm" value="On" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')" >
                                                <span></span>
                                            </label>
                                        </div>
                                        <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                    </div>
                                @endif
                                @if(getTelegramBot()=="true")
                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                        <label class="control-label"> <span class="fa fa-telegram" style="color:rgb(14 177 177);"></span> @lang('layout.Telegram')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="telegram" value="ok" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                @endif
                                @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')              
                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                        <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox"  name="whatsapp" value="5" />
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-12 col-sm-12" style="margin-bottom: 10px;"> 
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                            <div class="row">
                                <div class="col-lg-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('class' => 'form-control','v-model' => 'description_data', 'rows' => 1, 'cols' => 30)) !!}
                                    <span v-if="description1 == false" class="btn " @click="description1 = true">@lang('layout.More')....</button>
                                </div>
                            </div>
                            <div class="row" v-if="description1 == true">
                                <div class="col-lg-12">
                                    <label class="control-label">@lang('layout.Description')1</label>
                                    {!! Form::textarea('description1', null, array('class' => 'form-control','v-model' => 'description1_data', 'rows' => 1, 'cols' => 30)) !!}
                                    <span v-if="description2 == false" class="btn " @click="description2 = true">@lang('layout.More')....</button>
                                </div>
                            </div>
                            <div class="row"v-if="description2 == true" style="padding: 0% 0% 2% 0%;">
                                <div class="col-lg-12">
                                    <label class="control-label">@lang('layout.Description')2</label>
                                    {!! Form::textarea('description2', null, array('class' => 'form-control','v-model' => 'description2_data', 'rows' => 1, 'cols' => 30)) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;">
                            <div class="col-lg-12">
                                <div class="row">
                                    <div class="dashboard-stat2 col-md-12" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 5px;display: flex;justify-content: center;">
                                        <div v-if="selectedMember.photo" style="padding: 2px !important;" width="100%">
                                            <ul class="list-unstyled profile-nav" style="margin: 0px !important;">
                                                <li>
                                                    <div class="twPc-avatarLink">
                                                    <a :href="url+selectedMember.photo" target='_blank'>
                                                        <img class=" twPc-avatarImg" :src="url+selectedMember.photo" style=" width:200px; height:200px;border-radius: 10px;">
                                                    </a>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="dashboard-stat2" v-if="all_currency" style="margin-bottom: 0px; padding-bottom: 10px;">
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th colspan="2" style="background-color: #add8e6; text-align: center;">@lang('layout.TodayRate') </th>
                                                </tr>
                                                <tr>
                                                    <th style="background-color: #add8e6; text-align: center;">@lang('layout.Currency') </th>
                                                    <th style="background-color: #add8e6; text-align: center;">@lang('layout.Rate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span>
                                                    <tr v-for="crr in all_currency" style="text-align: center;">
                                                        <span v-if="selectedCurrency">
                                                            <td v-if="selectedCurrency.code == crr.code">
                                                                @{{ crr.code }}
                                                            </td>
                                                            <td v-if="selectedCurrency.code == crr.code">
                                                                @{{(crr.rate)}}
                                                            </td>
                                                        </span>
                                                        <span v-if="selectedCurrency && paymentCurrency">
                                                            <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                                @{{ crr.code }}
                                                            </td>
                                                            <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                                @{{(crr.rate)}}
                                                            </td>
                                                        </span>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="dashboard-stat2" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 10px;">
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th style="background-color: #add8e6;text-align: center;">@lang('layout.Currency') </th>
                                                    <th style="background-color: #add8e6;text-align: center;">@lang('layout.Payable')</th>
                                                    <th style="background-color: #add8e6;text-align: center;">@lang('layout.Receivable')</th>
                                                    <th style="background-color: #add8e6;text-align: center;">@lang('layout.AverageRate')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span>
                                                    <tr v-for="summ in summary" style="text-align: center;">
                                                        <td>
                                                            @{{ summ.currency }}
                                                        </td>
                                                        <td> @{{ format_number(Number(summ.payment)) }}</td>
                                                        <td> @{{format_number(Number(summ.invoice)) }} </td>
                                                        <td> @{{format_number(Number(summ.rate)) }} </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                            
                                        </table>
                                        @if(systemConfig()[22] == 1) 
                                        <br/>
                                        <table class="dashboard-tabel table-bordered" width="100%">
                                            <thead>
                                                <tr>
                                                    <th style="background-color: #add8e6;text-align: center;" v-if="selectedMember.risk_step">
                                                        @lang('layout.RiskStep')
                                                    </th>
                                                    <th v-if="selectedMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                    <th v-if="selectedMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                    <th v-if="selectedMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                                </tr>
                                            </thead>
                                        </table>    
                                        @endif
                                    </div>
                                </div>
                                <div class="row">
                                </div>
                            </div>
                        </div>
                    </div>
                    @if(getInstallments()=="true")
                    <!-- begin installment -->
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th style="background-color: rgb(84, 199, 211);color: #ffffff;text-align: center;">@lang('layout.Installments')</th>
                            </tr>
                            <tr>
                                <th class="text-center" style="min-width: 8px;background-color: rgb(84, 199, 211);color: #ffffff;" class="installment"> #</th>
                                <th class="text-center" style="min-width: 160px;background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Amount')</th>
                                <th class="text-center" style="min-width: 80px;background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Currency')</th>
                                <th class="text-center" style="min-width: 80px;background-color: rgb(84, 199, 211);color: #ffffff;"> @lang('layout.DueDate')</th>
                                <th class="text-center" style="min-width: 120px;background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Description')</th>
                                <th class="text-center" style="background-color: rgb(84, 199, 211);color: #ffffff;"><i class="fa fa-ellipsis-h"></i></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="(installment,index) in installments" class="text-center">
                                <td style="vertical-align: middle;">@{{index+1}}</td>
                                <td class="highlight" style="vertical-align: middle;">
                                    <input type="text" @click="addNew('installment',index)"
                                        name="installment_amount[]" class="form-control" autocomplete="off" tabindex="1">
                                </td> 
                                <td class="highlight" style="vertical-align: middle;">
                                    <v-select label="code" v-model="installment.item" :options="(installment.items)">
                                    </v-select>
                                    <input type="hidden" name="installment_currency[]" :value="(installment.item==null)?null:installment.item.code">
                                </td>
                                <td style="vertical-align: middle;">
                                    <date_picker :name="'installment_due_date['+index+']'" ></date_picker>
                                </td>
                                <td class="highlight" style="vertical-align: middle;">
                                    {{Form::textarea('installment_description[]',null,['class' => 'form-control','rows' => '1','@click'=>"addNew('installment',index)",'@keyup'=>"addNew('installment',index)"])}}
                                </td>
                                <td style="vertical-align: middle;">
                                    <span v-on:click="deleteItem('installment',index)" style="cursor: pointer;"><i class="paddint-both glyphicon glyphicon-trash text-danger"></i></span>
                                </td>
                            </tr>
                        </tbody>

                    </table>
                    <!-- end installment -->
                    @endif
                    <div class="row" v-show="show_create">
                        <div class="col-lg-12 text-center">
                            <br>
                            <button v-if="isError ==false" type="button" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                            <button v-if="isError ==false" type="button" class="btn blue" :disabled="disabled" @click="checkOldList($event)">@lang('layout.SaveAndNew')</button>
                            <a @click="show_create = false, clearData()" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>
                    <cmodal :show='showModal' @close="showModal=false">
                    </cmodal>
                </div>

                
            </div>
            {!! Form::close() !!}
            @endpermission

            <!-- END FORM-->

            <!-- start list -->
            <table class="table table-striped table-bordered table-hover" id="loan" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.Member')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Category')</th>
                        <th>@lang('layout.ReferenceName')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.DueDate')</th>
                        @if(systemConfig()[29] == 1)
                        <th>@lang('layout.Status')</th>
                        @endif
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>
<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    Vue.component("v-select", VueSelect.VueSelect);
    Vue.use(VueNumeric.default);
    function printVoucher(id,sendWhatsapp = null) {
        var a = document.createElement('a');
        a.href = "{{url('loanPrintVoucher')}}/" + id + "/" + sendWhatsapp;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
    function sendVoucherToWhatsapp(id,sendWhatsapp) {
        if (id && sendWhatsapp) {
			axios.get("{{url('loanPrintVoucher')}}/" + id + "/1", {
				// params: {
					// method_name: 'SearchMember',
					// class_id: class_id
				// }
			})
			.then(function(response) {
				// console.log(response);
				if (response.data) {
				if (sendWhatsapp == 1) {
					var a = document.createElement('a');
					a.href = "https://wa.me/?text=" + response.data;
					a.target = "_blank";
					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
				}
				if (sendWhatsapp == 2) {
					var a = document.createElement('a');
					a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
					a.target = "_blank";
					document.body.appendChild(a);
					a.click();
					document.body.removeChild(a);
				}
				}
			})
			.catch(function(error) {
				console.log(error);
			})
		}
    }

    /**
     * we load approperiat datable according
     * to it's site_id
     */
    var my_table = 0;
    $(document).ready(function() {
        getRecord();
    });

    function getRecord() {
        $.fn.dataTable.ext.errMode = '{{dataTableWarning()}}';
        if (my_table != 0) {
            my_table.destroy();
        }
        my_table = $('#loan').DataTable({
            ajax: {
                ajax: '{{route("loan.index")}}',
                data: {
                    from_date: vtr.from_date,
                    to_date: vtr.to_date
                }
            },
            pageLength: '{{getPageRows()}}',
            order: [
                ["{{orderByColumn()=='number'?0:12}}", "{{getRowOrder()}}"]
            ],
            responsive: '{{responsiveDataTable()}}',
            pagingType: '{{paginationType()}}',
            serverSide: true,
            destroy: true,
            paging: true,
            buttons: [{
                extend: 'excel',
                text: '',
                key: {
                    key: 'x',
                    altkey: true
                }
            }],
            columns: [{
                    data: 'loan_number',
                    name: 'loans.number'
                },
                {
                    data: 'ref_no',
                    name: 'loans.ref_no'
                },
                {
                    data: 'member_name',
                    name: 'member_name'
                },
                {
                    data: 'Account',
                    name: 'accounts.name'
                },
                {
                    data: 'amount',
                    name: 'transactions.amount'
                },
                {
                    data: 'currency',
                    name: 'transactions.unit'
                    // orderable: false,
                    // searchable: false
                },
                {
                    data: 'rate',
                    name: 'rate',
                    searchable: false
                },
                {
                    data: 'type',
                    name: 'loans.type',
                    searchable: false
                },
                {
                    data: 'category',
                    name: 'loans.category',
                    searchable: false
                },
                {
                    data: 'referencen_name',
                    name: 'referencen_name',
                    searchable: false
                },
                {
                    data: 'username',
                    name: 'users.name'
                },
                {
                    data: 'description',
                    name: 'loans.description'
                },
                {
                    data: 'Date',
                    name: 'loans.date'
                },
                {
                    data: 'hour',
                    name: 'loans.hour',searchable: false
                },
                {
                    data: 'dueDate',
                    name: 'dueDate',
                    searchable: false
                },
                @if(systemConfig()[29] == 1)
                {
                    data: 'position_status',
                    name: 'position_status',
                    searchable: false
                },
                @endif
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    }


    var member_class  = {!!$memberClass!!}
    // for new modal
    var cust_rep = {!!customeReportNewData('loan_index') !!};
    var currency2 ={!! $currency !!}
    var vu = new Vue({
        el: '#print-modal',
        data: {
            period: 'CustomDates',
            from_date: null,
            to_date: null,
            is_show: false,
            // pdfRoute: '{!!route("loan.report") !!}',
            // excelRoute: '{!! route("loan.report") !!}',
            pdfRoute: '{!!route('export.PDFAll') !!}',
            excelRoute: '{!! route('export.ExcelAll') !!}',
            selectedMember: null,
            member: [],
            date: null,
            selected_bank:null,
            selectedContract: null,
            bank:[],
            currency: currency2,
            selectedCurrency: null,
            financial_classes: {!!getFinancialClassList()!!},
            selected_class:null,
            member_class:member_class,
            customReportData: [
                {
                    Name: '@lang("layout.ReferenceNumber")',
                    column_name: 'reference_number',
                    checkedColumn: (cust_rep.reference_number) ? 'checked' : '',
                    column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''
                },
                {
                    Name: '@lang("layout.ReferenceName")',
                    column_name: 'referencen_name',
                    checkedColumn: (cust_rep.referencen_name) ? 'checked' : '',
                    column_percentage:(cust_rep.referencen_name___percent)?cust_rep.referencen_name___percent:''
                },
                {
                    Name: '@lang("layout.Type")',
                    column_name: 'type',
                    checkedColumn: (cust_rep.type) ? 'checked' : '',
                    column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''
                },
                {
                    Name: '@lang("layout.Description")',
                    column_name: 'description',
                    checkedColumn: (cust_rep.description) ? 'checked' : '',
                    column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''
                },
                {
                    Name: '@lang("layout.Date")',
                    column_name: 'date',
                    checkedColumn: (cust_rep.date) ? 'checked' : '',
                    column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''
                },
                {
                    Name: '@lang("layout.DueDate")',
                    column_name: 'due_date',
                    checkedColumn: (cust_rep.due_date) ? 'checked' : '',
                    column_percentage:(cust_rep.due_date___percent)?cust_rep.due_date___percent:''
                },

                {
                    Name: '@lang("layout.Member")',
                    column_name: 'member',
                    checkedColumn: (cust_rep.member) ? 'checked' : '',
                    column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'amount',
                    checkedColumn: (cust_rep.amount) ? 'checked' : '',
                    column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''
                },
                {
                    Name: '@lang("layout.Currency")',
                    column_name: 'currency',
                    checkedColumn: (cust_rep.currency) ? 'checked' : '',
                    column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''
                },
                {
                    Name: '@lang("layout.Rate")',
                    column_name: 'rate',
                    checkedColumn: (cust_rep.rate) ? 'checked' : '',
                    column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''
                },
                {
                    Name: '@lang("layout.Account")',
                    column_name: 'account',
                    checkedColumn: (cust_rep.account) ? 'checked' : '',
                    column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''
                },
                {
                    Name: '@lang("layout.Total")',
                    column_name: 'total',
                    checkedColumn: (cust_rep.total) ? 'checked' : '',
                    column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''
                },
                {
                    Name: '@lang("layout.User")',
                    column_name: 'user',
                    checkedColumn: (cust_rep.user) ? 'checked' : '',
                    column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''
                },
                {
                    Name: '@lang("layout.TransactionConfirm")',
                    column_name: 'transaction_confirm',
                    checkedColumn: (cust_rep.transaction_confirm) ? 'checked' : '',
                    column_percentage:(cust_rep.transaction_confirm___percent)?cust_rep.transaction_confirm___percent:''
                },
                {
                    Name: '@lang("layout.MonetarySource")',
                    column_name: 'monetary_source',
                    checkedColumn: (cust_rep.monetary_source) ? 'checked' : '',
                    column_percentage:(cust_rep.monetary_source___percent)?cust_rep.monetary_source___percent:''
                },
                {
                    Name: '@lang("layout.TransactionType")',
                    column_name: 'trans_type',
                    checkedColumn: (cust_rep.trans_type) ? 'checked' : '',
                    column_percentage:(cust_rep.trans_type___percent)?cust_rep.trans_type___percent:''
                },
                {
                    Name: '@lang("layout.BillNumberCheque")',
                    column_name: 'bill_number',
                    checkedColumn: (cust_rep.bill_number) ? 'checked' : '',
                    column_percentage:(cust_rep.bill_number___percent)?cust_rep.bill_number___percent:''
                },
                {
                    Name: '@lang("layout.ExchangeAmount")',
                    column_name: 'exchangeAmount',
                    checkedColumn: (cust_rep.exchangeAmount) ? 'checked' : '',
                    column_percentage:(cust_rep.exchangeAmount___percent)?cust_rep.exchangeAmount___percent:''
                },
                {
                    Name: '@lang("layout.ExchangedCurrency")',
                    column_name: 'exchangedCurrency',
                    checkedColumn: (cust_rep.exchangedCurrency) ? 'checked' : '',
                    column_percentage:(cust_rep.exchangedCurrency___percent)?cust_rep.exchangedCurrency___percent:''
                },
                {
                    Name: '@lang("layout.ExchangedRate")',
                    column_name: 'exchangedRate',
                    checkedColumn: (cust_rep.exchangedRate) ? 'checked' : '',
                    column_percentage:(cust_rep.exchangedRate___percent)?cust_rep.exchangedRate___percent:''
                },
                {
                    Name: '@lang("layout.Number")',
                    column_name: 'number',
                    checkedColumn: (cust_rep.number) ? 'checked' : '',
                    column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''
                },
                {
                    Name: '@lang("layout.Hour")',
                    column_name: 'hour',
                    checkedColumn: (cust_rep.hour) ? 'checked' : '',
                    column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''
                },
                {
                    Name: '@lang("layout.GetLoan")',
                    column_name: 'getLoan',
                    checkedColumn: (cust_rep.getLoan) ? 'checked' : '',
                    column_percentage:(cust_rep.getLoan___percent)?cust_rep.getLoan___percent:''
                },
                {
                    Name: '@lang("layout.Currency")',
                    column_name: 'perCurrency',
                    checkedColumn: (cust_rep.perCurrency) ? 'checked' : '',
                    column_percentage:(cust_rep.perCurrency___percent)?cust_rep.perCurrency___percent:''
                },
                {
                    Name: '@lang("layout.Amount")',
                    column_name: 'perAmount',
                    checkedColumn: (cust_rep.perAmount) ? 'checked' : '',
                    column_percentage:(cust_rep.perAmount___percent)?cust_rep.perAmount___percent:''
                },
                {
                    Name: '@lang("layout.DollarAmount")',
                    column_name: 'perDollarAmount',
                    checkedColumn: (cust_rep.perDollarAmount) ? 'checked' : '',
                    column_percentage:(cust_rep.perDollarAmount___percent)?cust_rep.perDollarAmount___percent:''
                },
                {
                    Name: '@lang("layout.AverageRate")',
                    column_name: 'perAverageRate',
                    checkedColumn: (cust_rep.perAverageRate) ? 'checked' : '',
                    column_percentage:(cust_rep.perAverageRate___percent)?cust_rep.perAverageRate___percent:''
                },

            ],
            cust_rep: cust_rep
        },
        methods: {
            closeModal: function() {
                this.is_show = !this.is_show
            },

            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vu.member = [];
                        vu.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            //ajax call to get dates
            getDates() {
                setTimeout((function () {
                vu.getDate(vu.period);
                    // console.log(12);
                }), 2e2);
            },
            getDate(period) {
                if (period) {
                // console.log(3232, period);
                if (period != 'CustomDates') {
                    axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getDatesByPeriod',
                        period: period,
                    }
                    })
                    .then(function(response) {
                    vu.from_date = null;
                    vu.to_date = null;
                    if (response.data) {
                        vu.from_date = response.data.start;
                        vu.to_date = response.data.end;
                        // console.log('data', response.data);
                    }
                    })
                    .catch(function(error) {
                    vu.period = 'CustomDates';
                    vu.from_date = null;
                    vu.to_date = null;
                    })
                } else {
                    vu.from_date = null;
                    vu.to_date = null;
                }
                }
            },
            //ajax call to get expense_categories
            searchAccount(search, loading) {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        keyword: search,
                        table_name: 'accounts',
                        filterColumn: 'type',
                        filterValue: 'bank',
                    }
                })
                .then(function (response) {
                    vu.bank = [];
                    if (response.data.length > 0) {
                        vu.bank = response.data;
                    }
                    loading(false);
                })
                .catch(function (error) {
                    console.log(error);
                })
            },
        }
    });

    var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
    });
    new Vue({
        el: '#anchore-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vu.$data.is_show = true;

            }
        }
    });

    new Vue({
        el: '#create-modal',
        methods: {
            showModal: function() {
                console.log('trr')
                vm.$data.show_create = true;

            }
        }
    });
    // /for new modal

    new Vue({
        el: '#company_ll',
        methods: {
            setCompany: function(event) {
                window.location.reload()
            }
        }
    });

    //begin new member
    var cm = Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }


                }).catch(error => console.log(error));
        },
        methods: {
            onSubmit() {

                vm.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();
                var addfinger = '';
                try {
                    addfinger = datas[5]['value']; 
                } catch (error) {
                }
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'addfinger': addfinger,
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },

                    dataType: 'json',

                }).done(function(response) {
                    if (response) {
                        if (addfinger) {
                            if (!response.addfinger) {
                                swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                            }else{
                                swal("{{__('message.AddFingerprintSC')}}");
                            }
                        }
                        vm.selectedMember = response.customer;
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });

    var Banks = {!! $bank!!}
    var Currency ={!! $currency!!}
    var memberClass = {!! $memberClass !!};
    var Currency1 ={!! $currency!!}
    var one = {!!json_encode(getHomeCurrency()) !!};
    var two = {!! json_encode(getHomeCurrency()) !!};
    var code = '{!! getHomeCurrency()["code"] !!}';
    let rates ={!! $rates !!};
    let all_currency = {!!$currencies!!};
    let company = {!!$company!!};

    var expense = [];
    var income = [];
    @if(getcommission() =="true")
        expense = {!! $expense !!};
        income = {!! $income !!};
    @endif

    var vm = new Vue({
        el: '#app',
        data: {
            expense: expense,
            selectedExpense: null,
            income: income,
            selectedIncome: null,
            company:company,
            selected_company:null,
            all_currency: all_currency,
            selectedCurrencyTemp: null,
            paymentCurrency: two,
            selectedContract: null,
            selectedCurrency2: null,
            // currency1:{!! json_encode(getCurrencies()) !!},
            camition_percentage: '',
            currency1: [],
            selected_rate: 0,
            selected_rate1: 0,
            exchange_amount: null,
            currency_len: 'col-md-12',
            rate_len: 'col-md-0',
            pcurrency_len: 'col-md-12',
            prate_len: 'col-md-0',
            first_currency: 0,
            second_currency: 0,
            lastAmount: null,
            date: null, 
            position_status: null,
            description1: false,
            description2: false,
            description_data: '',
            description1_data: '',
            description2_data: '',
            show_create: false,
            change_amount: false,
            commission_type: false,
            averageRate: false,
            code: code,
            selectedCurrency: one,
            currency: {!!json_encode(getCurrencies()) !!},
            bankes: {!!$banks!!},
            number: "{{$number}}",
            old_number: "{{$number}}",
            url: "{{asset('uploads/')}}/",
            image: 'avatar.png',
            selectedBank: null,
            defaultValue: 0,
            defaultAmount: 0,
            defaultAccount: 0,
            disabled: false,
            amount: null,
            amount_to_word: null,
            exchange_amount_to_word: null,
            balance: 0,
            loanType: 'getLoan',
            listAccounts: [],
            currencyList: Currency,
            selectedMember: null,
            type: 'bank',
            account: {},
            ref_no: '',
            msg: '',
            branch_type: false,
            isError: false,
            showModal: false,
            summary: [],
            memberClass: memberClass,
            selected_class: null,
            member: [],
            category: '',
            finger: null,
            fingerCounter: 0,
            selectMem:'',
            commission_amount:0,
            dynamic_time:'',
            time_interval:0,
            installments: [],
            installment_selected_currency: one
        },
        computed: {
            accountUpdate() {
                this.defaultAccount = null;
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                } else {
                    this.defaultValue = 0;
                }
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            this.defaultAccount = this.defaultValue;
                            @if(getAverageRate() =="true")
                            this.averageRate = false;
                            if (this.bankes[x].avg_rate && this.loanType == "payLoan") {
                                this.set_avg_rate(this.bankes[x].avg_rate);
                            }
                            @endif
                            break;
                        }
                    }

                }
                return test;
            },
            checkLoan() {
                var x = (this.loanType == 'getLoan') ? true : false;
                return x;
            },

        },
        mounted: function() { 
            this.setSize(this.selectedCurrency.code)
            this.dynamicTime()
            this.installments.push({
                items: this.currencyList,
                item: this.installment_selected_currency
            });

            // console.log(123, this.currency);
        },
        created() {
            this.setRates();
        },
        methods: { 
            // camition_percentage
            // amount
            calculateCamition(){
                var camition_percentage = this.camition_percentage;
                var amount = this.amount;
                if (camition_percentage && amount) {
                    this.commission_amount = (camition_percentage * amount) / 100;
                }
                else{
                    this.commiss_amount = '';
                }
            },

            //BEGIN - Used for dynamic input time
            dynamicTime()
                {
                    this.time_interval = setInterval(() => {
                        const now = new Date()
                        @if(getHourType() == 24)
                            const hours = now.getHours().toString().padStart(2,'0')
                            const minutes = now.getMinutes().toString().padStart(2,'0') 
                            // const seconds = now.getSeconds().toString().padStart(2,'0')
                            this.dynamic_time = `${hours}:${minutes}`
                        @else
                            const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                            this.dynamic_time = `${timeString}`
                        @endif
                        
                    },1000);
                },
                stopDynamicTime()
                {
                    clearInterval(vm.time_interval)
                },
                changeTime()
                {
                    vm.dynamic_time = vm.$refs.time_input.value
                },
                
                //END - Used for dynamic input time 

                setRates() { 
                let c = _.clone(Currency);
                let c1 = _.clone(Currency1);

                Currency = [];
                Currency1 = [];

                c.forEach((a) => {

                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });
                    });
                });

                c1.forEach((a) => {
                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency1.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });


                    });
                });

                // for ensuring for each currency rate is defined

                c.forEach((a) => {

                    let found = false;
                    Currency.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        Currency.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            static_rate: a.static_rate,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                c1.forEach((a) => {

                    let found = false;

                    Currency1.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }

                    });

                    if (!found) {
                        Currency1.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            static_rate: a.static_rate,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                this.currency = Currency;
                this.currency1 = Currency1;


            },
            getSummary() {
                if (vm.selectedMember) {
                    var id = vm.selectedMember.id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                vm.summary = response.data;
                            } else {
                                vm.summary = [];
                            }
                        })
                        .catch(function(error) {
                            vm.summary = [];
                            console.log(error);
                        });
                }
            },
            getTranslateToWord() {
                var vm = this;
                vm.amount_to_word = null;
                if (vm.amount) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'translateNumberToWord',
                            amount: vm.amount,
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(132, response.data, vm.amount);
                            vm.amount_to_word = response.data;
                            vm.getTranslateToWordExchange();
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }
            },
            getTranslateToWordExchange() {
                var vm = this;
                vm.exchange_amount_to_word = null;
                if (vm.exchange_amount) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'translateNumberToWord',
                            amount: vm.exchange_amount,
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(132, response.data, vm.amount);
                            vm.exchange_amount_to_word = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }
            },

            get_exchange() {
                var vv = this;
                if (vv.selected_rate > 0) {
                    @if(systemConfig()[30] == 1)
                    if (vv.paymentCurrency && vv.selectedCurrency) {
                        vv.exchange_amount = myRound(((vv.amount / vv.selectedCurrency.static_rate * vv.selected_rate) * vv.paymentCurrency.static_rate) / vv.selected_rate1);
                    }
                    @else
                        vv.exchange_amount = myRound((vv.amount * vv.selected_rate1) / vv.selected_rate);
                    @endif
                }
            },
            set_rate() {
                if (this.paymentCurrency.code == this.selectedCurrency.code) {
                    if (this.exchange_amount > 0 && this.amount > 0) {
                        this.amount = myRound(this.exchange_amount);
                    }
                } else if (this.paymentCurrency.code == this.code && !this.change_amount) {
                    if (this.exchange_amount > 0 && this.amount > 0) {
                        @if(systemConfig()[30] == 1)
                            this.selected_rate = Number.parseFloat((this.exchange_amount / this.amount) * this.selectedCurrency.static_rate).toFixed(7);
                        @else
                            this.selected_rate = Number.parseFloat((this.amount) / (this.exchange_amount)).toFixed(7);
                        @endif
                    }
                } else {
                    if (this.exchange_amount > 0) {
                        @if(systemConfig()[30] == 1)
                            if (this.change_amount && this.selected_rate1 > 0 && this.selected_rate > 0) {
                                this.amount = myRound(((this.exchange_amount / this.paymentCurrency.static_rate * this.selected_rate1) * this.selectedCurrency.static_rate) / this.selected_rate);
                            } else {
                                this.selected_rate1 = Number.parseFloat(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) / this.exchange_amount) * this.paymentCurrency.static_rate).toFixed(7);
                            }
                        @else
                            if (this.change_amount && this.selected_rate1 > 0 && this.selected_rate > 0) {
                                this.amount = myRound((this.exchange_amount / this.selected_rate1) * (this.selected_rate));
                            } else {
                                this.selected_rate1 = Number.parseFloat((this.exchange_amount) / (this.amount / this.selected_rate)).toFixed(7);
                            }
                        @endif
                    }
                }
            },
            setSize(selected_code) {
                this.paymentCurrency = this.selectedCurrency;
                this.selected_rate = this.selectedCurrency.exchange_rate;
                this.selected_rate1 = this.selectedCurrency.exchange_rate;
                if (selected_code == this.code) {
                    this.currency_len = 'col-md-12';
                    this.rate_len = 'col-md-0';
                } else {
                    this.currency_len = 'col-md-6';
                    this.rate_len = 'col-md-6';
                }
                this.pcurrency_len = this.currency_len;
                this.prate_len = this.rate_len;
            },
            setPaymentSize(selected_code) {
                // this.selected_rate = this.paymentCurrency.exchange_rate;
                this.selected_rate1 = this.paymentCurrency.exchange_rate;
                this.averageRate = false;
                if (selected_code == this.code) {
                    this.pcurrency_len = 'col-md-12';
                    this.prate_len = 'col-md-0';
                } else {
                    this.pcurrency_len = 'col-md-6';
                    this.prate_len = 'col-md-6';
                }
                @if(getAverageRate() =="true")
                if (this.selectedBank.avg_rate && this.loanType == "payLoan") {
                    this.selected_rate = this.selectedBank.avg_rate;
                    this.averageRate = true;
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selectedBank.avg_rate;
                    }
                }
                @endif
            },
            check_code(code) {
                if (this.paymentCurrency.code == this.selectedCurrency.code) {
                    this.selected_rate1 = this.selected_rate;
                }

            },

            clearFinger(fing) {
                setTimeout((function () {
                    vm.fingerCounter = 0;
                    var finger = vm.finger;
                    if (finger) {
                        if (finger && fing == 'finger') {
                            vm.selectedMember = null;
                        }
                        axios.get("{{route('callCheque.search')}}", {
                                params: {
                                    method_name: 'clearFinger',
                                }
                            })
                            .then(function(response) {
                                if (response.data) {
                                    vm.getFinger(fing)
                                } else {
                                    swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                                }
                            })
                            .catch(function(error) {
                                swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                            });
                    }
                }), 2e2);
            },
            getFinger(fing) {
                var finger = vm.finger;
                if (vm.fingerCounter < 20) {
                    vm.fingerCounter++; 
                    setTimeout((function () {
                        if (finger) {
                            axios.get("{{route('callCheque.search')}}", {
                                    params: {
                                        method_name: 'getFinger',
                                    }
                                })
                                .then(function(response) {
                                    // console.log(12, response.data);
                                    if (response.data) {
                                        axios.get("{{route('callMethod.search')}}", {
                                            params: {
                                                method_name: 'SearchMember', 
                                                id: response.data,
                                            }
                                        })
                                        .then(function(response1) {
                                            if (response1.data) {
                                                if (finger && fing == 'finger') {
                                                    vm.selectedMember = response1.data;
                                                    vm.selectMem = 'v_select_success';
                                                }
                                            }
                                        })
                                    } else {
                                        vm.getFinger(fing);
                                    }
                                })
                                .catch(function(error) {
                                    vm.getFinger(fing);
                                    console.log(error);
                                });
                        }
                    }), 3e3);
                } else {
                    if (finger && fing == 'finger') {
                        vm.selectMem = 'v_select_danger';
                    }
                    
                    swal({ title:"{{__('message.FDeviceNotConn')}}", dangerMode: true});
                }
            },

            memberClassChange() {
                if (vm.selected_class) {
                    vm.member = [];
                    vm.selectedMember = null;
                    let class_id = vm.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vm.member = [];
                            vm.member = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            checkRefNo() {

                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = vm.ref_no;
                if (ref_no != null) {



                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: vm.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'loans'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                // vm.temp_items=response.data;
                                vm.msg = "@lang('layout.DuplicateData')";
                                vm.isError = true;
                            } else {
                                vm.msg = 'no';
                                vm.isError = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },
 
            handleSubmit(e) {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                    vm.disabled = true; 
                    var loanType = this.loanType;
                    var date = document.getElementById('getdate').value;
                    var amount = this.amount;
                    var bank = this.defaultAccount;
                    if (loanType && this.selectedCurrency && this.selectedMember && amount && bank) {
                        var currencies = this.selectedCurrency.code;
                        var base_amount = 0;
                        @if(systemConfig()[30] == 1)
                            if (amount && this.selectedCurrency.rate > 0 && this.selectedCurrency.static_rate > 0) {
                                base_amount = myRound((amount * this.selectedCurrency.rate) / this.selectedCurrency.static_rate);
                            }
                        @else
                            if (amount && this.selectedCurrency.rate > 0) {
                                base_amount = myRound(amount / this.selectedCurrency.rate);
                            }
                        @endif
                        var member_id = this.selectedMember.id;
                    // console.log(12, base_amount);
                    axios.get("{{route('loans.checkOldValue')}}", {
                        params: {
                            loanType: loanType,
                            currencies: currencies,
                            base_amount: base_amount,
                            member_id: member_id,
                            date: date,
                            amount: amount,
                            bank: bank
                         }}).then(function (response) {
                            if (response.data) {
                                if (response.data.position && response.data.repeat) {
                                    swal({
                                    title: "{{__('layout.AmountIsMoreThenYourPermission')}} {{__('layout.And')}} {{__('layout.DuplicateData')}}",
                                    text: "",  
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    warningMode: true,
                                    })
                                    .then((willDelete) => {
                                        if (willDelete) {
                                            vm.position_status = true; 
                                            vm.disabled = false; 
                                            vm.submitForm1();
                                        } else {
                                            vm.disabled = false; 
                                        }
                                    });
                                } else if (response.data.position) {
                                    swal({
                                    title: "{{__('layout.AmountIsMoreThenYourPermission')}}",
                                    text: "",  
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    warningMode: true,
                                    })
                                    .then((willDelete) => {
                                        if (willDelete) {
                                            vm.position_status = true;
                                            vm.disabled = false; 
                                            vm.submitForm1();
                                        } else {
                                            vm.disabled = false; 
                                        }
                                    });
                                } else if (response.data.repeat) {
                                    swal({
                                    title: "{{__('layout.DuplicateData')}}",
                                    text: "",  
                                    icon: "warning",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                    warningMode: true,
                                    })
                                    .then((willDelete) => {
                                        if (willDelete) {
                                            vm.disabled = false; 
                                            vm.submitForm1();
                                        } else {
                                            vm.disabled = false; 
                                        }
                                    });
                                } else {
                                    vm.position_status = null;  
                                    vm.submitForm1();   
                                    vm.disabled = false;
                                }   

                                if (!response.data.position && !response.data.repeat) {     
                                    vm.submitForm1();   
                                    vm.disabled = false;                    
                                }                               
                            }else{                                
                                vm.submitForm1();   
                                vm.disabled = false;       
                            }
                         }) .catch(function (error) {
                            vm.disabled = false; 
                            console.log(error);
                        }) 
                        }
                        else {
                        vm.disabled = false;
                    } 
                }
                    });
            },

            submitForm1() {
                vm.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("loan-submit").submit()
                    } else {
                        vm.disabled = false;
                    }
                });
            },

            // chack_member_payable_levels
            member_chack() {
                var chack = 'false';
                if (vm.selectedMember && vm.paymentCurrency && vm.loanType == "payLoan") {
                    var member_id = vm.selectedMember.id;
                    var totals = Number.parseFloat(vm.exchange_amount);
                    var currency = vm.paymentCurrency.code;

                    $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async: false,
                        data: {
                            member_id: member_id,
                            method_name: 'Search_member_payable_levels',
                            currency: currency,
                        },
                        success: function(response) {
                            
                            var r_amount = Number.parseFloat(response.amount);
                            var r_m_amount = Number.parseFloat(response.m_amount);
                            var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                            // console.log(132, r_amount, totalss);
                            if (r_amount != 0 && r_amount < totalss) {
                                chack = 'true';
                            } else {
                                chack = 'false';
                            }
                        }.bind(this),

                        error: function(error) {
                            console.log(error)
                        }
                    });
                }
                return chack;
            },

            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            vm.disabled = true;
                            var url = "{{route('loan.store')}}";
                            form_id = 'loan-submit';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    if (response.data.result == 1) {
                                        // $('#' + form_id).trigger('reset');
                                        toastr.success('', response.data.message);
                                        vm.number = Number(vm.old_number) + 1;
                                        vm.old_number = Number(vm.old_number) + 1;
                                        vm.clearData();
                                        vm.dynamicTime()

                                        getRecord();
                                        // location.reload();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                        vm.disabled = false;
                                    }
                                    vm.disabled = false;
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    vm.disabled = false;
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },


            checkOldList(){
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                    var loanType = this.loanType;
                    var date = document.getElementById('getdate').value;
                    var amount = this.amount;
                    var bank = this.defaultAccount; 
                    if (loanType && this.selectedCurrency && this.selectedMember && amount && bank) {
                    vm.disabled = true;
                    var currencies = this.selectedCurrency.code;
                    var base_amount = 0;
                    @if(systemConfig()[30] == 1)
                        if (amount && this.selectedCurrency.rate > 0 && this.selectedCurrency.static_rate > 0) {
                            base_amount = myRound((amount * this.selectedCurrency.rate) / this.selectedCurrency.static_rate);
                        }
                    @else
                        if (amount && this.selectedCurrency.rate > 0) {
                            base_amount = myRound(amount / this.selectedCurrency.rate);
                        }
                    @endif
                    var member_id = this.selectedMember.id;
                    axios.get("{{route('loans.checkOldValue')}}", {
                            params: {
                                loanType: loanType,
                                currencies: currencies,
                                base_amount: base_amount,
                                member_id: member_id,
                                date: date,
                                amount: amount,
                                bank: bank
                            }}).then(function (response) {
                                // console.log(response.data);
                                if (response.data) {
                                    if (response.data.position && response.data.repeat) {
                                        swal({
                                        title: "{{__('layout.AmountIsMoreThenYourPermission')}} {{__('layout.And')}} {{__('layout.DuplicateData')}}",
                                        text: "",  
                                        icon: "warning",
                                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                        warningMode: true,
                                        })
                                        .then((willDelete) => {
                                            if (willDelete) {
                                                vm.position_status = true; 
                                                vm.disabled = false; 
                                                vm.saveAndNew();
                                            } else {
                                                vm.disabled = false; 
                                            }
                                        });
                                    } else if (response.data.position) {
                                        swal({
                                        title: "{{__('layout.AmountIsMoreThenYourPermission')}}",
                                        text: "",  
                                        icon: "warning",
                                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                        warningMode: true,
                                        })
                                        .then((willDelete) => {
                                            if (willDelete) {
                                                vm.position_status = true;
                                                vm.disabled = false; 
                                                vm.saveAndNew();
                                            } else {
                                                vm.disabled = false; 
                                            }
                                        });
                                    } else if (response.data.repeat) {
                                        swal({
                                        title: "{{__('layout.DuplicateData')}}",
                                        text: "",  
                                        icon: "warning",
                                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Ok')"],
                                        warningMode: true,
                                        })
                                        .then((willDelete) => {
                                            if (willDelete) {
                                                vm.disabled = false; 
                                                vm.saveAndNew();
                                            } else {
                                                vm.disabled = false; 
                                            }
                                        });
                                    } else {     
                                        vm.position_status = null;
                                        vm.saveAndNew(); 
                                        vm.disabled = false;                    
                                    } 

                                    if (!response.data.position && !response.data.repeat) {     
                                        vm.saveAndNew(); 
                                        vm.disabled = false;                    
                                    }                               
                                }else{
                                    vm.saveAndNew(); 
                                }
                                // loading(false);
                            })
                            .catch(function (error) {
                                vm.disabled = false;
                                console.log(error);
                            }) 
                    } else {
                        vm.disabled = false;
                    }
                    
                }
                    });
                }, 

            onComplete: function() {
                document.getElementById("account-form").submit()
                //this.$emit('on-complete')
                //alert('Yay. Done!');
            },




            
            clearData: function() {
                // vm.loanType = 'getLoan';
                vm.amount = null;
                vm.ref_no = null;
                vm.selectedMember = null;
                vm.exchange_amount = null;
                vm.amount_to_word = null;
                vm.exchange_amount_to_word = null;
                vm.description_data = null;
                vm.description1_data = null;
                vm.description2_data = null;
            },
            submitform() {
                swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                    .then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("bill-submit").submit()
                        } else {}
                    });
            },
            test(defaultAccount) {
                this.averageRate = false;
                for (var x in this.bankes) {
                    for (z in this.bankes[x]) {
                        if (this.bankes[x][z] == defaultAccount && z == 'id') {
                            this.selectedBank = this.bankes[x];
                            @if(getAverageRate() =="true")
                            if (this.bankes[x].avg_rate && this.loanType == "payLoan") {
                                this.selected_rate = this.bankes[x].avg_rate;
                                this.averageRate = true;
                                if (this.paymentCurrency.code == this.selectedCurrency.code) {
                                    this.selected_rate1 = this.bankes[x].avg_rate;
                                }
                            }
                            @endif
                            break;
                        }
                    }

                }

            },
            set_avg_rate(avg_rate) {
                setTimeout(() => {
                    this.averageRate = true;
                    this.selected_rate = avg_rate;
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = avg_rate;
                    }
                }, 300);
            },
            // generic function for adding item to list
            addNew(type = null, index) {
                if (type != null) {
                    if (type == 'installment') {
                        if (this.installments[index + 1] == undefined) {
                            this.installments.push({
                                items: this.currencyList,
                                item: null,
                            });
                        }
                    }
                }

            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    if (type == 'installment') {
                        this.installments.splice(index, 1);
                    }
                }

            }
        }
    });
</script>


@endpush