@extends('layouts.app')
 
@section('content')
    <div class="row" id="app">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditLoan') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                   
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($loan, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['loan.update',$loan->id]]) !!}
                    <div class="form-body" id="app" v-cloak>
                        <div class="row">
                                <div v-show="showWhat('member_class')=='yes'"
                                 class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                            <label class="control-label">@lang('layout.MemberClass') </label>

                                            <v-select label="name" :options="memberClass"
                                                      v-model="selected_class"
                                                      @input="memberClassChange()"></v-select>
                                            <input type="hidden" name="class_id"
                                                   :value="!selected_class?null:selected_class.id">
                                    </div>
                                </div>
                            </div>
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.Member')</label>
                                    <v-select class="vue-select2" v-model="selectedMember" label="name"
                                                    :options="member">
                                            </v-select>
                                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.member_id"  v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{errors.first('member_id')}}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" value="{{$loan->loan_number}}" v-validate = "'required'" data-vv-as = "@lang('layout.Number')">
                                    <span class="required">@{{errors.first('number')}}</span>
                                </div>
                                 <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control"  @input="checkRefNo()" v-model='ref_no' >
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                            </div>
                            <div class="row">

                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Currency')</label>
                                    <select  class="form-control" v-model="selectedCurrency" v-on:change="changeRate()">
                                         <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                     </select>
                                    <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                </div> 
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>
                                </div>
                            </div>
                            <div class="col-md-12" style="padding: 0px;">
                                <div class="row">
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Rate')</label>
                                         <input  v-model="selectedRate" class="form-control"
                                                               type="number" min="0" step="any">
                                        <input type="hidden" name="rate" :value="selectedCurrency.exchange_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')">
                                         <span class="required">@{{ errors.first('rate') }}</span>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        {{Form::number('amount',null,['class' => 'form-control' ,'step' => 'any','min' =>'0','v-model'=>'amount','v-validate'=>'"required"','data-vv-as'=>__('layout.Amount')])}}
                                         <span class="required">@{{ errors.first('amount') }}</span>
                                    </div>
                                </div>
                                
                            </div>
                        </div>  
                        <div class="col-md-6">
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Type')</label>
                                <select class="form-control" name="type" v-model="loanType">
                                    <option value="getLoan">@lang('layout.GetLoan')</option>
                                    <option value="payLoan">@lang('layout.PayLoan')</option>
                                </select>
                            </div>
                            <div class="col-md-12">
                                <label class="control-label">@lang('layout.Balance')</label>
                                <span v-if="loanKind" v-show="false">
                                    @{{balance = Number(selectedBank.balance)+(Number(defaultAmount)-Number(amount))}}
                                </span>
                                <span v-else v-show="false">
                                    @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                </span>
                                
                                <input type="number" class="form-control" disabled :value="balance.toFixed(precision())">
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.Date')</label>
                                {{Form::text('Date',null,['class' => 'form-control date','id'=>'reg_date','autocomplete'=>'off'])}}
                            </div>
                            <div class="col-md-6">
                                <label class="control-label">@lang('layout.DueDate')</label>
                                {{Form::text('duedate',null,['class' => 'form-control date','id'=>'dueDates','autocomplete'=>'off'])}}
                            </div>
                             <div class="col-md-12">
                                <label class="control-label">@lang('layout.Description')</label>
                                {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                            </div> 
                        </div>
                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button v-if="isError ==false" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('loan.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 
@endsection 
@push('scripts') 
<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif


    Vue.component("v-select", VueSelect.VueSelect);
    var Member ={!!$member!!}
    var Banks     = {!! $bank!!}
    var Currency ={!! $currency!!}
    var memberClass = {!! $memberClass !!};
   var vm =  new Vue({
        el: '#app',
        data: {
            defaultAccount: "{{ $loan->account_id }}",
            selectedCurrency:{!! json_encode(Currency()->getCurrency()) !!},
            currency:{!!  json_encode(getCurrencies()) !!},
                selectedMember:{!!$loan!!},
                loan:{!! $loan !!},
                bankes: {!! $banks !!},
                selectedBank: null,
                defaultValue: 0,
                defaultAmount:{!! $loan->amount !!},
                defaultAccount: 0,
                amount:{!! $loan->amount !!},
                balance: 0,
                loanType: '{{$loan->type}}',
                loanKind: (this.loanType == 'getLoan')? true:false,
                currencyList: Currency,

                selectedRate:{!!$loan->rate!!},
                type: 'bank', 
                account: {},
                firstAccount: {!! $loan->account_id !!},
                ref_no: "{{$loan->ref_Number}}",
                msg: '',
                isError: false,

                memberClass: memberClass,
                selected_class: null,
                member: Member,
                all_member: Member
                 
        },
        computed: {
            accountUpdate() {
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                }else{
                    this.defaultValue = 0;
                }
                        
                        for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.firstAccount != -1){
                                    if(this.bankes[x][z] == this.firstAccount){
                                        this.selectedBank = this.bankes[x];
                                        this.defaultAccount = this.firstAccount;
                                        this.firstAccount = -1;
                                        break;
                                    } 
                                }
                                else if(this.bankes[x][z] == this.defaultValue){
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;
                                    break;
                                }
                            }

                        }
                return test; 

            },
            checkLoan(){
                var x = (this.loanType == 'getLoan')? true:false;
                return x;
            },

        },
        created(){
                this.checkSelected();
                if (this.loan) {
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.loan.class_id);
                }
            },
        methods: {
           memberClassChange() {
                vm.member = vm.all_member;
                if (vm.selected_class) {
                    vm.member = vm.all_member.filter((m) => {
                        return vm.selected_class.id == m.class_id;
                    });

                }
            },
        checkRefNo()
            {
                
                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = vm.ref_no;
               if(ref_no !=null){
             

          
                  axios.get("{{route('callMethod.search')}}",
                       {

                        params:{
                          ref_no:vm.ref_no,
                          method_name:'Search_ref_no',
                          table_name:'loans'
                        },
                       })
                       .then(function (response)
                       {
                        // console.log(response.data.result);
                         if(response.data.result!=null)
                         {
                            console.log(response.data.result);
                            // v.temp_items=response.data;
                           vm.msg = "@lang('layout.DuplicateData')";
                           vm.isError = true;
                         }
                         else
                         {
                           vm.msg = 'no';
                           vm.isError = false;

                         }
                        
                         
                       })
                       .catch(function (error)
                       {
                          console.log(error);
                       });
                     
                   }

            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
            checkSelected(){
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for(var x in allCarrencies){
                        for(z in allCarrencies[x]){
                            if(allCarrencies[x][z] == "{!! $loan->currency !!}"){ 
                                this.selectedCurrency = allCarrencies[x];
                                break;
                            }
                        }

                    }

                },
            onComplete: function () {
                document.getElementById("account-form").submit()
//                this.$emit('on-complete')
//                alert('Yay. Done!');
            },
             submitform (){
                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("bill-submit").submit()
                            } else {
                            }
                        });
            },
            test(defaultAccount){
                    for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == defaultAccount){
                                    this.selectedBank = this.bankes[x];
                                    break;
                                }
                            }

                        }

            },
            changeRate(){
                // alert(this.selectedCurrency.exchange_rate)
                this.selectedRate  = this.selectedCurrency.exchange_rate;
            },
        }
    });   
</script>

@endpush
