@extends('layouts.app')
@section('style')
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-haze bold uppercase">@lang('menu.DepositAndWithdrawal')</span>
                    @else
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.DepositAndWithdrawalEdit')</span>
                    @endif
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools"> 
                </div> 
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                @if($duplicate)
                {!! Form::model($loan, ['method' => 'post','class'=>'form-horizontal','route' => ['loan.store',$loan->id]]) !!}
                @else 
                {!! Form::model($loan, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['loan.update',$loan->id]]) !!}
                @endif
                <div class="form-body  col-md-12" v-cloak>
                    <div class="row" style="margin-bottom: 20px; border-bottom: 2px solid rgba(172, 171, 171, 0.877);padding-bottom: 20px;">
                        <div class="col-lg-8 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px;">
                            <div class="row" style="padding: 0.5% 1%;">
                                <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <div class="col-lg-3" v-show="showWhat('member_class')=='yes'" >
                                        <label class="control-label">@lang('layout.MemberClass') </label>
                                        <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                        <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                    </div>
                                    <div class="col-lg-4">
                                        <label class="control-label ">@lang('layout.Member')</label>
                                        <v-select class="vue-select2" v-model="selectedMember" @input="getSummary()" label="name" :options="member" @search="MemberSearch" >
                                        </v-select>
                                        <input type="hidden" name="member_id" :value="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                        <span class="required">@{{ errors.first('member_id') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label" for="form_control">@lang('layout.Type')</label>
                                        <div class="md-radio-inline" style="display: flex;justify-content: end">
                                            <div class="md-radio">
                                                <input type="radio" id="radio1" name="type" v-model="loanType" value="getLoan" class="md-radiobtn" checked="">
                                                <label for="radio1">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> @lang('layout.GetLoan') 
                                                </label>
                                            </div>
                                            <div class="md-radio">
                                                <input type="radio" id="radio2" name="type" v-model="loanType" value="payLoan" class="md-radiobtn">
                                                <label for="radio2">
                                                    <span class="inc"></span>
                                                    <span class="check"></span>
                                                    <span class="box"></span> @lang('layout.PayLoan') 
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <label class=" control-label">@lang('layout.BranchTransfer')</label>
                                        <div class="col-md-12 mt-checkbox">
                                            <label class="mt-checkbox mt-checkbox-outline">
                                                <input type="checkbox" name="branch_type" v-model="branch_type" value="on">
                                                <span></span>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-12">
                                        <div class="col-lg-12">
                                            <div class="row" v-if="branch_type" >
                                                <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.Company')</label>
                                                    <v-select label="name" :options="company" v-model="selected_company" placeholder="@lang('layout.Company')" :select-on-tab="true"></v-select>
                                                    <input type="hidden" name="company_id" :value="(!selected_company)?null:selected_company.id" >
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    @if($duplicate)
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="number" class="form-control" value="{{$duplicateNumber}}">
                                    </div>
                                    @else 
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number" name="number" class="form-control" value="{{$loan->loan_number}}">
                                    </div>
                                    @endif
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.ReferenceName')</label>
                                        <input type="text" class="form-control" name="referencen_name" value="{{$loan->referencen_name}}">
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                        <input type="text" name="ref_no" class="form-control"  v-model='ref_no'>
                                        <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Date')</label>
                                        @if(getDateRequired() == 'true')
                                        {{Form::text('Date',null,['class' => 'form-control date','id'=>'reg_date','autocomplete'=>'off','v-validate' =>'"required"','data-vv-as' => __('layout.Date')])}}
                                        <span class="required">@{{ errors.first('Date') }}</span>
                                        @else 
                                        {{Form::text('Date',null,['class' => 'form-control date','id'=>'reg_date','autocomplete'=>'off'])}}
                                        @endif
                                    </div>
                                </div>
                                <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <div class="col-lg-3" style="padding: 0px !important;">
                                        <div :class="currency_len">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <v-select v-model="selectedCurrency" label="code" :options="currency" @Click.native="setSize(selectedCurrency.code), get_exchange()"> </v-select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code" />
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <!-- <div class="input-group"> -->
                                                <input v-model="selected_rate" class="form-control" type="number" step="any" min="0" :readonly="averageRate"
                                                @keyup="check_code(paymentCurrency.code), get_exchange()" @click="check_code(paymentCurrency.code), get_exchange()">
                                                <!-- <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                                </div> -->
                                                <input type="hidden" name="currency_rate" :value="selected_rate">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Amount') <span v-if="amount_to_word" class="text-danger">( @{{amount_to_word}} )</span></label>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="amount"
                                            :max="99999999999999"
                                            :currency="selectedCurrency.code"
                                            :precision="precision()"
                                            @input="get_exchange(), getTranslateToWord(), calculateCamition()"
                                            >
                                        </vue-numeric>
                                        <input type="hidden" name="amount" class="form-control" v-model="amount" step="any" min="0" v-validate="'required'" data-vv-as="@lang('layout.Amount')">
                                        <span class="required">@{{ errors.first('amount') }}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{ Account.name }}
                                            </option>
                                        </select>
                                    </div>
                                    <div class="col-lg-3">
                                        <span v-if="loanKind" v-show="false">
                                            @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                        </span>
                                        <span v-else v-show="false">
                                            @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                        </span>
                                        <label class="control-label">@lang('layout.Balance')</label>
                                        <div class="input-group">
                                            <input class="form-control" disabled :value="balance.toFixed(precision())">
                                            <span class="input-group-addon">@{{selectedCurrency.code}}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <div class="col-lg-3" style="padding: 0px !important;">
                                        <div :class="pcurrency_len">
                                            <label class="control-label">@lang('layout.ExchangedCurrency')</label>
                                            <v-select v-model="paymentCurrency" label="code" :options="currency1" @Click.native="setPaymentSize(paymentCurrency.code), get_exchange(), getTranslateToWordExchange()"> </v-select>
                                            <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code" />
                                        </div>
                                        <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                                <!-- <div class="input-group"> -->
                                                <input v-model="selected_rate1" class="form-control" type="number" min="0" step="any" @input="get_exchange()" :readonly="selectedCurrency.code==paymentCurrency.code">
                                                <!-- <span class="input-group-addon">@{{paymentCurrency.code}}</span>
                                                </div> -->
                                                <input type="hidden" name="rate" :value="selected_rate1">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <vue-numeric
                                            class="form-control"
                                            v-model="exchange_amount"
                                            :max="99999999999999"
                                            :currency="paymentCurrency.code"
                                            :precision="precision()"
                                            @input="set_rate(), getTranslateToWordExchange()"
                                        >
                                        </vue-numeric>
                                            {{-- <input type="number" v-model="exchange_amount" @input="set_rate(), getTranslateToWordExchange()" class="form-control" min="0" step="any"> --}}
                                            {{-- <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(8)"> --}}
                                        {{-- <span v-if="exchange_amount_to_word" >@{{exchange_amount_to_word}}</span> --}}
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Category')</label>
                                        <select class="form-control" name="category" v-model="category" >
                                            <option disabled value="" >@lang('layout.SelectCategory')</option>
                                            <option value="salary">@lang('layout.Salary')</option>
                                            <option value="loan">@lang('layout.Loan')</option>
                                            <option value="prepaid">@lang('layout.Prepaid')</option>
                                            <option value="reward">@lang('layout.Reward')</option>
                                            <option value="personalPayAndReceive">@lang('layout.PersonalPayAndReceive')</option>
                                        </select>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.Hour')</label>
                                        <div class="input-group">
                                            @if(getHourType() == 24)
                                            <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$loan->hour}}">
                                            @else
                                            <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$loan->hour}}" >
                                            @endif
                                            <span class="input-group-btn">
                                                <button class="btn default" type="button">
                                                    <i class="fa fa-clock-o"></i>
                                                </button>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    @if(getcommission() =="true")
                                        <div class="col-lg-3" v-show="!commission_type">
                                            <label class="control-label">@lang('layout.Expense') </label>
                                            <div class="input-group">
                                                <v-select label="name" :options="expense" v-model="selectedExpense" ></v-select>
                                                <input type="hidden" name="expense_id" v-bind:value="(!selectedExpense)?null:selectedExpense.id" />
                                                <span class="input-group-addon">
                                                    <input type="checkbox" name="commission_type" v-model="commission_type" title="{{ __('layout.Income') }}">
                                                    <span></span>
                                                </span>
                                            </div>
                                        </div> 
                                        <div class="col-lg-3" v-show="commission_type" >
                                            <label class="control-label">@lang('layout.Income') </label>
                                            <div class="input-group">
                                                <v-select label="name" :options="income" v-model="selectedIncome" ></v-select>
                                                <input type="hidden" name="income_id" v-bind:value="(!selectedIncome)?null:selectedIncome.id" />
                                                <span class="input-group-addon">
                                                    <input type="checkbox" name="commission_type" v-model="commission_type" title="{{ __('layout.Income') }}">
                                                    <span></span>
                                                </span>
                                            </div>
                                        </div> 
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.Commission')</label>
                                            <input type="number" step="any" v-model="commission_amount" name="commission_amount" class="form-control">
                                        </div>
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.Percentage') @lang('layout.Commission')</label>
                                            <input type="number" step="any" v-model="camition_percentage" name="camition_percentage" @input="calculateCamition()" class="form-control" >
                                        </div>
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {{Form::textarea('commission_description',null,['class'=>'form-control','rows'=>'1'])}}
                                        </div>
                                    @endif
                                    
                                </div>
                                <div class="col-lg-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.DueDate')</label>
                                        {{Form::text('duedate',null,['class' => 'form-control date','id'=>'dueDates','autocomplete'=>'off'])}}
                                    </div>
                                    @if(systemConfig()[20] == 1)
                                        <div class="col-lg-3">
                                            <label class="control-label">@lang('layout.ContractName')</label>
                                            <v-select class="vue-select2" placeholder="@lang('layout.Select')"
                                                    v-model="selectedContract" label="company_name"
                                                    :options="{{$contract}}">
                                            </v-select>
                                            <input type="hidden" name="contract_id" v-model.number="(!selectedContract)?null:selectedContract.id" />
                                        </div>
                                    @endif
                                    <div class="col-md-2">
                                        <label class="control-label">@lang('layout.BillNumberCheque')</label>
                                        <input type="number" value="{{$loan->bill_number}}" name="bill_number" class="form-control">
                                        <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.MonetarySource')</label>
                                            {!! Form::text('monetary_source', null, array('placeholder' => __('layout.MonetarySource'),'class' => 'form-control')) !!}
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="control-label">@lang('layout.TransactionType')</label>
                                            {!! Form::text('trans_type', null, array('placeholder' => __('layout.TransactionType'),'class' => 'form-control')) !!}
                                    </div>
                                    @if(systemConfig()[29] == 1)
                                        <div class="col-lg-2">
                                            <label class=" control-label">@lang('layout.TransactionConfirm')</label>
                                            <div class="col-md-12 mt-checkbox">
                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                    <input type="checkbox" name="transaction_confirm" value="On" v-model="show_transaction_confirm_checked" v-validate="'required'" data-vv-as="@lang('layout.TransactionConfirm')" >
                                                    <span></span>
                                                </label>
                                            </div>
                                            <span class="required">@{{ errors.first('transaction_confirm') }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <!-- <div class="col-md-4">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model="loanType">
                                        <option value="getLoan">@lang('layout.GetLoan')</option>
                                        <option value="payLoan">@lang('layout.PayLoan')</option>
                                    </select>
                                </div> -->
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-12 col-sm-12" style="margin-bottom: 10px;">
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;margin-bottom: 1em;">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')</label>
                                        {!! Form::textarea('description', null, array('class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')1</label>
                                        {!! Form::textarea('description1', null, array('class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div> 
                                </div>
                                <div class="row" style="padding: 0% 0% 2% 0%;">
                                    <div class="col-lg-12">
                                        <label class="control-label">@lang('layout.Description')2</label>
                                        {!! Form::textarea('description2', null, array('class' => 'form-control','rows' => 1, 'cols' => 30)) !!}
                                    </div> 
                                </div>
                            </div>
                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;padding: 10px 0px;">
                                <div class="dashboard-stat2 col-lg-12" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 5px;">
                                    <div v-if="selectedMember.photo" style="padding: 2px !important;" width="100%">
                                        <ul class="list-unstyled profile-nav" style="margin: 0px !important;">
                                            <li>
                                                <div class="twPc-avatarLink text-center">
                                                <a :href="url+selectedMember.photo" target='_blank'>
                                                    <img class=" twPc-avatarImg" :src="url+selectedMember.photo" style=" width:200px; height:200px;border-radius: 10px;">
                                                </a>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="dashboard-stat2 col-lg-12" v-if="all_currency" style="margin-bottom: 0px; padding-bottom: 5px;" >
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th colspan="2" style="background-color: #add8e6; text-align: center;">@lang('layout.TodayRate') </th>
                                            </tr>
                                            <tr>
                                                <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                <th style="background-color: #add8e6;">@lang('layout.Rate')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="crr in all_currency">
                                                    <span v-if="selectedCurrency">
                                                        <td v-if="selectedCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td v-if="selectedCurrency.code == crr.code">
                                                            @{{(crr.rate)}}
                                                        </td>
                                                    </span>
                                                    <span v-if="selectedCurrency && paymentCurrency">
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{ crr.code }}
                                                        </td>
                                                        <td v-if="selectedCurrency.code != paymentCurrency.code && paymentCurrency.code == crr.code">
                                                            @{{(crr.rate)}}
                                                        </td>
                                                    </span>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="dashboard-stat2 col-lg-12" v-if="selectedMember" style="margin-bottom: 0px; padding-bottom: 5px;" >
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th style="background-color: #add8e6;">@lang('layout.Currency') </th>
                                                <th style="background-color: #add8e6;">@lang('layout.Payable')</th>
                                                <th style="background-color: #add8e6;">@lang('layout.Receivable')</th>
                                                <th style="background-color: #add8e6;text-align: center;">@lang('layout.AverageRate')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <span>
                                                <tr v-for="summ in summary">
                                                    <td>
                                                        @{{ summ.currency }}
                                                    </td>
                                                    <td>@{{ format_number(Number(summ.payment)) }}</td>
                                                    <td>@{{format_number(Number(summ.invoice)) }}</td>
                                                    <td>@{{format_number(Number(summ.rate)) }} </td>
                                                </tr>
                                            </span>
                                        </tbody>
                                    </table>
                                    @if(systemConfig()[22] == 1) 
                                    <br/>
                                    <table class="dashboard-tabel table-bordered" width="100%">
                                        <thead>
                                            <tr>
                                                <th style="background-color: #add8e6;text-align: center;" v-if="selectedMember.risk_step">
                                                    @lang('layout.RiskStep')
                                                </th>
                                                <th v-if="selectedMember.risk_step == 'High'" style="background-color: #ff5353;text-align: center;" > @lang('type.High')</th>
                                                <th v-if="selectedMember.risk_step == 'Medium'" style="background-color: #ffe291;text-align: center;" > @lang('type.Medium')</th>
                                                <th v-if="selectedMember.risk_step == 'Low'" style="background-color: #8aff9a;text-align: center;" > @lang('type.Low')</th>
                                            </tr>
                                        </thead>
                                    </table>    
                                    @endif
                                </div>
                            </div>
                        </div>
                        @if(getInstallments()=="true")
                        <!-- begin installment -->
                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover" >
                            <thead>
                                <tr>
                                    <th class="text-center" style="background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Installments')</th>
                                </tr>
                                <tr>
                                    <th class="text-center" style="min-width: 8px;background-color: rgb(84, 199, 211);color: #ffffff;" class="installment"> #</th>
                                    <th class="text-center" style="min-width: 160px;background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Amount')</th>
                                    <th class="text-center" style="min-width: 80px;background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Currency')</th>
                                    <th class="text-center" style="min-width: 80px;background-color: rgb(84, 199, 211);color: #ffffff;"> @lang('layout.DueDate')</th>
                                    <th class="text-center" style="min-width: 120px;background-color: rgb(84, 199, 211);color: #ffffff;">@lang('layout.Description')</th>
                                    <th class="text-center" style="background-color: rgb(84, 199, 211);color: #ffffff;"><i class="fa fa-ellipsis-h"></i></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="(installment,index) in installments">
                                    <td style="vertical-align: middle;">@{{index+1}}</td>
                                    <td style="vertical-align: middle;" class="highlight">
                                        <input type="text" @click="addNew('installment',index)"
                                            name="installment_amount[]" class="form-control" autocomplete="off" tabindex="1" v-model="(installment==null)?null:installment.amount">
                                    </td> 
                                    <td style="vertical-align: middle;" class="highlight">
                                        <v-select label="code" v-model="installment.item" :options="(installment.items)">
                                        </v-select>
                                        <input type="hidden" name="installment_currency[]" :value="(installment.item==null)?null:installment.item.code">
                                    </td>
                                    <td style="vertical-align: middle;">
                                        <date_picker :name="'installment_due_date['+index+']'" v-model="(installment==null)?null:installment.date" ></date_picker>
                                    </td>
                                    <td style="vertical-align: middle;" class="highlight">
                                        {{Form::textarea('installment_description[]',null,['class' => 'form-control','rows' => '1','@click'=>"addNew('installment',index)",'@keyup'=>"addNew('installment',index)",'v-model'=>'(installment==null)?null:installment.description'])}}        
                                    </td>
                                    <td style="vertical-align: middle;">
                                        <span v-on:click="deleteItem('installment',index)" style="cursor: pointer; display: flex; justify-content: center;">
                                            <i class="paddint-both glyphicon glyphicon-trash text-danger"></i>
                                        </span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <!-- end installment -->
                        @endif
                    </div>

                    <div class="row">
                        <div class="col-lg-12 text-center">
                            <br>
                            @if($duplicate  )
                            <button v-if="isError ==false" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            @else 
                            <button v-if="isError ==false" type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Update')</button>
                            @endif
                            <a href="{{route('loan.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            <hr />
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

    <script>
        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component('v-select', VueSelect.VueSelect)
        Vue.use(VueNumeric.default)

        var Banks ={!! $bank!!}
        var code = "{!! getHomeCurrency()["code"] !!}";
        var memberClass = {!! $memberClass !!};
        let all_currency = {!!$currencies!!};
        let company = {!!$company!!};
        var selectedInstallment = {!! $selectedInstallment !!};
        var installment_selected_currency = {!!json_encode(getHomeCurrency()) !!};
        var contract = {!! $contract !!};
        

        var expense = [];
        var income = [];
        @if(getcommission() =="true")
            expense = {!! $expense !!};
            income = {!! $income !!};
        @endif

        let vu = new Vue({
            el: '#app',
            data: {
                expense: expense,
                selectedExpense: null,
                income: income,
                show_transaction_confirm_checked: "{{$loan->transaction_confirm == 'On'}}",
                selectedIncome: null,
                all_currency: all_currency,
                selectedCurrency: null,
                paymentCurrency: null,
                summary: [], 
                selectedCurrency2: null,
                selectedContract: null,
                currency:[],
                currency1:[],
                bankes: {!! $banks !!},
                selectedBank: null,
                selected_rate:{!!$loan->payRate!!},
                selected_rate1:{!!$loan->Excurrency!!},
                defaultAccount: "{{ $loan->account_id }}",
                listAccounts: [],
                selectedMember:{!!$selectedMember!!},
                newAmount: null,
                amount:{!!$loan->amount!!},
                Examount:{!!$loan->Examount!!},
                selectedProject: null,
                change_amount: null,
                exchange_amount: null,
                amount_to_word: null,
                exchange_amount_to_word: null,
                averageRate: false,
                commission_type: false,
                url: "{{asset('uploads/')}}/",
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                selectedType: "{!! $loan->type !!}",
                defaultValue: 0,
                defaultAmount:{!!$loan->amount!!},
                firstAccount: "{{ $loan->account_id }}",
                ref_no: "@if($duplicate) {{$refNumber}} @else {{$loan->ref_Number}} @endif",
                msg: '',
                category: '',
                isError: false,
                branch_type: false,
                company:company,
                selected_company:null,
                payment_type: "{{$loan->payment_type}}",
                loan:{!! $loan !!},
                member:[],
                old_payment_type:"{{$loan->payment_type}}",
                summary: [],
                memberClass: memberClass,
                selected_class: null,
                loanType: '{{$loan->type}}',
                loanKind: (this.loanType == 'getLoan')? true:false,
                installments: [],
                selectedInstallment:selectedInstallment,
                installment_selected_currency:installment_selected_currency,
                camition_percentage: '',
                commission_amount: ''
            },
            computed: {
                accountUpdate() {
                    var b = _.clone(Banks)
                    var test = this.accounts = b.filter((account) => {
                        return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                    })
                    if (test.length > 0) {
                    this.defaultValue = test[0].id;

                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.firstAccount != -1) {
                                if (this.bankes[x][z] == this.firstAccount && z == 'id') {
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.firstAccount;
                                    this.firstAccount = -1;
                                    break;
                                }
                            }
                            else if (this.bankes[x][z] == this.defaultValue && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                this.defaultAccount = this.defaultValue;
                                break;
                            }
                        }

                    }
                    }else{
                        this.selectedBank = null;
                    }

                    return test;
                },

            },
            created() {
                this.checkSelected();
                if(this.loan)
                {
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.loan.class_id);
                    if (this.loan.branch_company_id) {
                        this.selected_company = _.find(this.company, (c) => c.id == this.loan.branch_company_id);
                        this.branch_type = true;
                    }

                    if(this.loan.expense_id)
                    {
                        this.selectedExpense = _.find(this.expense, (c) => c.id == this.loan.expense_id);
                    }
                    if(this.loan.income_id)
                    {
                        this.selectedIncome = _.find(this.income, (c) => c.id == this.loan.income_id);
                    }
                    if(this.loan.commission_type)
                    {
                        this.commission_type = this.loan.commission_type;
                    }

                    if(this.loan.category){
                        this.category = this.loan.category;
                    }
                }
                defaultValue = "{{ $loan->account_id }}";
				
				if(this.selected_rate > 0){
                    @if(systemConfig()[30] == 1)
                        if (this.paymentCurrency && this.selectedCurrency) {
                            this.exchange_amount = myRound(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) * this.paymentCurrency.static_rate) / this.selected_rate1);
                        }
                    @else
                        this.exchange_amount = myRound((this.amount* this.selected_rate1)/this.selected_rate);
                    @endif
                }
                this.currency = all_currency;
                this.currency1 = all_currency;
                this.getTranslateToWord();
            },
            mounted() {
                //Installment
                for(var i = 0; i< this.selectedInstallment.length; i++)
                {
                    var installmentCurrency;
                    for(var j = 0; j<this.all_currency.length;j++)
                    {
                        if(this.selectedInstallment[i].code == this.all_currency[j].code)
                        {
                            installmentCurrency = this.all_currency[j];
                        }
                    }
                    this.installments.push({
                        items:this.all_currency,
                        item: installmentCurrency,
                        description: selectedInstallment[i].description,
                        amount: selectedInstallment[i].amount,
                        date: selectedInstallment[i].date
                    });
                }

                for(var k = 1; k > this.selectedInstallment.length; k--)
                {
                    this.installments.push({
                        items: this.all_currency,
                        item:this.installment_selected_currency,
                        description:null,
                        amount:null,
                        date:null
                    });
                }
                @if($loan->contract_id != null)    
                    this.selectedContract = _.find(contract, (e) => e.id == {{$loan->contract_id}});
                @endif

                @if($loan->commission_amount)
                 this.commission_amount = {{$loan->commission_amount}}
                @endif
                @if($loan->comm_percentage)
                 this.camition_percentage = {{$loan->comm_percentage}};
                @endif
            },
            methods: {

                calculateCamition(){
                var camition_percentage = this.camition_percentage;
                var amount = this.amount;
                if (camition_percentage && amount) {
                    this.commission_amount = (camition_percentage * amount) / 100;
                }else{
                    this.commiss_amount = '';
                }
            },

                memberClassChange() {
                    if (vu.selected_class) {
                        vu.member = [];
                        // vu.selectedMember = null;
                        let class_id = vu.selected_class.id;
                    
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember',
                                class_id: class_id
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                vu.member = [];
                                vu.member = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                    }
                },
                MemberSearch: _.debounce((search, loading) => {
                    loading(true);
                    let class_id = (vu.selected_class != undefined) ? vu.selected_class.id : null;
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember', 
                            keyword: search,
                            class_id: class_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            vu.member = [];
                            vu.member = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
                }, getDebounceTime()),

                getSummary() {
                    if (vu.selectedMember) {
                        var id = vu.selectedMember.id;
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'memberStatment',
                                    member_id: id,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    vu.summary = response.data;
                                } else {
                                    vu.summary = [];
                                }
                            })
                            .catch(function(error) {
                                vu.summary = [];
                                console.log(error);
                            });
                    }
                },

                getTranslateToWord() {
                    var vm = this;
                    vm.amount_to_word = null;
                    if (vm.amount) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'translateNumberToWord',
                                amount: vm.amount,
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                // console.log(132, response.data, vm.amount);
                                vm.amount_to_word = response.data;
                                vm.getTranslateToWordExchange();
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }
                },
                getTranslateToWordExchange() {
                    var vm = this;
                    vm.exchange_amount_to_word = null;
                    if (vm.exchange_amount) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'translateNumberToWord',
                                amount: vm.exchange_amount,
                            }
                        })
                        .then(function(response) {
                            if (response.data) {
                                // console.log(132, response.data, vm.amount);
                                vm.exchange_amount_to_word = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }
                },


                checkRefNo() {

                    //console.log(vu.ref_no)

                    var chack = 'false';
                    var ref_no = vu.ref_no;
                    if (ref_no != null) {


                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    ref_no: vu.ref_no,
                                    method_name: 'Search_ref_no',
                                    table_name: 'loans'
                                },
                            })
                            .then(function (response) {
                                // console.log(response.data.result);
                                if (response.data.result != null) {
                                    console.log(response.data.result);
                                    // v.temp_items=response.data;
                                    vu.msg = "@lang('layout.DuplicateData')";
                                    vu.isError = true;
                                }
                                else {
                                    vu.msg = 'no';
                                    vu.isError = false;

                                }


                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    }

                },
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },

                get_exchange() {
                    var vv = this;
                    if (vv.selected_rate > 0) {
                        @if(systemConfig()[30] == 1)
                        if (vv.paymentCurrency && vv.selectedCurrency) {
                            vv.exchange_amount = myRound(((vv.amount / vv.selectedCurrency.static_rate * vv.selected_rate) * vv.paymentCurrency.static_rate) / vv.selected_rate1);
                        }
                        @else
                            vv.exchange_amount = myRound((vv.amount * vv.selected_rate1) / vv.selected_rate);
                        @endif
                    }
                },
                set_rate() {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        if (this.exchange_amount > 0 && this.amount > 0) {
                            this.amount = myRound(this.exchange_amount);
                        }
                    } else if (this.paymentCurrency.code == this.code && !this.change_amount) {
                        if (this.exchange_amount > 0 && this.amount > 0) {
                            @if(systemConfig()[30] == 1)
                                this.selected_rate = Number.parseFloat((this.exchange_amount / this.amount) * this.selectedCurrency.static_rate).toFixed(7);
                            @else
                                this.selected_rate = Number.parseFloat((this.amount) / (this.exchange_amount)).toFixed(7);
                            @endif
                        }
                    } else {
                        if (this.exchange_amount > 0) {
                            @if(systemConfig()[30] == 1)
                                if (this.change_amount && this.selected_rate1 > 0 && this.selected_rate > 0) {
                                    this.amount = myRound(((this.exchange_amount / this.paymentCurrency.static_rate * this.selected_rate1) * this.selectedCurrency.static_rate) / this.selected_rate);
                                } else {
                                    this.selected_rate1 = Number.parseFloat(((this.amount / this.selectedCurrency.static_rate * this.selected_rate) / this.exchange_amount) * this.paymentCurrency.static_rate).toFixed(7);
                                }
                            @else
                                if (this.change_amount && this.selected_rate1 > 0 && this.selected_rate > 0) {
                                    this.amount = myRound((this.exchange_amount / this.selected_rate1) * (this.selected_rate));
                                } else {
                                    this.selected_rate1 = Number.parseFloat((this.exchange_amount) / (this.amount / this.selected_rate)).toFixed(7);
                                }
                            @endif
                        }
                    }
                },
                
                checkSelected() {
                    var allCarrencies = {!! json_encode(getCurrencies()) !!};
                    for (var x in allCarrencies) {
                        for (z in allCarrencies[x]) {
                            if (allCarrencies[x][z] == "{!! $loan->runit !!}") {
                                if (allCarrencies[x][z] != "{!! getHomeCurrency()['code'] !!}") {
                                    this.currency_len = 'col-md-6';
                                    this.rate_len = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                                // this.selected_rate    = this.selectedCurrency.exchange_rate;

                            }
                            if (allCarrencies[x][z] == "{!! $loan->currency !!}") {
                                if (allCarrencies[x][z] != "{!! getHomeCurrency()['code'] !!}") {
                                    this.pcurrency_len = 'col-md-6';
                                    this.prate_len = 'col-md-6';
                                }
                                this.paymentCurrency = allCarrencies[x];
                                // this.selected_rate1   = this.paymentCurrency.exchange_rate;

                            }
                        }
                    }

                },
                setSize(selected_code) {
                    this.averageRate = false;
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;

                    @if(getAverageRate() =="true")
                    if (this.selectedBank.avg_rate && this.loanType == "payLoan") {
                        this.selected_rate = this.selectedBank.avg_rate;
                        this.averageRate = true;
                        this.selected_rate1 = this.selectedBank.avg_rate;
                    }
                    @endif
                },
                setPaymentSize(selected_code) {
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;
                    this.averageRate = false;
                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                    @if(getAverageRate() =="true")
                    if (this.selectedBank.avg_rate && this.loanType == "payLoan") {
                        this.selected_rate = this.selectedBank.avg_rate;
                        this.averageRate = true;
                        if (this.paymentCurrency.code == this.selectedCurrency.code) {
                            this.selected_rate1 = this.selectedBank.avg_rate;
                        }
                    }
                    @endif
                },
                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                },
                test(defaultAccount) {
                    this.averageRate = false;
                    for (var x in this.bankes) {
                        for (z in this.bankes[x]) {
                            if (this.bankes[x][z] == defaultAccount && z == 'id') {
                                this.selectedBank = this.bankes[x];
                                @if(getAverageRate() =="true")
                                if (this.bankes[x].avg_rate && this.loanType == "payLoan") {
                                    this.selected_rate = this.bankes[x].avg_rate;
                                    this.averageRate = true;
                                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                                        this.selected_rate1 = this.bankes[x].avg_rate;
                                    }
                                }
                                @endif
                                break;
                            }
                        }
                    }
                },
                // generic function for adding item to list
                addNew(type = null, index) {
                    if (type != null) {
                        if (type == 'installment') {
                            if (this.installments[index + 1] == undefined) {
                                this.installments.push({
                                    items: this.all_currency,
                                    item: null,
                                });
                            }
                        }
                    }

                },
                // delete item from list
                deleteItem(type = null, index) {
                    if (type != null) {
                        if (type == 'installment') {
                            this.installments.splice(index, 1);
                        }
                    }

                }
            }
        });
    </script>


@endpush
 