@extends('layouts.app')
 
@section('content')
    <div class="row" id="app">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewLoan') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
               
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'loan.store','method'=>'POST','class'=>'form-horizontal','id'=>'loan-submit')) !!}
                {{ csrf_field() }} 
                    <div class="form-body" id="app" v-cloak>
                        <div class="row">
                        <div class="col-md-6">
                            <div v-show="showWhat('member_class')=='yes'"
                                class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                <div class="form-group">
                                        <label class="control-label">@lang('layout.MemberClass') </label>

                                        <v-select label="name" :options="memberClass"
                                                v-model="selected_class"
                                                @input="memberClassChange()"></v-select>
                                        <input type="hidden" name="class_id"
                                            :value="!selected_class?null:selected_class.id">
                                </div>
                            </div>
                        </div>
                        </div>
                        <div class="row">
                        <div class="col-md-6"> 
                            <div class="row">
                                 <div class="col-md-6">
                                    <label class="control-label ">@lang('layout.Member')</label>
                                      <v-select class="vue-select2" v-model="selectedMember" label="name"
                                                    :options="member">
                                     </v-select>
                                    <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id" v-validate="'required'" data-vv-as="@lang('layout.Member')">
                                    <span class="required">@{{ errors.first('member_id') }}</span>
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.Number')</label>
                                    <input type="number" name="number" class="form-control" v-model="number" >
                                </div>
                                <div class="col-md-3">
                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                    <input type="text" name="ref_no" class="form-control"  @input="checkRefNo()" v-model='ref_no' >
                                    <span v-if="isError ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                </div>
                            </div>
                          
                            
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                        <div :class="currency_len">
                                            <label class="control-label">@lang('layout.LoanCurrency')</label>
                                            <select class="form-control" v-model="selectedCurrency"
                                                    v-on:change="setSize(selectedCurrency.code), get_exchange()">
                                                <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/>
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="selected_rate" class="form-control"
                                                        type="number" step="any" min="0"
                                                        @keyup="check_code(paymentCurrency.code), get_exchange()">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="currency_rate" :value="selected_rate">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        <div class="input-group">
                                            <input type="number" name="amount" class="form-control" v-model="amount"
                                                step="any" min="0" v-validate="'required'"  @input="get_exchange()"
                                                data-vv-as="@lang('layout.Amount')">
                                            <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                        </div>
                                        <span class="required">@{{ errors.first('amount') }}</span>
                                    </div>

                            </div>  
                            <div class="row">
                                <div class="col-md-6" style="padding: 0px;">
                                        <div :class="pcurrency_len">
                                            <label class="control-label">@lang('layout.Currency')</label>
                                            <select class="form-control" v-model="paymentCurrency"
                                                    v-on:change="setPaymentSize(paymentCurrency.code), get_exchange()">
                                                <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="paymentCurrency"
                                                v-bind:value="paymentCurrency.code"/>
                                        </div>
                                        <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
                                                <div class="input-group">
                                                    <input v-model="selected_rate1" class="form-control"
                                                        type="number" min="0" step="any" @input="get_exchange()"
                                                        :readonly="selectedCurrency.code==paymentCurrency.code">
                                                    <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="rate" :value="selected_rate1">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                        <div class="input-group">
                                            <input type="number" v-model="exchange_amount" @input="set_rate()"
                                                class="form-control" min="0" step="any">
                                            <input type="hidden" :value="(amount*selected_rate1/(selected_rate)).toFixed(4)" >
                                            
                                            <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>

                                        </div>
                                    </div>
                            </div>
                        </div>  
                        <div class="col-md-6">
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select class="form-control" name="type" v-model="loanType">
                                        <option value="getLoan">@lang('layout.GetLoan')</option>
                                        <option value="payLoan">@lang('layout.PayLoan')</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Account')</label>
                                        <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                            <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                Account.name }}
                                            </option>
                                        </select>
                                </div>
                                <div class="col-md-6">
                                    <span v-if="checkLoan" v-show="false">
                                        @{{balance = Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))}}
                                    </span>
                                    <span v-else v-show="false">
                                        @{{balance = Number(selectedBank.balance)-(Number(amount)-Number(defaultAmount)) }}
                                    </span>


                                    <label class="control-label">@lang('layout.Balance')</label>
                                    <input type="number" class="form-control" disabled :value="balance.toFixed(precision())">              
                                </div>

                                
                            </div>
                            <div class="row">

                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.Date')</label>
                                    <input type="text" id="getdate" class="form-control date" autocomplete="off" name="date">
                                </div>
                                <div class="col-md-6">
                                    <label class="control-label">@lang('layout.DueDate')</label>
                                    <input type="text" id="dueDate" class="form-control date" autocomplete="off" name="dueDate">
                                </div>
                            </div>
                             <div class="row">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 2, 'cols' => 30)) !!}
                                </div>
                            </div> 
                        </div>
                    </div>


                    </div>
                    <div class="col-md-4 col-md-offset-4 text-center">
                        <br>
                        <button v-if="isError ==false" type="button" @click="handleSubmit($event)" class="btn green" >@lang('layout.Submit')</button>
                         <button v-if="isError ==false" type="button" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                        <a href="{{route('loan.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>           
                 
            <!-- END FORM-->
        </div>
    </div> 
@endsection 
@push('scripts') 
<script>
    
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif
    


    var Banks     = {!! $bank!!}
    var Member    ={!!$member!!}
    var Currency ={!! $currency!!}
    var memberClass = {!! $memberClass !!};
    Vue.component('v-select', VueSelect.VueSelect)


    var Currency1 ={!! $currency!!}
        var one = defaultCurrency();
        var two ={!! json_encode(Currency()->getCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";

        let rates =
                {!! $rates !!}



        
    var vm=new Vue({
        el: '#app',
        data: {


                // selectedCurrency: one,
                selectedCurrencyTemp: null,
                paymentCurrency: two,
                selectedCurrency2: null,
                // currency:{!! json_encode(getCurrencies()) !!},
                // currency1:{!! json_encode(getCurrencies()) !!},

                currency: [],
                currency1: [],

                selected_rate: 0,
                selected_rate1: 0,

                exchange_amount: null,

                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',

                first_currency: 0,
                second_currency: 0,
                lastAmount: null,
                code: code,



            selectedCurrency:{!! json_encode(Currency()->getCurrency()) !!},
            currency:{!!  json_encode(getCurrencies()) !!},
                bankes: {!! $banks !!},
                number:"{{$number}}",
                old_number:"{{$number}}",
                selectedBank: null,
                defaultValue: 0,
                defaultAmount:0,
                defaultAccount: 0,
                amount:null,
                balance: 0,
                loanType: 'getLoan',
                listAccounts:[],
                currencyList: Currency,
                selectedMember: null,
                type: 'bank',
                account: {},
                ref_no: '',
                msg: '',
                isError: false,

                memberClass: memberClass,
                selected_class: null,
                member: Member,
                all_member: Member
        },
        computed: {
            accountUpdate() {
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                if (test.length > 0) {
                    this.defaultValue = test[0].id;
                }else{
                    this.defaultValue = 0;
                }
                        for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == this.defaultValue && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;                                    break;
                                }
                            }

                        }
                return test;
            },
            checkLoan(){
                var x = (this.loanType == 'getLoan')? true:false;
                return x;
            },
            
        },
        mounted: function () {
               
                    this.setSize(this.selectedCurrency.code)

                // console.log(123, selected_banks, selected_currency);
            },
            created() {
                this.setRates();
            },
        methods: {
            setRates() {

                let c = _.clone(Currency);
                let c1 = _.clone(Currency1);

                Currency = [];
                Currency1 = [];

                c.forEach((a) => { 
                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });
                    });
                });

                c1.forEach((a) => {
                    rates.forEach((rate) => {

                        if (a.code == rate.code)
                            Currency1.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                exchange_rate: rate.rate,
                                rate: rate.rate,
                                hq_rate: rate.hq_rate
                            });


                    });
                });

                // for ensuring for each currency rate is defined

                c.forEach((a) => {

                    let found = false;
                    Currency.forEach((cur) => {
                        if (a.code == cur.code) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        Currency.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                c1.forEach((a) => {

                    let found = false;

                    Currency1.forEach((cur) => {
                        if(a.code == cur.code){
                            found = true;
                            return;
                        }

                    });

                    if (!found) {
                        Currency1.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            exchange_rate: 1,
                            rate: 1,
                            hq_rate: 1
                        });
                    }
                });

                this.currency  = Currency;
                this.currency1 = Currency1;


                },

            get_exchange() {
						if(vm.selected_rate > 0){
							vm.exchange_amount = myRound((vm.amount* vm.selected_rate1)/vm.selected_rate);
						}
					},
					set_rate() {
						if(vm.exchange_amount > 0){
							vm.selected_rate1 = myRound((vm.exchange_amount)/ (vm.amount / vm.selected_rate));
						}
				},
                setSize(selected_code) {
                    this.paymentCurrency = this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.selectedCurrency.exchange_rate;
                    if (selected_code == this.code) {
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len = this.currency_len;
                    this.prate_len = this.rate_len;
                },
                setPaymentSize(selected_code) {
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
                check_code(code) {
                    if (this.paymentCurrency.code == this.selectedCurrency.code) {
                        this.selected_rate1 = this.selected_rate;
                    }

                },

                

            memberClassChange() {
                    vm.member = vm.all_member;
                    console.log(vm.all_member);
                    if (vm.selected_class) {
                        console.log('test22', vm.selected_class);
                        vm.member = vm.all_member.filter((m) => {
                            return vm.selected_class.id == m.class_id;
                        });

                    }
                },

            checkRefNo()
            {
                
                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = vm.ref_no;
               if(ref_no !=null){
             

          
                  axios.get("{{route('callMethod.search')}}",
                       {

                        params:{
                          ref_no:vm.ref_no,
                          method_name:'Search_ref_no',
                          table_name:'loans'
                        },
                       })
                       .then(function (response)
                       {
                        // console.log(response.data.result);
                         if(response.data.result!=null)
                         {
                            console.log(response.data.result);
                            // v.temp_items=response.data;
                           vm.msg = "@lang('layout.DuplicateData')";
                           vm.isError = true;
                         }
                         else
                         {
                           vm.msg = 'no';
                           vm.isError = false;

                         }
                       })
                       .catch(function (error)
                       {
                          console.log(error);
                       });
                     
                   }
            },



            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
                saveAndNew()
      {
           this.$validator.validate()
          .then(valid =>{
              if(valid)
              { 
                var url="{{route('loan.store')}}";
                form_id='loan-submit';
                var data= $('#'+form_id).serialize();
                toggleBlock(true);
                axios.post(url,data)
                .then(function(response){
                        toggleBlock(0);
                         if(response.data.result==1)
                         {
                            $('#'+form_id).trigger('reset');
                            toastr.success('',response.data.message); 
                            vm.number=Number(vm.old_number)+1;
                            vm.old_number=Number(vm.old_number)+1;
                            vm.amount =null;
                            vm.ref_no =null;
                            vm.selectedMember=null;
                            // location.reload();
                         }
                         else
                         {
                            var message="{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('',message);
                         }
                })
                .catch(function(error){
                    toggleBlock(0);
                    console.log(error);
                    var message="{{__('message.Warning')}}";
                    //$('#error-sound')[0].play();
                    toastr.warning('',message);
                });
               
              }
          })
      },

             onComplete: function () {
                document.getElementById("account-form").submit()
            //                this.$emit('on-complete')
            //                alert('Yay. Done!');
            },
            submitform (){
                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("bill-submit").submit()
                            } else {
                            }
                        });
            },
            test(defaultAccount){
                    for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == defaultAccount && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    break;
                                }
                            }

                        }

            },
        }
    });   
</script>

@endpush
 