@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('loan_index');
$_type= !in_array('type', $report);
$_date= !in_array('date', $report);
$_due_date= !in_array('due_date', $report);
$_description= !in_array('description', $report);
$_member= !in_array('member', $report);
$_account= !in_array('account', $report);
$_amount= !in_array('amount', $report);
$_currency= !in_array('currency', $report);
$_rate= !in_array('rate', $report);
$_reference_number= !in_array('reference_number', $report);
$_total= !in_array('total', $report);
$_user= !in_array('user', $report);
$_transaction_confirm= !in_array('transaction_confirm', $report);
$_trans_type= !in_array('trans_type', $report);
$_monetary_source= !in_array('monetary_source', $report);
$_referencen_name= !in_array('referencen_name', $report);
$_bill_number= !in_array('bill_number', $report);
 

    $report_percent = customeReportNewPercent('loan_index');
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_due_date_percent= (array_key_exists('due_date___percent', $report_percent))?$report_percent['due_date___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_transaction_confirm_percent= (array_key_exists('transaction_confirm___percent', $report_percent))?$report_percent['transaction_confirm___percent']:null;
    $_monetary_source_percent= (array_key_exists('monetary_source___percent', $report_percent))?$report_percent['monetary_source___percent']:null;
    $_trans_type_percent= (array_key_exists('trans_type___percent', $report_percent))?$report_percent['trans_type___percent']:null;
    $_referencen_name_percent= (array_key_exists('referencen_name___percent', $report_percent))?$report_percent['referencen_name___percent']:null;
    $_bill_number_percent= (array_key_exists('bill_number___percent', $report_percent))?$report_percent['bill_number___percent']:null;
     
    ?>

<h3 class="table-caption" style="text-align: center;">@lang('menu.DepositAndWithdrawal')</h3>

@if($from_date || $to_date || $from_loan || $to_loan)
<table class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>

<table class="main-table">
    <tr>
         
      @if($from_loan)
      <td>
        <span>@lang('layout.From') @lang('layout.Number')</span>: {{$from_loan}}
      </td>
      @endif      
      @if($to_loan)
      <td>
        <span>@lang('layout.To') @lang('layout.Number')</span>: {{$to_loan}}
      </td>
      @endif 

    </tr>
</table>
@endif

@if($ClassName || $member_name || $currency || $category || $type_name || $bank_account_name || $contract_name || $member_class_name || $transaction_confirm)
<table class="main-table" style="margin: 6px 0px;" >
   
    <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif

      @if($member_class_name)
      <td>
        <span>@lang('layout.MemberClass')</span>: {{$member_class_name}}
      </td>
      @endif      
      
      @if($member_name)
      <td>
        <span>@lang('layout.Member')</span>: {{$member_name}}
      </td>
      @endif

      @if($currency)
      <td>
        <span>@lang('layout.Currency')</span>: {{$currency}}
      </td>
      @endif

      @if($category)
      <td>
        <span>@lang('layout.Category')</span>: {{__('layout.'.ucfirst($category))}}
      </td>
      @endif

      @if($type_name)
      <td>
        <span>@lang('layout.Type')</span>: {{__('layout.'.ucfirst($type_name))}}
      </td>
      @endif


      @if($bank_account_name)
      <td>
        <span>@lang('layout.Account')</span>: {{$bank_account_name}}
      </td>
      @endif
      
      @if($contract_name)
      <td>
        <span>@lang('layout.Contract')</span>: {{$contract_name}}
      </td>
      @endif

      @if($transaction_confirm)
      <td>
        <span>@lang('layout.TransactionConfirm')</span>:   @lang('layout.yes')
      </td>
      @endif
      
    </tr>
   
</table>
@endif

<br>
<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center" ><div >@lang('layout.Record')</div></td>
 @if($_reference_number)
  <td class="center"  @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif><div >@lang('layout.Number')</div></td>
 @endif
 @if($_referencen_name)
 <td class="center"  @if($_referencen_name_percent) width="{{$_referencen_name_percent}}%" @endif><div >@lang('layout.ReferenceName')</div></td>
 @endif
 @if($_reference_number)
  <td class="center"  @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif><div >@lang('layout.ReferenceNumber')</div></td>
 @endif
 
 @if($_date)<td class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>@endif
 @if($_date)<td class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.DistanceTime')</div></td>@endif
 @if($_description)<td class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif><div > @lang('layout.Description')</div></td>@endif
 @if($_bill_number)<td class="center"  @if($_bill_number_percent) width="{{$_bill_number_percent}}%" @endif><div > @lang('layout.BillNumberCheque')</div></td>@endif
 @if(!$type_name) @if($_type)<td class="center"  @if($_type_percent) width="{{$_type_percent}}%" @endif><div > @lang('layout.Type')</div></td>@endif @endif
 @if($_date)<td class="center"  ><div > @lang('layout.Hour')</div></td>@endif
 @if($_due_date)<td class="center"  @if($_due_date_percent) width="{{$_due_date_percent}}%" @endif><div > @lang('layout.DueDate')</div></td>@endif
 @if(!$category) @if($_type)<td class="center"  @if($_type_percent) width="{{$_type_percent}}%" @endif><div > @lang('layout.Category')</div></td>@endif @endif
 @if(!$member_name) @if($_member)<td class="center"  @if($_member_percent) width="{{$_member_percent}}%" @endif><div > @lang('layout.Member') </div></td>@endif @endif
 @if(!$bank_account_name) @if($_account)<td class="center"  @if($_account_percent) width="{{$_account_percent}}%" @endif><div > @lang('layout.Account')</div></td>@endif @endif
 @if($_amount)<td class="center"  @if($_amount_percent) width="{{$_amount_percent}}%" @endif><div > @lang('layout.GetLoan')</div></td>@endif
 @if($_amount)<td class="center"  @if($_amount_percent) width="{{$_amount_percent}}%" @endif><div > @lang('layout.PayLoan')</div></td>@endif
 @if(!$currency) @if($_currency)<td class="center"  @if($_currency_percent) width="{{$_currency_percent}}%" @endif><div > @lang('layout.Currency')</div></td>@endif @endif
 @if($_rate)<td class="center"  @if($_rate_percent) width="{{$_rate_percent}}%" @endif><div > @lang('layout.Rate')</div></td>@endif
 @if(!$transaction_confirm)
 @if(systemConfig()[29] == 1)
 @if($_transaction_confirm)<td class="center"  @if($_transaction_confirm_percent) width="{{$_transaction_confirm_percent}}%" @endif><div > @lang('layout.TransactionConfirm')</div></td>@endif
 <td class="center" ><div > @lang('layout.Status')</div></td>
 @endif
 @endif
 @if($_monetary_source) <td class="center"  @if($_monetary_source_percent) width="{{$_monetary_source_percent}}%" @endif><div > @lang('layout.MonetarySource')</div></td> @endif
 @if($_trans_type) <td class="center"  @if($_trans_type_percent) width="{{$_trans_type_percent}}%" @endif><div > @lang('layout.TransactionType')</div></td> @endif
 @if(getcommission() =="true") 
 <td class="center" ><div > @lang('layout.Commission') </td>
 <td class="center" ><div > @lang('layout.Type') @lang('layout.Commission') </td>
 @endif
 @if($_user)
 <td class="center"  @if($_user_percent) width="{{$_user_percent}}%" @endif ><div > @lang('layout.User')</div></td>
@endif
</tr>
</thead>
<?php
  $count = 0;
  $total_home_currency=0;
  $total_comm_amount=0;
  $currencies=[];

  //

  $deposit_total_home_currency=0;
  $deposit_currencies=[];

  $with_total_home_currency=0;
  $with_currencies=[];
  $colspan = 13;

?>
@foreach($allLoans AS $record)
<tr>
  <?php
    $total_home_currency+= (((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
    $total_comm_amount+= (((systemConfig()[30] == 1)?1:0)?($record->details->comm_amount/$record->details->static_rate*$record->details->loan_rate):($record->details->comm_amount / $record->details->loan_rate));
    
    if(array_key_exists($record->details->currency, $currencies))
    {
      $currencies[$record->details->currency]['amount']=$currencies[$record->details->currency]['amount']+$record->details->amount;
      $currencies[$record->details->currency]['base_amount']=($currencies[$record->details->currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
    }
    else
    { 
      $currencies[$record->details->currency]['amount']=$record->details->amount;
      $currencies[$record->details->currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
    } 
    //
    if($record->details->amount < 0){
      $with_total_home_currency+= (((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
      if(array_key_exists($record->details->currency, $with_currencies))
      {
        $with_currencies[$record->details->currency]['amount']=$with_currencies[$record->details->currency]['amount']+$record->details->amount;
        $with_currencies[$record->details->currency]['base_amount']=($with_currencies[$record->details->currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
      }
      else
      {
        $with_currencies[$record->details->currency]['amount']=$record->details->amount;
        $with_currencies[$record->details->currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
      }
    }
    else{
      $deposit_total_home_currency+= (((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
      if(array_key_exists($record->details->currency, $deposit_currencies))
      {
        $deposit_currencies[$record->details->currency]['amount']=$deposit_currencies[$record->details->currency]['amount']+$record->details->amount;
        $deposit_currencies[$record->details->currency]['base_amount']=($deposit_currencies[$record->details->currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
      }
      else
      {
        $deposit_currencies[$record->details->currency]['amount']=$record->details->amount;
        $deposit_currencies[$record->details->currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->details->amount/$record->details->static_rate*$record->details->loan_rate):($record->details->amount / $record->details->loan_rate));
      }
    }

    ?>
  <td class="center">{{++$count}}</td>
  @if($_reference_number)
    <td class="center">{{$record->details->number}}</td>
  @endif
  @if($_referencen_name)
    <td class="center">{{$record->details->referencen_name}}</td>
  @endif
  @if($_reference_number)
    <td class="center">{{$record->details->ref_Number}}</td>
  @endif

  @if($_date)<td  class="center">

    {{convertDate($record->details->Date)}}
    
  </td>@endif

  @if($_date)<td  class="center">

    {{$record->details->date_dif}} @lang('layout.Day')
    
  </td>@endif

  @if($_description)<td  style="@if($_description_percent) text-align: justify; @endif">

    {{$record->details->remark_fa .' '. $record->details->description}}


  </td>@endif

  @if($_bill_number)<td  class="center">{{$record->details->bill_number}}</td>@endif 
  @if(!$type_name) @if($_type)<td  class="center">{{__('layout.'.ucfirst($record->details->type))}}</td>@endif @endif

  @if($_date)
  <td  class="center">
  @if(getHourType() == 24)
  {{ (($record->details->hour != null)?(date_format(date_create($record->details->hour), 'H:i')):'') }}
  @else
  {{ (($record->details->hour != null)?(date_format(date_create($record->details->hour), 'h:i:a')):'') }}
  @endif
  </td>
  @endif
  @if($_due_date)<td  class="center">

  {{convertDate($record->details->dueDate)}}

  </td>@endif

  @if(!$category) @if($_type)<td  class="center">@if($record->details->category){{__('layout.'.ucfirst($record->details->category))}}@endif</td>@endif @endif
  @if(!$member_name) @if($_member)<td  class="center">{{$record->details->Member}}</td>@endif @endif
  @if(!$bank_account_name)  @if($_account)<td  class="center">{{$record->details->Account}}</td>@endif @endif
  @if($record->details->amount > 0)
  @if($_amount)<td  class="center">{{myRound($record->details->amount)}}</td>@endif
  @else 
  @if($_amount)<td  class="center"></td>@endif
  @endif
  @if($record->details->amount < 0)
  @if($_amount)<td  class="center" style="background-color: #ffd0d0;">{{myRound(ABS($record->details->amount))}}</td>@endif
  @else 
  @if($_amount)<td  class="center"></td>@endif
  @endif
  @if(!$currency)  @if($_currency)<td  class="center">{{$record->details->currency}}</td>@endif @endif
  @if($_rate)<td class="center">{{myRound($record->details->rate)}}</td>@endif
  @if(systemConfig()[29] == 1)
  @if(!$transaction_confirm)
  @if($_transaction_confirm)
  @if($record->details->transaction_confirm == 'On')
  <td class="center"> @lang('layout.yes') </td>
  @else
  <td class="center"> @lang('layout.no') </td>
  @endif
  @endif
  @endif
  <td class="center"> 
    @if($record->details->position_status == 'accept')
    @lang('type.accept')
    @elseif($record->details->position_status == 'true')
    @lang('type.pending')
    @elseif($record->details->position_status == 'false')
    @lang('type.cancel')
    @endif
  </td>
  @endif
  @if($_monetary_source)<td  class="center">{{$record->details->monetary_source}}</td>@endif
  @if($_trans_type)<td  class="center">{{$record->details->trans_type}}</td>@endif
  @if(getcommission() =="true") 
    <td class="center" >{{myRound(ABS($record->details->comm_amount))}}</td>
    <td class="center" >@if($record->details->comm_amount) @if($record->details->commission_type) @lang('layout.Income') @else @lang('layout.Expense') @endif @endif</td>
  @endif
  @if($_user)
  <td style="text-align: center;">{{$record->details->user}}</td>
  @endif
</tr>
@endforeach  
<tr>
  @if(!$_reference_number)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_referencen_name)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_reference_number)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_date)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_description)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_bill_number)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_type)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_date)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_due_date)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_type)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_member)   <?php  $colspan = $colspan-1;  ?>       @endif
  @if(!$_account)   <?php  $colspan = $colspan-1;  ?>       @endif
  <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.Total') </b></td>
  @if(count($currencies) <= 1   && count($currencies) <= 1)
  <td class="center"><b> {{myround($deposit_total_home_currency)}}</b></td>
  <td class="center"><b> {{myround($with_total_home_currency)}} </b></td>
  @else
  <td></td>
  <td></td>
  @endif
  @if(!$currency)<td></td>@endif
  @if($_rate)<td></td>@endif

  @if($transaction_confirm)
  @if(systemConfig()[29] == 1)
  @if($_transaction_confirm)   <td></td>       @endif
  @endif
  @endif
  @if($_monetary_source)<td> </td>@endif
  @if($_trans_type)<td> </td>@endif
  @if(getcommission() =="true")<td> </td>@endif
  @if($_user)<td> </td>@endif
</tr>
</table>


@if($_total)
<br>
<table class="main-table">
 <tr class="bg">
  <td colspan="5"><div class="center"><h3>@lang('type.Deposit') - @lang('layout.PerCurrency')</h3></div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
  <td><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
  @if(getAverageRate() =="true")
  <td><div class="center"> @lang('layout.AverageRate') </div></td>
  @endif
</tr>
<?php
$count=0;
foreach($deposit_currencies As $key=>$currency)
{
  ?>
  <tr style="@if($currency['amount'] < 0) background-color: #fbc0c0; @endif">
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency['amount'])}}</div></td>
    <td><div class="center">{{myRound($currency['base_amount'])}}</div></td>
    @if(getAverageRate() =="true")
    <td><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['amount']/$currency['base_amount'])):($currency['amount']/$currency['base_amount'])))}}</div></td>
    @endif

  </tr>
  <?php
}
?>
{{-- we need from here  --}}
<tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
 <td colspan="2"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
 <td colspan="{{getAverageRate() =="true"? '3':'2'}}"><div class="center">{{myRound($deposit_total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
</tr>
{{-- we need upto here  --}}
</table>
<br>

<table class="main-table">
 <tr class="bg">
  <td colspan="5"><div class="center"><h3>@lang('type.Withdrawal') - @lang('layout.PerCurrency')</h3></div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
  <td><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
  @if(getAverageRate() =="true")
  <td><div class="center"> @lang('layout.AverageRate') </div></td>
  @endif
</tr>
<?php
$count=0;
foreach($with_currencies As $key=>$currency)
{
  ?>
  <tr style="@if($currency['amount'] < 0) background-color: #fbc0c0; @endif">
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency['amount'])}}</div></td>
    <td><div class="center">{{myRound($currency['base_amount'])}}</div></td>
    @if(getAverageRate() =="true")
    <td><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['amount']/$currency['base_amount'])):($currency['amount']/$currency['base_amount'])))}}</div></td>
    @endif

  </tr>
  <?php
}
?>
{{-- we need from here  --}}
<tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
 <td colspan="2"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
 <td colspan="{{getAverageRate() =="true"? '3':'2'}}"><div class="center">{{myRound($with_total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
</tr>
{{-- we need upto here --}}
</table>
@endif


@if($_total)
<br>
<table class="main-table">
 <tr class="bg">
  <td colspan="4"><div class="center"><h3>@lang('layout.PerCurrency')</h3></div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
  <td><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
</tr>
<?php
$count=0;
// dd($currencies);
// base_amount

foreach($currencies As $key=>$currency)
{
  ?>
  <tr style="@if($currency['amount'] < 0) background-color: #fbc0c0; @endif">
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{myRound($currency['amount'])}}</div></td>
    <td><div class="center">{{myRound($currency['base_amount'])}}</div></td>

  </tr>
  <?php
}
?>
<tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
 <td colspan="2"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
 <td colspan="2"><div class="center">{{myRound($total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
<tr style="@if($total_comm_amount < 0) background-color: #fbc0c0; @endif">
 <td colspan="2"><div class="center"><h3>@lang('layout.Total') @lang('layout.Commission') </h3></div></td>
 <td colspan="2"><div class="center">{{myRound($total_comm_amount)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection