@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('loan_index');
$_type= !in_array('type', $report);
$_date= !in_array('date', $report);
$_hour= !in_array('hour', $report);
$_due_date= !in_array('due_date', $report);
$_description= !in_array('description', $report);
$_member= !in_array('member', $report);
$_account= !in_array('account', $report);
$_amount= !in_array('amount', $report);
$_perAmount= !in_array('perAmount', $report);
$_perDollarAmount= !in_array('perDollarAmount', $report);
$_perAverageRate= !in_array('perAverageRate', $report);
$_getLoan= !in_array('getLoan', $report);
$_currency= !in_array('currency', $report);
$_perCurrency= !in_array('perCurrency', $report);
$_rate= !in_array('rate', $report);
$_reference_number= !in_array('reference_number', $report);
$_number= !in_array('number', $report);
$_total= !in_array('total', $report);
$_user= !in_array('user', $report);
$_transaction_confirm= !in_array('transaction_confirm', $report);
$_trans_type= !in_array('trans_type', $report);
$_monetary_source= !in_array('monetary_source', $report);
$_referencen_name= !in_array('referencen_name', $report);
$_bill_number= !in_array('bill_number', $report);
$_exchangeAmount= !in_array('exchangeAmount', $report);
$_exchangedCurrency = !in_array('exchangedCurrency', $report);
$_exchangedRate = !in_array('exchangedRate', $report);

    $report_percent = customeReportNewPercent('loan_index');
    $_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_hour_percent= (array_key_exists('hour___percent', $report_percent))?$report_percent['hour___percent']:null;
    $_due_date_percent= (array_key_exists('due_date___percent', $report_percent))?$report_percent['due_date___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_getLoan_percent= (array_key_exists('getLoan___percent', $report_percent))?$report_percent['getLoan___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_perCurrency_percent= (array_key_exists('perCurrency___percent', $report_percent))?$report_percent['perCurrency___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_transaction_confirm_percent= (array_key_exists('transaction_confirm___percent', $report_percent))?$report_percent['transaction_confirm___percent']:null;
    $_monetary_source_percent= (array_key_exists('monetary_source___percent', $report_percent))?$report_percent['monetary_source___percent']:null;
    $_trans_type_percent= (array_key_exists('trans_type___percent', $report_percent))?$report_percent['trans_type___percent']:null;
    $_referencen_name_percent= (array_key_exists('referencen_name___percent', $report_percent))?$report_percent['referencen_name___percent']:null;
    $_bill_number_percent= (array_key_exists('bill_number___percent', $report_percent))?$report_percent['bill_number___percent']:null;
    $_exchangeAmount_percent= (array_key_exists('exchangeAmount___percent', $report_percent))?$report_percent['exchangeAmount___percent']:null;
    $_exchangedCurrency_percent= (array_key_exists('exchangedCurrency___percent', $report_percent))?$report_percent['exchangedCurrency___percent']:null;
    $_exchangedRate_percent= (array_key_exists('exchangedRate___percent', $report_percent))?$report_percent['exchangedRate___percent']:null;
   
    
    ?>

<h3 class="table-caption" style="text-align: center;">@lang('menu.DepositAndWithdrawal')</h3>

@if($from_date || $to_date || $from_loan || $to_loan)
<table class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>

<table class="main-table">
    <tr>
      @if($from_loan)
      <td>
        <span>@lang('layout.From') @lang('layout.Number')</span>: {{$from_loan}}
      </td>
      @endif      
      @if($to_loan)
      <td>
        <span>@lang('layout.To') @lang('layout.Number')</span>: {{$to_loan}}
      </td>
      @endif 

    </tr>
</table>
@endif

@if($ClassName || $member_name || $currency || $category || $type_name || $bank_account_name || $contract_name || $member_class_name || $transaction_confirm)
<table class="main-table" style="margin: 6px 0px;" >
    <tr>
      @if($ClassName)
      <td>
        <span>@lang('menu.FinancialClass')</span>: {{$ClassName}}
      </td>
      @endif

      @if($member_class_name)
      <td>
        <span>@lang('layout.MemberClass')</span>: {{$member_class_name}}
      </td>
      @endif      
      
      @if($member_name)
      <td>
        <span>@lang('layout.Member')</span>: {{$member_name}}
      </td>
      @endif

      @if($currency)
      <td>
        <span>@lang('layout.Currency')</span>: {{$currency}}
      </td>
      @endif

      @if($category)
      <td>
        <span>@lang('layout.Category')</span>: {{__('layout.'.ucfirst($category))}}
      </td>
      @endif

      @if($type_name)
      <td>
        <span>@lang('layout.Type')</span>: {{__('layout.'.ucfirst($type_name))}}
      </td>
      @endif


      @if($bank_account_name)
      <td>
        <span>@lang('layout.Account')</span>: {{$bank_account_name}}
      </td>
      @endif
      
      @if($contract_name)
      <td>
        <span>@lang('layout.Contract')</span>: {{$contract_name}}
      </td>
      @endif

      @if($transaction_confirm)
      <td>
        <span>@lang('layout.TransactionConfirm')</span>:   @lang('layout.yes')
      </td>
      @endif
      
    </tr>
   
</table>
@endif

<br>
<table class="main-table">

<thead>
<tr class="bg">
 <td class="center" ><div >@lang('layout.Record')</div></td>
 @if($_number)
  <td class="center"  @if($_number_percent) width="{{$_number_percent}}%" @endif><div >@lang('layout.Number')</div></td>
 @endif
 @if($_date)
 <td class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif><div > @lang('layout.Date')</div></td>
 @endif
 @if($_description)
 <td class="center"  @if($_description_percent) width="{{$_description_percent}}%" @endif><div > @lang('layout.Description')</div></td>
 @endif
 @if($_monetary_source) 
 <td class="center"  @if($_monetary_source_percent) width="{{$_monetary_source_percent}}%" @endif><div > @lang('layout.MonetarySource')</div></td> 
 @endif
 @if($_bill_number)
 <td class="center"  @if($_bill_number_percent) width="{{$_bill_number_percent}}%" @endif><div > @lang('layout.BillNumberCheque')</div></td>
 @endif
 @if(!$type_name) 
 @if($_type)<td class="center"  @if($_type_percent) width="{{$_type_percent}}%" @endif><div > @lang('layout.Type')</div></td>@endif 
 @endif
 @if($_due_date)
 <td class="center"  @if($_due_date_percent) width="{{$_due_date_percent}}%" @endif><div > @lang('layout.DueDate')</div></td>
 @endif
 @if(!$category) 
 @if($_type)<td class="center"  @if($_type_percent) width="{{$_type_percent}}%" @endif><div > @lang('layout.Category')</div></td>@endif 
 @endif
 @if($_referencen_name)
 <td class="center"  @if($_referencen_name_percent) width="{{$_referencen_name_percent}}%" @endif><div >@lang('layout.ReferenceName')</div></td>
 @endif
 @if($_reference_number)
  <td class="center"  @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif><div >@lang('layout.ReferenceNumber')</div></td>
 @endif 
 @if($_trans_type) 
 <td class="center"  @if($_trans_type_percent) width="{{$_trans_type_percent}}%" @endif><div > @lang('layout.TransactionType')</div></td> 
 @endif
 @if(!$member_name) 
 @if($_member)<td class="center"  @if($_member_percent) width="{{$_member_percent}}%" @endif><div > @lang('layout.Member')</div></td>@endif 
 @endif
 @if(!$bank_account_name) 
 @if($_account)<td class="center"  @if($_account_percent) width="{{$_account_percent}}%" @endif><div > @lang('layout.Account')</div></td>@endif 
 @endif
 @if($_exchangeAmount)
 <td class="center" @if($_exchangeAmount_percent) width="{{$_exchangeAmount_percent}}%" @endif><div > @lang('layout.ExchangeAmount')</div></td>
 @endif
 @if($_exchangedCurrency)
 <td class="center" @if($_exchangedCurrency_percent) width="{{$_exchangedCurrency_percent}}%" @endif><div > @lang('layout.ExchangedCurrency')</div></td>
 @endif
 @if($_exchangedRate)
 <td class="center" @if($_exchangedRate_percent) width="{{$_exchangedRate_percent}}%" @endif><div> @lang('layout.ExchangedRate')</div></td>
 @endif
 @if($_getLoan)<td class="center"  @if($_getLoan_percent) width="{{$_getLoan_percent}}%" @endif><div > @lang('layout.GetLoan')</div></td>@endif
 @if($_amount)<td class="center"  @if($_amount_percent) width="{{$_amount_percent}}%" @endif><div > @lang('layout.PayLoan')</div></td>@endif
 @if(!$currency) @if($_currency)<td class="center"  @if($_currency_percent) width="{{$_currency_percent}}%" @endif><div > @lang('layout.Currency')</div></td>@endif @endif
 @if($_rate)<td class="center"  @if($_rate_percent) width="{{$_rate_percent}}%" @endif><div > @lang('layout.Rate')</div></td>@endif
 @if($_hour)<td class="center"  @if($_hour_percent) width="{{$_hour_percent}}%" @endif><div > @lang('layout.Hour')</div></td>@endif
 @if(!$transaction_confirm)
 @if(systemConfig()[29] == 1)
 @if($_transaction_confirm)<td class="center"  @if($_transaction_confirm_percent) width="{{$_transaction_confirm_percent}}%" @endif><div > @lang('layout.TransactionConfirm')</div></td>@endif
 <td class="center" ><div > @lang('layout.Status')</div></td>
 @endif
 @endif
 @if(getcommission() =="true") 
 <td class="center" ><div > @lang('layout.Commission') </td>
 <td class="center" ><div > @lang('layout.Type') @lang('layout.Commission') </td>
 @endif
 @if($_user)
 <td class="center"  @if($_user_percent) width="{{$_user_percent}}%" @endif ><div > @lang('layout.User')</div></td>
 @endif
</tr>
</thead>
<?php
  $count = 0;
  $total_home_currency=0;
  $total_comm_amount=0;
  $currencies=[]; 
  // 
  $deposit_total_home_currency=0;
  $deposit_currencies=[];
  $with_total_home_currency=0;
  $with_total_home_currency_exchange=0;
  $with_withdrawal_total_home_currency_exchange=0;
  $with_currencies=[];
  $with_currencies_cxchange=[];
  $with_Withdrawal_currencies_cxchange=[];
  $colspan = 17; 
?>
{{-- @dd($data) --}}
@foreach($data AS $record)
<tr>
  <?php
    $total_home_currency+= (((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
    $total_comm_amount+= (((systemConfig()[30] == 1)?1:0)?($record->comm_amount/$record->static_rate*$record->loan_rate):($record->comm_amount / $record->loan_rate));
    if(array_key_exists($record->currency, $currencies))
    {
      $currencies[$record->currency]['amount']=$currencies[$record->currency]['amount']+$record->amount;
      $currencies[$record->currency]['base_amount']=($currencies[$record->currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
      $currencies[$record->currency]['count']=$currencies[$record->currency]['count']+1;

      $currencies[$record->currency]['start_date'] =  (date_timestamp_get(date_create($currencies[$record->currency]['start_date'])) > date_timestamp_get(date_create($record->Date))) ? $record->Date : $currencies[$record->currency]['start_date']; 
      $currencies[$record->currency]['end_date'] =  (date_timestamp_get(date_create($currencies[$record->currency]['end_date'])) < date_timestamp_get(date_create($record->Date))) ? $record->Date : $currencies[$record->currency]['end_date']; 
  
    }
    else
    { 
      $currencies[$record->currency]['amount']=$record->amount;
      $currencies[$record->currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
      $currencies[$record->currency]['count']=1;
      $currencies[$record->currency]['start_date'] = $record->Date;
      $currencies[$record->currency]['end_date'] = $record->Date;
    } 
    //
    if($record->amount < 0){
      $with_total_home_currency+= (((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
      if(array_key_exists($record->currency, $with_currencies))
      {
        $with_currencies[$record->currency]['amount']=$with_currencies[$record->currency]['amount']+$record->amount;
        $with_currencies[$record->currency]['base_amount']=($with_currencies[$record->currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
        $with_currencies[$record->currency]['count']=$with_currencies[$record->currency]['count']+1;
        $with_currencies[$record->currency]['start_date'] =  (date_timestamp_get(date_create($with_currencies[$record->currency]['start_date'])) > date_timestamp_get(date_create($record->Date))) ? $record->Date : $with_currencies[$record->currency]['start_date']; 
        $with_currencies[$record->currency]['end_date'] =  (date_timestamp_get(date_create($with_currencies[$record->currency]['end_date'])) < date_timestamp_get(date_create($record->Date))) ? $record->Date : $with_currencies[$record->currency]['end_date']; 
      }
      else
      {
        $with_currencies[$record->currency]['amount']=$record->amount;
        $with_currencies[$record->currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
        $with_currencies[$record->currency]['count']=1;
        $with_currencies[$record->currency]['start_date'] = $record->Date;
        $with_currencies[$record->currency]['end_date'] = $record->Date;
      }
  
      if(array_key_exists($record->exchanged_currency, $with_Withdrawal_currencies_cxchange))
      {
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['exchanged_amount']=$with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['exchanged_amount']+$record->exchanged_amount;
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['base_amount']=($with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->exchanged_amount/$record->exchanged_static_rate*$record->exchanged_rate):($record->exchanged_amount / $record->exchanged_rate));
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['count']=$with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['count']+1;
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['start_date'] =  (date_timestamp_get(date_create($with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['start_date'])) > date_timestamp_get(date_create($record->Date))) ? $record->Date : $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['start_date']; 
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['end_date'] =  (date_timestamp_get(date_create($with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['end_date'])) < date_timestamp_get(date_create($record->Date))) ? $record->Date : $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['end_date']; 
      }
      else
      {
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['exchanged_amount']=$record->exchanged_amount;
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->exchanged_amount/$record->exchanged_static_rate*$record->exchanged_rate):($record->exchanged_amount / $record->exchanged_rate));
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['count']=1;
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['start_date'] = $record->Date;
        $with_Withdrawal_currencies_cxchange[$record->exchanged_currency]['end_date'] = $record->Date;
      }
       
    }
    else{
      $deposit_total_home_currency+= (((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
      if(array_key_exists($record->currency, $deposit_currencies))
      {
        $deposit_currencies[$record->currency]['amount']=$deposit_currencies[$record->currency]['amount']+$record->amount;
        $deposit_currencies[$record->currency]['base_amount']=($deposit_currencies[$record->currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
        $deposit_currencies[$record->currency]['count']=$deposit_currencies[$record->currency]['count']+1;
        $deposit_currencies[$record->currency]['start_date'] =  (date_timestamp_get(date_create($deposit_currencies[$record->currency]['start_date'])) > date_timestamp_get(date_create($record->Date))) ? $record->Date : $deposit_currencies[$record->currency]['start_date']; 
        $deposit_currencies[$record->currency]['end_date'] =  (date_timestamp_get(date_create($deposit_currencies[$record->currency]['end_date'])) < date_timestamp_get(date_create($record->Date))) ? $record->Date : $deposit_currencies[$record->currency]['end_date']; 
      }
      else
      {
        $deposit_currencies[$record->currency]['amount']=$record->amount;
        $deposit_currencies[$record->currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->amount/$record->static_rate*$record->loan_rate):($record->amount / $record->loan_rate));
        $deposit_currencies[$record->currency]['count']=1;
        $deposit_currencies[$record->currency]['start_date'] = $record->Date;
        $deposit_currencies[$record->currency]['end_date'] = $record->Date;
      }


      if(array_key_exists($record->exchanged_currency, $with_currencies_cxchange))
      {
        $with_currencies_cxchange[$record->exchanged_currency]['exchanged_amount']=$with_currencies_cxchange[$record->exchanged_currency]['exchanged_amount']+$record->exchanged_amount;
        $with_currencies_cxchange[$record->exchanged_currency]['base_amount']=($with_currencies_cxchange[$record->exchanged_currency]['base_amount'])+(((systemConfig()[30] == 1)?1:0)?($record->exchanged_amount/$record->exchanged_static_rate*$record->exchanged_rate):($record->exchanged_amount / $record->exchanged_rate));
        $with_currencies_cxchange[$record->exchanged_currency]['count']=$with_currencies_cxchange[$record->exchanged_currency]['count']+1;
        $with_currencies_cxchange[$record->exchanged_currency]['start_date'] =  (date_timestamp_get(date_create($with_currencies_cxchange[$record->exchanged_currency]['start_date'])) > date_timestamp_get(date_create($record->Date))) ? $record->Date : $with_currencies_cxchange[$record->exchanged_currency]['start_date']; 
        $with_currencies_cxchange[$record->exchanged_currency]['end_date'] =  (date_timestamp_get(date_create($with_currencies_cxchange[$record->exchanged_currency]['end_date'])) < date_timestamp_get(date_create($record->Date))) ? $record->Date : $with_currencies_cxchange[$record->exchanged_currency]['end_date']; 
      }
      else
      {
        $with_currencies_cxchange[$record->exchanged_currency]['exchanged_amount']=$record->exchanged_amount;
        $with_currencies_cxchange[$record->exchanged_currency]['base_amount']=(((systemConfig()[30] == 1)?1:0)?($record->exchanged_amount/$record->exchanged_static_rate*$record->exchanged_rate):($record->exchanged_amount / $record->exchanged_rate));
        $with_currencies_cxchange[$record->exchanged_currency]['count']=1;
        $with_currencies_cxchange[$record->exchanged_currency]['start_date'] = $record->Date;
        $with_currencies_cxchange[$record->exchanged_currency]['end_date'] = $record->Date;
      }
    }
    ?>
  <td class="center">{{++$count}}</td>
  @if($_number)
    <td class="center">{{$record->number}}</td>
  @endif
  @if($_date)<td  class="center"> 
    {{convertDate($record->Date)}} 
  </td>
  @endif
  @if($_description)
  <td  style="@if($_description_percent) text-align: justify; @endif"> 
    @if (getRPSystemDescription() != 'false') {{$record->remark_fa}} @endif {{$record->description}}  
  </td>
  @endif 
  @if($_monetary_source)
    <td  class="center">{{$record->monetary_source}}</td>
  @endif
  @if($_bill_number)
    <td  class="center">{{$record->bill_number}}</td>
  @endif 
  @if(!$type_name) 
    @if($_type)<td  class="center">{{__('layout.'.ucfirst($record->type))}}</td>@endif 
  @endif
  @if($_due_date)
    <td  class="center"> {{convertDate($record->dueDate)}}</td>
  @endif 
  @if(!$category) 
    @if($_type)<td  class="center">@if($record->category){{__('layout.'.ucfirst($record->category))}}@endif</td>@endif 
  @endif
  @if($_referencen_name)
    <td class="center">{{$record->referencen_name}}</td>
  @endif
  @if($_reference_number)
    <td class="center">{{$record->ref_Number}}</td>
  @endif 
  @if($_trans_type)
    <td  class="center">{{$record->trans_type}}</td>
  @endif
  @if(!$member_name) 
    @if($_member)<td  class="center">{{$record->Member}}</td>@endif 
  @endif
  @if(!$bank_account_name)  
    @if($_account)<td  class="center">{{$record->Account}}</td>@endif 
  @endif
  @if($_exchangeAmount)
    <td  class="center">{{myRound($record->exchanged_amount)}}</td>
  @endif
  @if($_exchangedCurrency)
    <td  class="center">{{$record->exchanged_currency}}</td>
  @endif
  @if($_exchangedRate)
    <td  class="center">{{$record->exchanged_rate}}</td>
  @endif

  @if($record->amount > 0)
  @if($_getLoan)<td  class="center">{{myRound($record->amount)}}</td>@endif
  @else 
  @if($_getLoan)<td  class="center"></td>@endif
  @endif

  @if($record->amount < 0)
  @if($_amount)<td  class="center" style="background-color: #ffd0d0;">{{myRound(ABS($record->amount))}}</td>@endif
  @else 
  @if($_amount)<td  class="center"></td>@endif
  @endif
  
  @if(!$currency)  @if($_currency)<td  class="center">{{$record->currency}}</td>@endif @endif
  @if($_rate)<td class="center">{{myRound($record->rate)}}</td>@endif
  @if($_hour)
  <td  class="center">
  @if(getHourType() == 24)
  {{ (($record->hour != null)?(date_format(date_create($record->hour), 'H:i')):'') }}
  @else
  {{ (($record->hour != null)?(date_format(date_create($record->hour), 'h:i:a')):'') }}
  @endif
  </td>
  @endif


  @if(systemConfig()[29] == 1)
  @if(!$transaction_confirm)
  @if($_transaction_confirm)
  @if($record->transaction_confirm == 'On')
  <td class="center"> @lang('layout.yes') </td>
  @else
  <td class="center"> @lang('layout.no') </td>
  @endif
  @endif
  @endif
  <td class="center"> 
    @if($record->position_status == 'accept')
    @lang('type.accept')
    @elseif($record->position_status == 'true')
    @lang('type.pending')
    @elseif($record->position_status == 'false')
    @lang('type.cancel')
    @endif
  </td>
  @endif
  @if(getcommission() =="true") 
    <td class="center" >{{myRound(ABS($record->comm_amount))}}</td>
    <td class="center" >@if($record->comm_amount) @if($record->commission_type) @lang('layout.Income') @else @lang('layout.Expense') @endif @endif</td>
  @endif
  @if($_user)
  <td style="text-align: center;">{{$record->user}}</td>
  @endif
</tr>
@endforeach  
<tr class="bg">
  @if(!$_number)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_reference_number)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_date)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_description)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_monetary_source)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_bill_number)   <?php  $colspan = $colspan-1;  ?>@endif
  @if($type_name || !$_type)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_due_date)   <?php  $colspan = $colspan-1;  ?>@endif
  @if($category || !$_type)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_referencen_name)   <?php  $colspan = $colspan-1;  ?>@endif
  @if($member_name || !$_member)   <?php  $colspan = $colspan-1;  ?>@endif
  @if($bank_account_name || !$_account)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_exchangeAmount)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_exchangedCurrency)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_exchangedRate)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_trans_type)   <?php  $colspan = $colspan-1;  ?>@endif
  <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.Total') </b></td>
  @if($_getLoan) <td class="center"><b> @if(count($currencies) <= 1   && count($currencies) <= 1) {{myround($deposit_total_home_currency)}} @endif</b></td>@endif
  @if($_amount)<td class="center"><b> @if(count($currencies) <= 1   && count($currencies) <= 1) {{myround($with_total_home_currency)}} @endif </b></td>@endif
  @if(!$currency) @if($_currency)<td></td>@endif @endif
  @if($_rate)<td></td>@endif 
  @if($_hour)<td></td>@endif
  @if(!$transaction_confirm)
  @if(systemConfig()[29] == 1)
  @if($_transaction_confirm)<td></td>@endif
  @endif
  @endif
  @if(getcommission() =="true")
  <td> </td>
  <td> </td>
  @endif
  @if($_user)<td> </td>@endif

</tr>
</table>


@if($_total)
<br>
<table class="main-table">
  <?php
  $colspan = 3;  
  ?>
  <tr class="bg">
    <td colspan="{{$colspan}}"><div class="center"><h3>@lang('type.Deposit') - @lang('layout.PerCurrency')</h3></div></td>
  </tr>
  <tr>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Record') </div></td>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Count') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.StartDate') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.EndDate') </div></td>
    @if($_perCurrency)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Currency') </div></td>
    @endif
    @if($_perAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount') </div></td>
    @endif
    @if($_perDollarAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
    @endif
    @if($_perAverageRate)
    @if(getAverageRate() =="true")
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.AverageRate') </div></td>
    @endif
    @endif
  </tr>
  <?php
    $count=0;
    $count_all = 0;
    $colspan = 4;
    foreach($deposit_currencies As $key=>$currency){
      $count_all += $currency['count'];
  ?>
  <tr style="@if($currency['amount'] < 0) background-color: #fbc0c0; @endif">
    <td style="text-align: center;"><div class="center">{{++$count}}</div></td>
    <td style="text-align: center;"><div class="center">{{$currency['count']}}</div></td>
    <td style="text-align: center;"><div class="center">{{convertDate($currency['start_date'])}}</div></td>
    <td style="text-align: center;"><div class="center">{{convertDate($currency['end_date'])}}</div></td>
    @if($_perCurrency)
    <td style="text-align: center;"><div class="center">{{$key}}</div></td>
    @endif
    @if($_perAmount)
    <td style="text-align: center;"><div class="center">{{myRound($currency['amount'])}}</div></td>
    @endif
    @if($_perDollarAmount)
    <td style="text-align: center;"><div class="center">{{myRound($currency['base_amount'])}}</div></td>
    @endif
    @if($_perAverageRate)
    @if(getAverageRate() =="true")
    <td style="text-align: center;"><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['amount']/$currency['base_amount'])):($currency['amount']/$currency['base_amount'])))}}</div></td>
    @endif
    @endif
  </tr>
  <?php
    }
  ?>
  <tr class="bg">
    <td class="center" ><b> </b></td>
    <td class="center" ><b> {{$count_all}} </b></td>
    @if(!$_perCurrency)   <?php  $colspan = $colspan-1;  ?>@endif
    @if(!$_perAmount)   <?php  $colspan = $colspan-1;  ?>@endif
    <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.HomeCurrencyTotal') </b></td>
    @if($_perDollarAmount) <td class="center"><b>{{myRound($deposit_total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</b></td>@endif
    @if($_perAverageRate)<td></td>@endif 
  </tr>
  {{-- we need upto here  --}}
</table>
<br>

<table class="main-table">
  <?php 
    $colspan = 3;
  ?>
  <tr class="bg">
    <td colspan="{{$colspan}}"><div class="center"><h3>@lang('type.Withdrawal') - @lang('layout.PerCurrency')</h3></div></td>
  </tr>
  <tr>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Record') </div></td>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Count') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.StartDate') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.EndDate') </div></td>
    @if($_perCurrency)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Currency') </div></td>
    @endif
    @if($_perAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount') </div></td>
    @endif
    @if($_perDollarAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
    @endif
    @if($_perAverageRate)
    @if(getAverageRate() =="true")
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.AverageRate') </div></td>
    @endif
    @endif
  </tr>
  <?php
    $count=0;
    $count_all = 0;
    $colspan = 4;
    foreach($with_currencies As $key=>$currency)
    {
      $count_all += $currency['count'];
      ?>
      <tr style="@if($currency['amount'] < 0) background-color: #fbc0c0; @endif">
        <td style="text-align: center;"><div class="center">{{++$count}}</div></td>
        <td style="text-align: center;"><div class="center">{{$currency['count']}}</div></td>
        <td style="text-align: center;"><div class="center">{{convertDate($currency['start_date'])}}</div></td>
        <td style="text-align: center;"><div class="center">{{convertDate($currency['end_date'])}}</div></td>
        @if($_perCurrency)
        <td style="text-align: center;"><div class="center">{{$key}}</div></td>
        @endif
        @if($_perAmount)
        <td style="text-align: center;"><div class="center">{{myRound($currency['amount'])}}</div></td>
        @endif
        @if($_perDollarAmount)
        <td style="text-align: center;"><div class="center">{{myRound($currency['base_amount'])}}</div></td>
        @endif
        @if($_perAverageRate)
        @if(getAverageRate() =="true")
        <td style="text-align: center;"><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['amount']/$currency['base_amount'])):($currency['amount']/$currency['base_amount'])))}}</div></td>
        @endif
        @endif
      </tr>
      <?php
    }
  ?>
  {{-- we need from here  --}}
  {{-- <tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
    <td colspan="3"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
    <td colspan="{{getAverageRate() =="true"? '2':'1'}}"><div class="center">{{myRound($with_total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
  </tr> --}}
  <tr class="bg" class="bg" style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
    <td class="center" ><b> </b></td>
    <td class="center" ><b> {{$count_all}} </b></td>
    @if(!$_perCurrency)   <?php  $colspan = $colspan-1;  ?>@endif
    @if(!$_perAmount)   <?php  $colspan = $colspan-1;  ?>@endif
    <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.HomeCurrencyTotal') </b></td>
    @if($_perDollarAmount) <td class="center"><b>{{myRound($with_total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</b></td>@endif
    @if($_perAverageRate)<td></td>@endif 
  </tr>
  {{-- we need upto here --}}
</table>
<br>
<table class="main-table">
  <?php 
      $colspan = 3;
  ?>
  <tr class="bg">
    <td colspan="{{$colspan}}"><div class="center"><h3>@lang('type.Deposit') - @lang('layout.PerCurrencyExchange')</h3></div></td>
  </tr>
  <tr>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Record') </div></td>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Count') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.StartDate') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.EndDate') </div></td>
    @if($_perCurrency)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Currency') </div></td>
    @endif
    @if($_perAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount') </div></td>
    @endif
    @if($_perDollarAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
    @endif
    @if($_perAverageRate)
    @if(getAverageRate() =="true")
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.AverageRate') </div></td>
    @endif
    @endif
  </tr>
  {{-- @dd($with_currencies_cxchange) --}}
  <?php
  $count=0;
  $count_all = 0;
  $colspan = 4;
  foreach($with_currencies_cxchange As $key=>$currency){
    $with_total_home_currency_exchange+=$currency['base_amount'];
    $count_all += $currency['count'];
  ?>
  <tr style="@if($currency['exchanged_amount'] < 0) background-color: #fbc0c0; @endif">
    <td style="text-align: center;"><div class="center">{{++$count}}</div></td>
    <td style="text-align: center;"><div class="center">{{$currency['count']}}</div></td>
    <td style="text-align: center;"><div class="center">{{convertDate($currency['start_date'])}}</div></td>
    <td style="text-align: center;"><div class="center">{{convertDate($currency['end_date'])}}</div></td>
    @if($_perCurrency)
    <td style="text-align: center;"><div class="center">{{$key}}</div></td>
    @endif
    @if($_perAmount)
    <td style="text-align: center;"><div class="center">{{myRound($currency['exchanged_amount'])}}</div></td>
    @endif
    @if($_perDollarAmount)
    <td style="text-align: center;"><div class="center">{{myRound($currency['base_amount'])}}</div></td>
    @endif
    @if($_perAverageRate)
    @if(getAverageRate() =="true")
    <td style="text-align: center;"><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['exchanged_amount']/$currency['base_amount'])):($currency['exchanged_amount']/$currency['base_amount'])))}}</div></td>
    @endif
    @endif
  </tr>
  <?php
    }
  ?>
  {{-- we need from here  --}}
  {{-- <tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
    <td colspan="3"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
    <td colspan="{{getAverageRate() =="true"? '2':'1'}}"><div class="center">{{myRound($with_total_home_currency_exchange)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
  </tr> --}}
  <tr class="bg" style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
    <td class="center" ><b> </b></td>
    <td class="center" ><b> {{$count_all}} </b></td>
    @if(!$_perCurrency)   <?php  $colspan = $colspan-1;  ?>@endif
    @if(!$_perAmount)   <?php  $colspan = $colspan-1;  ?>@endif
    <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.HomeCurrencyTotal') </b></td>
    @if($_perDollarAmount) <td class="center"><b>{{myRound($with_total_home_currency_exchange)}}  {{getHomeCurrency()[getCurrencyType()]}}</b></td>@endif
    @if($_perAverageRate)<td></td>@endif 
  </tr>
  {{-- we need upto here --}}
</table>
<br>
<table class="main-table">
  <?php
    $colspan = 3;
  ?>
  <tr class="bg">
    <td colspan="{{$colspan}}"><div class="center"><h3>@lang('type.Withdrawal') - @lang('layout.PerCurrencyExchange')</h3></div></td>
  </tr>
  <tr>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Record') </div></td>
    <td style="text-align: center;font-weight: bold;"><div class="center">  @lang('layout.Count') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.StartDate') </div></td>
    <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.EndDate') </div></td>
    @if($_perCurrency)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Currency') </div></td>
    @endif
    @if($_perAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount') </div></td>
    @endif
    @if($_perDollarAmount)
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
    @endif
    @if($_perAverageRate)
    @if(getAverageRate() =="true")
    <td style="text-align: center;font-weight: bold;"><div class="center"> @lang('layout.AverageRate') </div></td>
    @endif
    @endif
  </tr>
  <?php
    $count=0;
    $count_all = 0;
    $colspan = 4;
    foreach($with_Withdrawal_currencies_cxchange As $key=>$currency){
      $with_withdrawal_total_home_currency_exchange+=$currency['base_amount'];
      $count_all += $currency['count'];
      ?>
      <tr style="@if($currency['exchanged_amount'] < 0) background-color: #fbc0c0; @endif">
        <td style="text-align: center;"><div class="center">{{++$count}}</div></td>
        <td style="text-align: center;"><div class="center">{{$currency['count']}}</div></td>
        <td style="text-align: center;"><div class="center">{{convertDate($currency['start_date'])}}</div></td>
        <td style="text-align: center;"><div class="center">{{convertDate($currency['end_date'])}}</div></td>
        @if($_perCurrency)
        <td style="text-align: center;"><div class="center">{{$key}}</div></td>
        @endif
        @if($_perAmount)
        <td style="text-align: center;"><div class="center">{{myRound($currency['exchanged_amount'])}}</div></td>
        @endif
        @if($_perDollarAmount)
        <td style="text-align: center;"><div class="center">{{myRound($currency['base_amount'])}}</div></td>
        @endif
        @if($_perAverageRate)
        @if(getAverageRate() =="true")
        <td style="text-align: center;"><div class="center">{{myRound((((systemConfig()[30] == 1 && (currencyList($key)[0]->static_rate))?1:0)?((currencyList($key)[0]->static_rate)/($currency['amount']/$currency['base_amount'])):($currency['exchanged_amount']/$currency['base_amount'])))}}</div></td>
        @endif
        @endif
      </tr>
      <?php
    }
  ?>
  {{-- we need from here  --}}
  {{-- <tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
    <td colspan="3"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
    <td colspan="{{getAverageRate() =="true"? '2':'1'}}"><div class="center">{{myRound($with_withdrawal_total_home_currency_exchange)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
  </tr> --}}
  <tr class="bg" style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
    <td class="center" ><b> </b></td>
    <td class="center" ><b> {{$count_all}} </b></td>
    @if(!$_perCurrency)   <?php  $colspan = $colspan-1;  ?>@endif
    @if(!$_perAmount)   <?php  $colspan = $colspan-1;  ?>@endif
    <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.HomeCurrencyTotal') </b></td>
    @if($_perDollarAmount) <td class="center"><b>{{myRound($with_withdrawal_total_home_currency_exchange)}}  {{getHomeCurrency()[getCurrencyType()]}}</b></td>@endif
    @if($_perAverageRate)<td></td>@endif 
  </tr>
  {{-- we need upto here --}}
</table>
@endif
@if($_total)
<br>
<table class="main-table">
  <?php 
    $colspan = 3;  
  ?>
 <tr class="bg">
  <td colspan="{{$colspan}}"><div class="center"><h3>@lang('layout.PerCurrency')</h3></div></td>
</tr>
<tr>
  <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.Record') </div></td>
  <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.Count') </div></td>
  <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.StartDate') </div></td>
  <td style="text-align: center; font-weight: bold;"><div class="center">  @lang('layout.EndDate') </div></td>
  @if($_perCurrency)
  <td style="text-align: center; font-weight: bold;"><div class="center"> @lang('layout.Currency') </div></td>
  @endif
  @if($_perAmount)
  <td style="text-align: center; font-weight: bold;"><div class="center"> @lang('layout.Amount') </div></td>
  @endif
  @if($_perDollarAmount)
  <td style="text-align: center; font-weight: bold;"><div class="center"> @lang('layout.Amount')  {{getHomeCurrency()[getCurrencyType()]}} </div></td>
  @endif
</tr>
<?php
$count=0;
// dd($currencies);
// base_amount
$count_all = 0;
$colspan = 4;

foreach($currencies As $key=>$currency)
{
  $count_all += $currency['count'];
  ?>
  <tr style="@if($currency['amount'] < 0) background-color: #fbc0c0; @endif">
    <td style="text-align: center;"><div class="center">{{++$count}}</div></td>
    <td style="text-align: center;"><div class="center">{{$currency['count']}}</div></td>
    <td style="text-align: center;"><div class="center">{{convertDate($currency['start_date'])}}</div></td>
    <td style="text-align: center;"><div class="center">{{convertDate($currency['end_date'])}}</div></td>
    @if($_perCurrency)
    <td style="text-align: center;"><div class="center">{{$key}}</div></td>
    @endif
    @if($_perAmount)
    <td style="text-align: center;"><div class="center">{{myRound($currency['amount'])}}</div></td>
    @endif
    @if($_perDollarAmount)
    <td style="text-align: center;"><div class="center">{{myRound($currency['base_amount'])}}</div></td>
    @endif
  </tr>
  <?php
}
?>
{{-- <tr style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
 <td colspan="3"><div class="center"><h3>@lang('layout.HomeCurrencyTotal')</h3></div></td>
 <td colspan="1"><div class="center">{{myRound($total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
</tr> --}}
<tr class="bg" style="@if($total_home_currency < 0) background-color: #fbc0c0; @endif">
  <td class="center" ><b> </b></td>
  <td class="center" ><b> {{$count_all}} </b></td>
  @if(!$_perCurrency)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_perAmount)   <?php  $colspan = $colspan-1;  ?>@endif
  <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.HomeCurrencyTotal') </b></td>
  @if($_perDollarAmount) <td class="center"><b>{{myRound($total_home_currency)}}  {{getHomeCurrency()[getCurrencyType()]}}</b></td>@endif
</tr>

{{-- <tr style="@if($total_comm_amount < 0) background-color: #fbc0c0; @endif">
 <td colspan="3"><div class="center"><h3>@lang('layout.Total') @lang('layout.Commission') </h3></div></td>
 <td colspan="1"><div class="center">{{myRound($total_comm_amount)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
</tr> --}}
<tr class="bg" style="@if($total_comm_amount < 0) background-color: #fbc0c0; @endif">
  <td class="center" ><b> </b></td>
  <td class="center" ><b> </b></td>
  @if(!$_perCurrency)   <?php  $colspan = $colspan-1;  ?>@endif
  @if(!$_perAmount)   <?php  $colspan = $colspan-1;  ?>@endif
  <td colspan="{{$colspan}}" class="center" ><b> @lang('layout.HomeCurrencyTotal') </b></td>
  @if($_perDollarAmount) <td class="center"><b>{{myRound($total_comm_amount)}}  {{getHomeCurrency()[getCurrencyType()]}}</b></td>@endif
</tr>

</table>
@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection