@extends('layouts.app')
@section('style')
    <style>
        .v-select input[type=search], .v-select input[type=search]:focus {
            width: 50% !important;
        }
        .table > tbody > tr > td, .table > tbody > tr > th, .table > tfoot > tr > td, .table > tfoot > tr > th, .table > thead > tr > td, .table > thead > tr > th {
            padding: 8px;
            padding: 4px 2px;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
    </style>
        <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />

@stop
@section('content')
    <div class="row">
        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase"> @lang('menu.ImportExcel') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                
                <div class="pull-right">
                </div>
            </div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="tools text-center">
                         <a href="{{url('/')}}/import_file/simple_import_loans_excelses.xlsx" style="text-decoration: none; color: black">--------
                           <button class="btn btn-success">
                           <i class="fa fa-download"></i>
                           @lang('layout.ImportExcelSample')
                           </button>
                        -------- </a>
                   </div>
                    <!-- BEGIN FORM-->
                    {{Form::open(['route'=>'loanImport.store','method'=>'POST','enctype'=>'multipart/form-data','class'=>'form-horizontal','id'=>'import-form'])}}
                        {{ csrf_field() }}
                        <div class="form-body">
                            <div class="col-md-12">
                                <div class="form-group text-center" style="margin-top: 20px;">
                                    <label class="control-label col-md-5">@lang('layout.SelectFile') @lang('layout.Excel')
                                        :</label>
                                    <div class="col-md-7">
                                        {{Form::file('customer_file',null,['class' => 'form-control','placeholder' => __('layout.File')])}}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-12 text-center" style="margin-top: 10px;">
                            <button type="button" onClick="sendFormData(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                            </button>
                            <br/>
                            <br/>
                            <br/>
                            <br/>
                        </div>
                    {{Form::close()}}
                    <!-- end form -->
                </div>
                <div class="col-lg-4">
                    <ul class="text-danger">
                        <p class="text-danger">@lang('message.Info')</p>
                        <li class="text-danger">@lang('message.TipOne')</li>
                        <li class="text-danger">@lang('message.TipTwo')</li>
                        <li class="text-danger">@lang('message.TipThree')</li>
                        <li class="text-danger">@lang('message.TipFour')</li>
                    </ul>
                </div>
            </div>
            <div id="app" v-cloak>
                <h1 v-if="flag=='no'">@lang('layout.import_measure_msg')</h1>
                <div v-if="flag=='yes'" class="portlet-body form" style="margin-bottom:50%;">
                    <div v-if="record.length>0">
                        <div style="overflow-x:scroll; width: 100%">
                            <!-- begint table --> 
                            {{Form::open(['route'=>'loanImport.store','method'=>'POST','class'=>'form-horizontal','enctype'=>'multipart/form-data','id'=>'import-form-second'])}}
                            {{csrf_field()}}
                            <div class="row">

                                <div class="col-lg-12">
                                    <div class="form-group text-center" style="margin: 10px;">
                                        <label class="control-label col-md-3">@lang('layout.SubtractZerosFromTheAmount')
                                            :</label>
                                        <div class="col-md-2">
                                            {{Form::number('number_zero',null,['class' => 'form-control','placeholder' => __('layout.SubtractZerosFromTheAmount')])}}
                                        </div>
                                    </div>
                                </div>
                                <br/>

                                <div class="col-md-12 col-md-12">
                                    <div class="col-md-12" style="height: 400px;">
                                        <table id="table_content" class="table table-bordered ">
                                        <thead>
                                            <tr>
                                                <th class="text-center" style="width:20px;"> # </th>
                                                <th class="text-center" style="min-width: 80px;">
                                                    @lang('layout.Number')  
                                                </th>
                                                <th class="text-center" style="min-width: 200px;">
                                                    @lang('layout.Member')
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.Type')
                                                </th>  
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.BillNumberCheque')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.UserCode')
                                                </th>
                                                <th class="text-center" style="min-width: 200px;">
                                                    @lang('layout.SectionCode')  
                                                </th>
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.Currency')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Rate')
                                                </th>
                                                <th class="text-center" style="min-width: 220px;">
                                                    @lang('layout.Bank')
                                                </th>  
                                                <th class="text-center" style="min-width: 90px;">
                                                    @lang('layout.Amount')
                                                </th>  
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.ExchangedCurrency')
                                                </th>

                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Rate')
                                                </th>
                                                
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Date')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.DueDate')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Hour')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Description')
                                                </th>
                                                <th class="text-center" style="min-width: 130px;">
                                                    @lang('layout.Description')1
                                                </th> 
                                            </tr>
                                            </thead>
                                            <tr v-for="(obj,index) in record">
                                                <td class="td_one"><span class="badge badge3 badge-success badge-roundless">@{{index+1}} </span>
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control"  :name="'number['+index+']'" v-model="obj.number">
                                                </td> 
                                                
                                                <td class="td_one">
                                                    {{-- <input type="text" class="form-control" :name="'name['+index+']'" v-model="obj.member">   --}}
                                                    <v-select class="vue-select2" v-model="obj.selectedMember" label="name" @search="MemberSearch"  :options="member"> </v-select>
                                                    <input type="hidden" :name="'member_id['+index+']'" v-model.number="(!obj.selectedMember)?null:obj.selectedMember.id">
                                                                                              
                                                </td>
    
                                                <td class="td_one">
                                                    {{-- <input type="text" class="form-control" :name="'unit['+index+']'" v-model="obj.type"> --}}
                                                    <select :name="'type['+index+']'" id="" v-model="obj.type" claas="form-control">
                                                    <option value="getLoan"> @lang('layout.GetLoan') </option>    
                                                    <option value="payLoan"> @lang('layout.PayLoan') </option>    
                                                    </select>                                                
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'bill_number['+index+']'" v-model="obj.bill_number">                                                
                                                </td>
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'ref_number['+index+']'" v-model="obj.ref_number">
                                                </td> 

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'referencen_name['+index+']'" v-model="obj.referencen_name">                                                
                                                </td>
    
                                                <td class="td_one">
                                                    <v-select v-model="obj.currency" label="code" :options="selected_currency" @input="setAccount(obj.currency.code, index)"> </v-select>
                                                    <input type="hidden" :name="'currency['+index+']'" v-bind:value="(obj.currency)?obj.currency.code:null" />

                                                    {{-- 
                                                        <select class="form-control input-style" v-model="obj.currency" @input="setAccount(obj.currency)"
                                                    required="required" :name="'currency_id['+index+']'" >
                                                    <option value="">@lang('layout.Select')</option>
                                                        <option v-if="selected_currency" v-for="currency in (selected_currency?selected_currency:null)" :value="currency.id">
                                                            @{{currency.code}}
                                                        </option>
                                                    </select> --}}
                                                </td> 
                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'rate['+index+']'" v-model="obj.rate">
                                                </td>  
                                                
                                                <td class="td_one"> 
                                                    <select class="form-control input-style" v-model="obj.bank"
                                                    required="required" :name="'bank_id['+index+']'" >
                                                    <option value="">@lang('layout.Select')</option>
                                                        <option v-if="obj.selected_banks" v-for="banks in obj.selected_banks" :value="banks.id">
                                                            @{{banks.name}}
                                                        </option>
                                                    </select>
                                                </td>  

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'amount['+index+']'" v-model="obj.amount">                                                
                                                </td>
                                                 
                                                <td class="td_one">
                                                    {{-- <select class="form-control input-style" v-model="obj.exchange_currency"
                                                    required="required" :name="'exchange_currency_id['+index+']'" >
                                                    <option value="">@lang('layout.Select')</option>
                                                    <option v-if="currencyExchange" v-for="currency_exchange in (currencyExchange?currencyExchange:null)" :value="currency_exchange.id">
                                                        @{{currency_exchange.code}}
                                                    </option>
                                                </select>    --}}
                                                <v-select v-model="obj.exchange_currency" label="code" :options="selected_currencyExchange" @input="setAccountExchange(obj.exchange_currency.code, index)"> </v-select>
                                                <input type="hidden" :name="'exchange_currency_id['+index+']'" v-bind:value="(obj.exchange_currency)?obj.exchange_currency.code:null" />
                                      
                                            </td> 
                                            
                                            <td class="td_one">
                                                <input type="text" class="form-control" :name="'exchange_rate['+index+']'" v-model="obj.exchange_rate">
                                            </td> 

                                                <td class="td_one">
                                                    <input type="text" class="date form-control" :name="'date['+index+']'" v-model="obj.date">                                                
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="date form-control" :name="'due_date['+index+']'" v-model="obj.due_date">                                                
                                                </td>

                                                <td class="td_one">
                                                    {{-- <input type="text" class="form-control" :name="'symbol['+index+']'" v-model="obj.hour">  --}}
                                                    {{-- <div class="input-group">  --}}
                                                        <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                    {{-- @if(getHourType() == 24)
                                                    <input type="text" class="form-control timepicker timepicker-24" v-model="obj.hour" ref="time_input" name="hour" >
                                                    @else
                                                    <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="obj.hour" ref="time_input" name="hour" >
                                                    @endif --}}
                                                    @if(getHourType() == 24)
                                                    <input type="text" class="form-control timepicker timepicker-24" v-model="obj.hour" ref="time_input" :name="'hour['+index+']'" @keyup="changeTime">
                                                    @else
                                                    <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="obj.hour" ref="time_input" :name="'hour['+index+']'" @keyup="changeTime">
                                                    @endif
                                                    <span class="input-group-btn">
                                                        <button class="btn default" type="button">
                                                            <i class="fa fa-clock-o"></i>
                                                        </button>
                                                    </span>                                               
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'description['+index+']'" v-model="obj.description">                                                
                                                </td>

                                                <td class="td_one">
                                                    <input type="text" class="form-control" :name="'description1['+index+']'" v-model="obj.description1">                                                
                                                </td>
                                               
                                                 
                                            </tr>
                                            </tbody>
                                        </table>

                                    </div>
                                </div>

                            </div>


                            <!-- end table -->
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                            <button type="button" @click="sendFormData(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <button type="reset" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</button>
                        </div>
                        {{Form::close()}}
                    </div>
                </div>


            </div>

        </div>
    </div>

@endsection
@push('scripts')

<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>


    <script>
        var data ={!! $data !!};
        var banks = {!! $banks !!};
        var currency = {!! $currency !!};
        var currencyExchange = {!! $currencyExchange !!};
            
        Vue.component('v-select', VueSelect.VueSelect);

      var vm =  new Vue({ 
            el: '#app',
            data: {
                flag: 'yes',
                record: data,
                banks: banks,
                selected_banks: banks,
                type :'getLoan', 
                currency: currency,
                selected_currency: currency, 
                exchange_currency: currencyExchange,
                selected_currencyExchange: currencyExchange,
                dynamic_time:'',
                time_interval:0,
                selectedMember : null,
                selected_rate: 0,
                member: [],
            },

            
            mounted(){
                console.log(this.record);
                // this.setSize(this.selectedCurrency.code)
                for (var i = 0; i < data.length; i++) {
                    if(!data[i].type){
                        data[i].type = 'getLoan';
                    } 
                    // if(!data[i].rate){
                    //    this.selected_rate =  10;
                    // } 
                  
                }
                this.dynamicTime()  
                // this.dynamicTime = data.hour;
            },

            
            

            methods: {
                sendFormData(e) {
                    var el = $(e);
                    var form = el.parents('form').get(0);
                    var data = $('#import-form').serialize();
                    console.log('test 22', data);
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        icon: 'warning',
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                        dangerMode: true,
                    }).then((wichButton) => {
                        if (wichButton) {
                            //form.submit();
                            document.getElementById('import-form-second').submit();
                            return true;
                        }
                        return false;
                    });
                },
                get_exchange() {
                if (this.selected_rate > 0) {
                    // console.log(12, this.selected_rate);
                    this.exchange_amount = myRound((this.amount * this.selected_rate1) / this.selected_rate);
                }
            },

                // setSize(selected_code) {
                //     this.paymentCurrency = this.selectedCurrency;
                //     this.selected_rate = this.selectedCurrency.exchange_rate;
                //     this.selected_rate1 = this.selectedCurrency.exchange_rate;
                //     if (selected_code == this.code) {
                //         this.currency_len = 'col-md-12';
                //         this.rate_len = 'col-md-0';
                //     } else {
                //         this.currency_len = 'col-md-6';
                //         this.rate_len = 'col-md-6';
                //     }
                //     this.pcurrency_len = this.currency_len;
                //     this.prate_len = this.rate_len;
                // },

                setAccount(selected_code, index) {
                    console.log(12, selected_code, index);
                    var b = _.clone(banks)
                    var test = b.filter((account) => {
                        return (new RegExp(selected_code)).test(account.code)
                    })

                    this.record[index].selected_banks = test;

                    this.record[index].rate = this.record[index].currency.exchange_rate;
                },

                setAccountExchange(selected_code, index) { 
                    this.record[index].exchange_rate = this.record[index].exchange_currency.exchange_rate;
                },


                MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (vm.selected_class != undefined) ? vm.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        vm.member = [];
                        vm.member = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

                dynamicTime()
        {
            this.time_interval = setInterval(() => {
                const now = new Date()
                @if(getHourType() == 24)
                    const hours = now.getHours().toString().padStart(2,'0')
                    const minutes = now.getMinutes().toString().padStart(2,'0') 
                    // const seconds = now.getSeconds().toString().padStart(2,'0')
                    this.dynamic_time = `${hours}:${minutes}`
                @else
                    const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                    this.dynamic_time = `${timeString}`
                @endif
                
            },1000);
            },
            stopDynamicTime()
            {
                clearInterval(vm.time_interval)
            },
            changeTime()
            {
                vm.dynamic_time = vm.$refs.time_input.value
            },
      
            },
            created: function () {
                console.log('ssssss', this.flag);
                for (var i = 0; i < this.record.length; i++) {
                    
                }
            }
        });

        function sendFormData(e) {
            var el = $(e);
            var form = el.parents('form').get(0);
            var data = $('#import-form').serialize();
            console.log('test 22', data);
            swal({
                title: "@lang('layout.AreYouSure?')",
                icon: 'warning',
                buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                dangerMode: true,
            }).then((wichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            });
        }
        // to send inventory data
        function sendData(element) {
            e = $(e);
            var form = e.parents('form').get(0);
            swal({
                'title': "@lang('layout.AreYouSure?')",
                'icon': 'dander',
                'buttons': ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                danderMode: true
            }).then((whichButton) => {
                if (wichButton) {
                    form.submit();
                    return true;
                }
                return false;
            })
        }

        // end inventory data

    </script>
@endpush