@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.LitterCategoryList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
 
                    @permission('Litter-list')
                    <a href="{{route('litter.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.Litter')
                        </button>
                    </a>
                    @endpermission
                    @permission('LitterTittle-show')
                    <a href="{{route('litterTittle.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.LitterTitle')
                        </button>
                    </a>
                    @endpermission

                    @permission('LitterRefernceDepartment-export')
                    <a href="{{route('referenceDepartment.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.ReferenceDepartment')
                        </button>
                    </a>
                    @endpermission

                    @permission('LitterCategory-show')
                    <a href="{{route('littersCategories.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="littersCategories">
                    <thead>
                    <tr>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.CreatedAt')</th>
                        <th>@lang('layout.UpdatedAt')</th>
                        <th>@lang('layout.Action')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            $('#littersCategories').DataTable({
                ajax: '{{route("littersCategories.index")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'name', name: 'name'},
                    {data: 'description', name: 'description'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'updated_at', name: 'updated_at'},
                    {data: 'action', searchable: false, orderable: false}
                ]
            });
        });
    </script>


@endpush
