@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 60% !important;
    }
</style>
@endsection
@section('content')
<!-- BEGIN CONTENT -->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'litter_index'" @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('menu.LitterTitle'):</label>
                                                <v-select placeholder="@lang('menu.LitterTitle')" label="name" v-model="litterTittle" :options="{{json_encode($litterTittle)}}">
                                                </v-select>
                                                <input type="hidden" name="liiter_tittle" v-model.number="(!litterTittle)?null:litterTittle.id">       
                                            </div>
                                        </div> 
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('layout.LitterCategory'):</label>
                                                <v-select placeholder="@lang('layout.LitterCategory')" label="name" v-model="litterCategories" :options="{{json_encode($litterCategories)}}">
                                                </v-select>
                                                <input type="hidden" name="litter_category" v-model.number="(!litterCategories)?null:litterCategories.id">
                                            </div>
                                        </div> 
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label class="control-label">@lang('menu.ReferenceDepartment'):</label>
                                                <v-select placeholder="@lang('menu.ReferenceDepartment')" label="name" v-model="referenceDepartment" :options="{{json_encode($referenceDepartment)}}">
                                                </v-select>
                                                <input type="hidden" name="reference_department" v-model.number="(!referenceDepartment)?null:referenceDepartment.id">
                                            </div>
                                        </div> 
                                        <div class="col-md-4">
                                            <label class="control-label ">@lang('layout.Title')</label>
                                            <input type="text" name="tittle" class="form-control">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example"
                                                            v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example"
                                                            v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="litter_index">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.LitterList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    @permission('Litter-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('LitterCategory-show')
                    <a href="{{route('littersCategories.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.LitterCategory')
                        </button>
                    </a>
                    @endpermission
                    @permission('LitterTittle-show')
                    <a href="{{route('litterTittle.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.LitterTitle')
                        </button>
                    </a>
                    @endpermission
                    @permission('LitterRefernceDepartment-export')
                    <a href="{{route('referenceDepartment.index')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-reorder"></i> @lang('layout.ReferenceDepartment')
                        </button>
                    </a>
                    @endpermission
                    @permission('Litter-create')
                    <a href="{{route('litter.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="litter">
                    <thead>
                        <tr>
                            <th>@lang('layout.Number')</th>
                            <th>@lang('layout.LitterNumber')</th>
                            <th>@lang('layout.LitterCategory')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.LitterTitle')</th>
                            <th>@lang('layout.Title')</th>
                            <th>@lang('layout.ReferenceDepartment')</th>
                            <th>@lang('layout.Type')</th>
                            <th>@lang('layout.Status')</th>
                            <th>@lang('layout.Result')</th>
                            <th>@lang('layout.Action')</th> 
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
    <iframe id="payframe" style="display: none;"></iframe>
    <!-- END CONTENT BODY -->
    @stop
    @include('print.modal')
    @include('groupCompanyFilter.select')
    @push('scripts')
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#litter').DataTable({
                ajax: '{{route("litter.index")}}',
                order: [[0,"{{getRowOrder()}}"]],
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [ 
                    {data: 'number', name: 'number'},
                    {data: 'litter_number', name: 'litter_number'},
                    {data: 'cat_name', name: 'litter_category.name'},
                    {data: 'date', name: 'date'},
                    {data: 'description', name: 'description'},
                    {data: 'lit_tit_name', name: 'litter_tittle.name'},
                    {data: 'title', name: 'title'},
                    {data: 'ref_name', name: 'reference_department.name'},
                    {data: 'type', name: 'type'},
                    {data: 'status', name: 'status'},
                    {data: 'descriptiontwo', name: 'descriptiontwo'},
                    {data: 'action', searchable: false, orderable: false}
                ]
            });
        });
        function printVoucher(id) {
            var a = document.createElement('a');
            a.href = "{{url('printEmployeeAssessment')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        var cust_rep = {!!customeReportNewData('litter_index')!!};
        Vue.component("v-select", VueSelect.VueSelect);
        let data_table;
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        $('#excell_all').on('click', function (e) {
            $('#show-modal2').click();
            e.preventDefault();
        })
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                litterTittle : null,
                referenceDepartment: null,
                litterCategories: null,
                pdfRoute: '{!!route('litter.report') !!}',
                excelRoute: '{!! route('litter.report') !!}',
                selected_member:null,
                memberlist:[],
                customReportData:
                [
                {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                {Name: '@lang("layout.LitterNumber")', column_name: 'litter_number',checkedColumn:(cust_rep.litter_number)?'checked':'',column_percentage:(cust_rep.litter_number___percent)?cust_rep.litter_number___percent:''},
                {Name: '@lang("layout.LitterCategory")', column_name: 'litter_category',checkedColumn:(cust_rep.litter_category)?'checked':'',column_percentage:(cust_rep.litter_category___percent)?cust_rep.litter_category___percent:''},
                {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                {Name: '@lang("layout.LitterTitle")', column_name: 'litter_title',checkedColumn:(cust_rep.litter_title)?'checked':'',column_percentage:(cust_rep.litter_title___percent)?cust_rep.litter_title___percent:''},
                {Name: '@lang("layout.Title")', column_name: 'title',checkedColumn:(cust_rep.title)?'checked':'',column_percentage:(cust_rep.title___percent)?cust_rep.title___percent:''},
                {Name: '@lang("layout.ReferenceDepartment")', column_name: 'reference_department',checkedColumn:(cust_rep.reference_department)?'checked':'',column_percentage:(cust_rep.reference_department___percent)?cust_rep.reference_department___percent:''},
                {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_rep.status)?'checked':'',column_percentage:(cust_rep.status___percent)?cust_rep.status___percent:''},
                {Name: '@lang("layout.Result")', column_name: 'result',checkedColumn:(cust_rep.result)?'checked':'',column_percentage:(cust_rep.result___percent)?cust_rep.result___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>
@endpush