@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.EditLitter')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
                <form role="form" action="{{route('litter.update')}}" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="path" value="uploads/litters">
                    <input type="hidden" name="litter_id" value="{{$litter->id}}">
                    <input type="hidden" name="u_file" value="{{$litter->file}}">
                    @csrf
                <div class="form-body">
                    <input type="hidden" name="path" value="uploads/litters">
                <div class="row">
                    <div class="col-md-4" style="margin-bottom: 15px">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Number'):</label>
                            <div class="col-md-9">
                                <input type="number" name="number" value="{{$litter->number}}" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" style="margin-bottom: 15px">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.LitterNumber'):</label>
                            <div class="col-md-9">
                                <input type="text" name="litter_number" value="{{$litter->litter_number}}" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4" style="margin-bottom: 15px">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.LitterTitle'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('menu.LitterTitle')" label="name"
                                          v-model="selected_litter_tittle"
                                          :options="litterTittle">
                                </v-select>
                                <input type="hidden" name="liiter_tittle"
                                       v-model.number="(!selected_litter_tittle)?null:selected_litter_tittle.id">
                            </div>
                        </div>
                    </div>  
                </div>
                 
                <div class="row">
                    <div class="col-md-4" style="margin-bottom: 15px">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.ReferenceDepartment'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('menu.ReferenceDepartment')" label="name"
                                          v-model="selected_reference_department"
                                          :options="referenceDepartment">
                                </v-select>
                                <input type="hidden" name="reference_department"
                                       v-model.number="(!selected_reference_department)?null:selected_reference_department.id">
                           
                           
                            </div>
                        </div>
                    </div> 

                    <div class="col-md-4" style="margin-bottom: 15px">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.LitterCategory'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.LitterCategory')" label="name"
                                          v-model="selected_litterCategories"
                                          :options="litterCategories">
                                </v-select>
                                <input type="hidden" name="litter_category"
                                       v-model.number="(!selected_litterCategories)?null:selected_litterCategories.id">                     
                                
                            </div>
                        </div>
                    </div> 

                    <div class="col-md-4" style="margin-bottom: 15px">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Title'):</label>
                            <div class="col-md-9">
                                <input type="text" name="title" value="{{$litter->title}}" class="form-control">
                            </div>
                        </div>
                    </div>
                    
                </div>
                <div class="row">
                  
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Type'):</label>
                            <div class="col-md-9">
                                <select name="type" v-model="type" class="form-control">
                                    <option value="in"  >@lang('type.import')</option>
                                    <option value="out">@lang('type.export')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date')</label>
                            <div class="col-md-9">
                                <input type="text" name="date" class="form-control date now" autocomplete="off"value="{{convertDate($litter->date)}}">
                            </div>
                        </div>
                    </div>
                     
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description')</label>
                            <div class="col-md-9">
                              <textarea name="description" class="form-control">{{$litter->description}}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    
                    <div class="col-md-7" style="margin-right: 80px; margin-top:20px;">
                        <div class="form-group">
                          <div class="fileinput fileinput-new" data-provides="fileinput">
                              <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                  <img src="" alt=""> </div>
                              <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                              <div>
                                  <span class="btn default btn-file">
                                      <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                      <span class="fileinput-exists">@lang('layout.Change')</span>
                                      <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                      
                                  <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                              </div>

                          </div>
                      </div>
                  </div>
              </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    
                    <a href="{{route('litter.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);
        // var work_time = {!!getCompanyWorkAmount()['hourly']!!};
        var litterCategories = {!! $litterCategories !!};

        var litter = {!! $litter !!};
        var referenceDepartment = {!! $referenceDepartment !!};
        var litterTittle = {!! $litterTittle !!};

        let vu = new Vue({
            el: '#app',
            data: {
                type: 'import',
                referenceDepartment:referenceDepartment,
                selected_reference_department: null,
                litterTittle:litterTittle,
                selected_litter_tittle: null,
                litterCategories:litterCategories,
                selected_litterCategories: null,
            },
            mounted() {
                if (litter.litter_category_id && litterCategories) {
                    this.selected_litterCategories = _.find(litterCategories, (s) => s.id == litter.litter_category_id);
                }
                if (litter.reference_department_id && referenceDepartment) {
                    this.selected_reference_department = _.find(referenceDepartment, (s) => s.id == litter.reference_department_id);
                }
                if (litter.litter_tittle_id && litterTittle) {
                    this.selected_litter_tittle = _.find(litterTittle, (s) => s.id == litter.litter_tittle_id);
                }
                if (litter.type) {
                this.type = litter.type;
            }
                
            },
             
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            regForm(e.target);
                        }
                    });
                },
             
                
            }
        })

    </script>
@endpush 