@extends('layouts.app')
@section('content')

@include('customers.amodal')

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.AddLitter')</span>
                  
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;" v-cloak>
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'litter.store','method'=>'POST','enctype'=> 'multipart/form-data', 'class'=>'form-horizontal', 'id'=>'litter_form')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <input type="hidden" name="path" value="uploads/litters">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Number'):</label>
                            <div class="col-md-9">
                                <input type="number" name="number" value="{{$number}}" class="form-control">
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.LitterNumber'):</label>
                            <div class="col-md-9">
                                <input type="text" name="litter_number" class="form-control">
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.LitterTitle'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('menu.LitterTitle')" label="name"
                                          v-model="litterTittle"
                                          :options="{{json_encode($litterTittle)}}">
                                </v-select>
                                <input type="hidden" name="liiter_tittle"
                                       v-model.number="(!litterTittle)?null:litterTittle.id">
                                       
                                    </div>
                        </div>
                    </div>  

                </div>
                 
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('menu.ReferenceDepartment'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('menu.ReferenceDepartment')" label="name"
                                          v-model="referenceDepartment"
                                          :options="{{json_encode($referenceDepartment)}}">
                                </v-select>
                                <input type="hidden" name="reference_department"
                                       v-model.number="(!referenceDepartment)?null:referenceDepartment.id">
                            </div>
                        </div>
                    </div> 


                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.LitterCategory'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.LitterCategory')" label="name" v-model="litterCategories" :options="{{json_encode($litterCategories)}}">
                                </v-select>
                                <input type="hidden" name="litter_category" v-model.number="(!litterCategories)?null:litterCategories.id">
                            </div>
                        </div>
                    </div> 

                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Title'):</label>
                            <div class="col-md-9">
                                <input type="text" name="title" class="form-control">
                            </div>
                        </div>
                    </div>
                     
                    
                </div>
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description')</label>
                            <div class="col-md-9">
                              <textarea name="description" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Type'):</label>
                            <div class="col-md-9">
                                <select name="type" class="form-control">
                                    <option value="in"  >@lang('type.import')</option>
                                    <option value="out">@lang('type.export')</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Date')</label>
                            <div class="col-md-9">
                                <input type="text" name="date" class="form-control date now" autocomplete="off">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    
                    <div class="col-md-7" style="margin-right: 80px;">
                        <div class="form-group">
                          <div class="fileinput fileinput-new" data-provides="fileinput">
                              <div class="fileinput-new thumbnail" style="width: 200px; height: 150px;">
                                  <img src="" alt=""> </div>
                              <div class="fileinput-preview fileinput-exists thumbnail" style="max-width: 200px; max-height: 150px; line-height: 10px;"> </div>
                              <div>
                                  <span class="btn default btn-file">
                                      <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                      <span class="fileinput-exists">@lang('layout.Change')</span>
                                      <input type="hidden" value="" name=""><input type="file" name="photo"> </span>
                                      
                                  <a href="javascript:;" class="btn default fileinput-exists" data-dismiss="fileinput"> @lang('layout.Remove') </a>
                              </div>

                          </div>
                      </div>
                  </div>
              </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    
                    <a href="{{route('litter.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}


                {{-- {!! Form::open(array('method'=>'POST','class'=>'form-horizontal')) !!}
                {{ csrf_field() }}                                        
                <amodal :show="showcModalAccount" @close="showcModalAccount = false">
                    <h3 slot='cheader'>@lang('layout.CreateNewAccountStep')</h3>
                    <div slot="cbody">
                    @if(getAccountNumber()=="true")
                        <label class="cform-label" for="name">@lang('layout.AccountNumber'):</label>
                        <input type="number" name="number" class="cform-control"  v-model="numberAcc" placeholder="@lang('layout.AccountNumber')" autocomplete="off">
                        <span class="required">@{{account_errors.number}}</span>
                    @endif
                        
                        <label class="cform-label" for="name">@lang('layout.AccountName'):</label>
                        {{Form::text('name','null',['class' => 'cform-control','placeholder' => __('layout.AccountName'),'v-model'=>'nameAcc','autocomplete'=>'off'])}}
                        <span class="required">@{{account_errors.name}}</span>
                        
                        <label class="cform-label" for="description">@lang('layout.Description'):</label>
                        {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'cform-control','rows' => 4, 'cols' => 30,'v-model'=>'descriptionAcc')) !!}
                    
                    </div>
                    <div slot="cfooter">
                        <button type="button" class="modal-default-button btn btn-success" @click="saveAccount">
                            @lang('layout.Submit')
                        </button>
                    </div>
                </amodal>
                
                
                {!! Form::close() !!} --}}
            </div>
                           
        </div>
    </div>
    
<!--******************************************************************************************
**************************Begin Add New Account Form Modal************************************
**********************************************************************************************-->

<!--******************************************************************************************
************************** End Add New Account Form Modal*************************************
**********************************************************************************************-->  

@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        Vue.component("v-select", VueSelect.VueSelect);
    
        
 
        let vu = new Vue({
            el: '#app',
            data: {
                litterTittle : null,
                referenceDepartment: null,
                litterCategories: null,
              
            },
             
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            regForm(e.target);
                        }
                    });
                },
                // saveAccount: function () {
                    // if(this.numberAcc != null)
                    // {
                    // var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,number:this.numberAcc,add: true};
                    // }
                    // else{
                    //     var test = {name: this.nameAcc, description:this.descriptionAcc, parent_id: this.parentAcc,type: this.acount_type,add: true};
                    // }
                    // var req = axios.post("{{route('account.addAccount')}}",test)
                    // .then(function (response) {
                    //     if (response) {
                    //         if(response.data.account.type == "accountsReceivable"){
                    //             vu.selected_receivable = response.data.account;
                    //         } if(response.data.account.type == "accountsPayable"){
                    //             vu.selected_payable = response.data.account;
                    //         } 
                             
                    //         vu.account_success = response.data.message;
                    //         if(vu.account_success)
                    //         {
                    //         toastr.success(vu.account_success)

                    //         }

                    //             vu.showcModalAccount = false;
                    //             vu.nameAcc           = null,
                    //             vu.numberAcc           = null,
                    //             vu.descriptionAcc    = null,
                    //             // vu.parentAcc      = null,
                    //             vu.typeAcc           = null;
                    //             vu.acount_type       = '';
                                
                    //     }
                    //     })
                    //     .catch(function (error) {
                    //         vu.account_errors = error.response.data.errors;
            
                    // });
                    // },
        
    },
  
  });  
             
                
          
    </script>
@endpush 