@extends('layouts.factor-master')
@section('content')

<?php
$report = customeReportNew('litter_index');
$_record= !in_array('record', $report);
$_litter_number= !in_array('litter_number', $report);
$_litter_category= !in_array('litter_category', $report);
$_date= !in_array('date', $report);
$_description= !in_array('description', $report);
$_litter_title= !in_array('litter_title', $report);
$_title= !in_array('title', $report);
$_reference_department= !in_array('reference_department', $report);
$_type= !in_array('type', $report);
$_status= !in_array('status', $report);
$_result= !in_array('result', $report);




$report_percent = customeReportNewPercent('litter_index');
$_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
$_litter_number_percent= (array_key_exists('litter_number___percent', $report_percent))?$report_percent['litter_number___percent']:null;
$_litter_category_percent= (array_key_exists('litter_category___percent', $report_percent))?$report_percent['litter_category___percent']:null;
$_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
$_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
$_litter_title_percent= (array_key_exists('litter_title___percent', $report_percent))?$report_percent['litter_title___percent']:null;
$_title_percent= (array_key_exists('title___percent', $report_percent))?$report_percent['title___percent']:null;
$_reference_department_percent= (array_key_exists('reference_department___percent', $report_percent))?$report_percent['reference_department___percent']:null;
$_type_percent= (array_key_exists('type___percent', $report_percent))?$report_percent['type___percent']:null;
$_status_percent= (array_key_exists('status___percent', $report_percent))?$report_percent['status___percent']:null;
$_result_percent= (array_key_exists('result___percent', $report_percent))?$report_percent['result___percent']:null;

// dd($_record_percent);

?>

<h3 class="table-caption" style="text-align: center;">@lang('layout.LitterReport')</h3>

@if($from_date || $to_date || $litterCategories_name || $referenceDepartment_name || $litterTittle_name)
<table class="main-table">
    <tr class="bg">
       
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
        @endif 
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
        @endif

        @if($litterCategories_name)
        <td>
            <span>@lang('layout.LitterCategory')</span>:
            <BDO>{{$litterCategories_name}}</BDO>
        </td>
        @endif  

        @if($referenceDepartment_name)
        <td>
            <span>@lang('layout.ReferenceDepartment')</span>:
            <BDO>{{$referenceDepartment_name}}</BDO>
        </td>
        @endif

        @if($litterTittle_name)
        <td>
            <span>@lang('layout.LitterTitle')</span>:
            <BDO>{{$litterTittle_name}}</BDO>
        </td>
        @endif
    </tr>
</table>
<br>
@endif

<table class="main-table">
        <tr class="bg">
            @if($_record)<th @if($_record_percent) width="{{$_record_percent}}%" @endif>@lang('layout.Number')</th>@endif
            @if($_litter_number)<th @if($_litter_number_percent) width="{{$_litter_number_percent}}%" @endif>@lang('layout.LitterNumber')</th>@endif
            @if(!$litterCategories_name)
            @if($_litter_category)<th @if($_litter_category_percent) width="{{$_litter_category_percent}}%" @endif>@lang('layout.LitterCategory')</th>@endif
            @endif
            @if($_date)<th @if($_date_percent) width="{{$_date_percent}}%" @endif>@lang('layout.Date')</th>@endif
            @if($_description)<th @if($_description_percent) width="{{$_description_percent}}%" @endif>@lang('layout.Description')</th>@endif
            @if(!$litterTittle_name)
            @if($_litter_title)<th @if($_litter_title_percent) width="{{$_litter_title_percent}}%" @endif>@lang('layout.LitterTitle')</th>@endif
            @endif
            @if($_title)<th @if($_title_percent) width="{{$_title_percent}}%" @endif>@lang('layout.Title')</th>@endif
            @if(!$referenceDepartment_name)
            @if($_reference_department)<th @if($_reference_department_percent) width="{{$_reference_department_percent}}%" @endif>@lang('layout.ReferenceDepartment')</th>@endif
            @endif
            @if($_type)<th @if($_type_percent) width="{{$_type_percent}}%" @endif>@lang('layout.Type')</th>@endif
            @if($_status)<th @if($_status_percent) width="{{$_status_percent}}%" @endif>@lang('layout.Status')</th>@endif
            @if($_result)<th @if($_result_percent) width="{{$_result_percent}}%" @endif>@lang('layout.Result')</th>@endif
           
        </tr>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr> 
        @if($_record)<td class="center">{{++$count}}</td>@endif
        @if($_litter_number)<td class="center">{{$record->litter_number}}</td>@endif
        @if(!$litterCategories_name)
        @if($_litter_category)<td class="center">{{$record->cat_name}}</td>@endif
        @endif
        @if($_date)<td class="center">{{convertDate($record->date)}}</td>@endif
        @if($_description)<td class="center" style="@if($_description_percent) text-align: justify @endif">{{$record->description}}</td>@endif
        @if(!$litterTittle_name)
        @if($_litter_title)<td style="text-align: center;">{{$record->lit_tit_name}}</td>@endif
        @endif
        @if($_title)<td  style="text-align: center;">{{$record->title}}</td>@endif
        @if(!$referenceDepartment_name)
        @if($_reference_department)<td class="center"> {{$record->ref_name}}</td>@endif
        @endif
       @if($record->type == 'in')
        @if($_type)<td class="center">@lang('type.import')</td>@endif
        @else
        @if($_type)<td class="center">@lang('type.export')</td>@endif
        @endif
        @if($record->status == 'Waiting')
        @if($_status)<td class="center"> @lang('layout.Waiting')</td>@endif
        @elseif($record->status == 'Accepted')
        @if($_status)<td class="center text-success" style="color:green"> @lang('layout.Accepted')</td>@endif
        @elseif($record->status == 'Suspended')
        @if($_status)<td class="center text-warning" style="color:orange"> @lang('layout.Suspended')</td>@endif
        @else
        @if($_status)<td class="center text-danger" style="color:red;"> @lang('layout.Rejected')</td>@endif
        @endif
         
        @if($_result)<td class="center" >{{$record->descriptiontwo}}</td>@endif
       
 

    </tr>
    @endforeach
</table>

<table>
    <tr>

    </tr>
</table>


<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection