@extends('layouts.app')

@section('style')

<style>

.modal-container{
    width: 50% !important;
}
</style>
@endsection

@section('content')

{{-- <div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                  :value-type="'user_list'"
                  @closed="closeModal">

        <div slot="body">
        </div>
    </report-modal>
</div> --}}

    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">  @lang('layout.LinkedDeviceList')  </span>
                </div>
                <div class="tools"></div>
                @if(systemConfig()[31] == 1)
                <div class="pull-right" style="border: 1px dotted black; padding:15px;">
                    {!! DNS2D::getBarcodeSVG("$mobile_qrcode", "QRCODE", 4, 4,$qr_color) !!}
                </div>
                @endif

            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>

                <table class="table table-striped table-bordered table-hover" id="linked_device_table">
                    <thead>
                    <tr>
                        <th>@lang('layout.ID')</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.DeviceId')</th>
                        <th>@lang('layout.DeviceType')</th>
                        <th>@lang('layout.DeviceVersion')</th>
                        <th>@lang('layout.DeviceModel')</th>
                        <th>@lang('layout.IsPhysicalDevice')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Actions')</th>

                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>



@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')

    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#linked_device_table').DataTable({
                ajax: '{{route("linkedDevices.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'id', name: 'linked_devices.id'},
                    {data: 'number', name: 'linked_devices.number'},
                    {data: 'device_id', name: 'linked_devices.device_id'},
                    {data: 'device_type', name: 'linked_devices.device_type'},
                    {data: 'device_version', name: 'linked_devices.device_version'},
                    {data: 'device_model', name: 'linked_devices.device_model'},
                    {data: 'is_physical_device', name: 'linked_devices.is_physical_device', orderable: false, searchable: false},
                    {data: 'date', name: 'linked_devices.created_at', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},


                ]
            });
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                   if(typeof data_table =='object')
                   {
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });

        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('users.report') !!}',
                excelRoute: '{!! route('users.report') !!}',
            },
           



            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    vm.$data.is_show = true;
                }
            }
        });       
        
        


    </script>
@endpush