@extends('layouts.factor-master')

@section('content')

   <h3 class="table-caption" style="text-align: center;">@lang('menu.Users')</h3>


  <table class="main-table">
    <thead>
      <tr class="bg">
      <td class="center">  @lang('layout.Record') </td>
      <td class="center"> @lang('layout.Name') </td>
      <td class="center"> @lang('layout.Email') </td>
      <td class="center"> @lang('layout.UserType') </td>
      <td class="center"> @lang('layout.Language')</td>
      <td class="center"> @lang('layout.Date')</td>
      <td class="center"> @lang('layout.Role')</td>
      <td class="center"> @lang('layout.InActiveChangeName')</td>
      {{-- <td class="center"> @lang('layout.Company')</td> --}}
      @if($report_format=="pdf")
      <td class="center"> @lang('layout.Photo')</td>
      @endif


    </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
      <td class="center">{{++$count}}</td>
      <td  class="center">{{$record->name}}</td>
      <td  class="center">{{$record->email}}</td>
      <td  class="center">{{($record->user_type)?__('type.'.$record->user_type):''}}</td>
      <td  class="center">{{ __('type.' . $record->lang)}}</td>
      <td  class="center">{{convertDate($record->date)}}</td>
      <td  class="center">{{$record->display_name}}</td>
      @if($record->change_user_name == 'off')
      <td  class="center"> @lang('layout.InActive') </td>
      @else
      <td  class="center"> @lang('layout.Active') </td>
      @endif
      @if($report_format=="pdf")
      <td  class="center">
        @if($record && $record->photo !=Null)
        <img src="{!!url('/uploads/'.$record->photo)!!}" style="width:50px; height:50px;">
        @else
        <img  src="{{asset('uploads/avatar.png')}}"style="width:50px; height:50px;">
        @endif
      </td>
      @endif

    </tr>
    @endforeach
</table>



 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection