
<style type="text/css">
    * {
    box-sizing: border-box;
}
.invmodal-mask {
    position: fixed;
    z-index: 9998;
    top: 0px;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, .5);
    transition: opacity .3s ease;
}

.invmodal-container {
    width: 700px;
    max-width: 90%;
    height: 90%;
    max-height: 500px;
    margin: 0px auto;
    padding: 20px 30px;
    margin-top: 20;
    background-color: #fff;
    border-radius: 2px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
    transition: all .3s ease;
    font-family: Helvetica, Arial, sans-serif;
    overflow-y: auto;
}

.invmodal-header h3 {
    margin-top: 0;
    color: #42b983;
}

.invmodal-body {
    margin: 20px 0;
}

.text-right {
    text-align: right;
}

.cform-label {
    display: block;
    margin: 5px 0;
}

.form-label > .form-control {
    margin-top: 0.5em;
}



/*
 * The following styles are auto-applied to elements with
 * transition="modal" when their visibility is toggled
 * by Vue.js.
 *
 * You can easily play with the modal transition by editing
 * these styles.
 */

.invmodal-enter {
  opacity: 0;
}

.invmodal-leave-active {
  opacity: 0;
}

select.form-control{
    border: 1px solid #c2cad8;
}
.modal-enter .invmodal-container,
.modal-leave-active .invmodal-container {
  -webkit-transform: scale(1.1);
  transform: scale(1.1);
}
.form-horizontal .form-group{
    margin-left: 0px;
    margin-right: -15px;
}
</style>
<script type="x/template" id="invmodal-template">

    <transition name="invmodal">
        <div class="invmodal-mask" v-show="show">
            <div class="invmodal-container">
            <div class="col-md-12">
                    <form id="modalFormInv">
                        <div class="form-group col-md-4">
                            <label>@lang("layout.ItemName")</label>
                            <input type="text" class="form-control" name="name" placeholder="{{__('layout.EnterItemName')}}" autocomplete="off"/>
                        </div> 
                        <div class="form-group col-md-4">
                            <label>@lang("layout.ItemType")</label>
                            <select class="form-control" name="type" >
                                <option selected="selected" value="inventoryPart">@lang('layout.InventoryPart')</option>
                                <option value="inventoryAssembly">@lang('layout.InventoryAssembly')</option>
                                <option value="workingProgress">@lang('layout.WorkingProgress')</option>
                                <option value="procurement">@lang('layout.Procurement')</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label>@lang("layout.ItemCode")</label>
                            <input type="text" class="form-control" name="number"  v-model="number" placeholder="{{__('layout.ItemCode')}}" autocomplete="off"/>
                        </div>
                        <div class="form-group col-md-4">
                            <label>@lang("layout.U_M_Set")</label>
                            <div class="input-group">
                                <v-select  label="name"  :options="measureList" v-model="selectMeasure" placeholder="@lang('layout.SelectUnitMeasure')"></v-select> 
                                <span class="btn btn-success input-group-addon " title="@lang('layout.AddMeasure')" @click="showMeasureModal" style="background-color:  rgb(84, 199, 211)">
                                    <i class="fa fa-plus" style="color: white"></i>
                                </span> 
                            </div>
                        </div>
                        <div class="form-group col-md-4">
                            <label>@lang("layout.Category")</label>
                            <v-select  label="name"  :options="categories" v-model="category" placeholder="@lang('layout.SelectInventoryCategory')" ></v-select>
                        </div>
                        <div class="form-group col-md-4">
                            <label>@lang("layout.Gauge")</label>
                            <input type="number" class="form-control" name="gauge" placeholder="{{__('layout.Gauge')}}" autocomplete="off"/>
                        </div>
                        <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                            <div class="form-group col-md-4">
                                <label>@lang("layout.Default_Rate")</label>
                                <input type="number" class="form-control" name="rate"  v-model="rate" step="any" placeholder="{{__('layout.Default_Rate')}}" autocomplete="off"/>
                            </div>
                            <div class="form-group col-md-4">
                                <label>@lang("layout.Description")</label>
                                <input type="text" class="form-control" name="description"  v-model="description" placeholder="{{__('layout.Description')}}" autocomplete="off"/>
                            </div>
                        </div>
                        <div class="col-md-12" style="padding-right: 0px !important; padding-left: 0px !important;">
                            <div class="form-group col-md-4">
                                <label>@lang("layout.IncomeAccount")</label>
                                <v-select  label="name" :options="income" v-model="incomeAccount" placeholder="@lang('layout.SelectIncomeAccount')" ></v-select>
                            </div>
                            <div class="form-group col-md-4">
                                <label>@lang("layout.CostCogsInInventory")</label>
                                <v-select  label="name" :options="cost" v-model="costAccount" placeholder="@lang('layout.SelectCostAccount')" ></v-select>
                            </div>
                            <div class="form-group col-md-4">
                                <label>@lang("layout.InventoryAssetAccount")</label>
                                <v-select  label="name" :options="asset" v-model="assetAccount" placeholder="@lang('layout.SelectAssetAccount')" ></v-select>
                            </div>
                        </div>

                    </form>
                    </div>
                
                <div class="invmodal-footer text-right" >
                    <hr>
                    <input type="hidden" :value="number" name="number"/>
                    <button type="button" @click="onSubmit" class="btn blue">@lang('layout.Submit')</button>
                    <button type="button" style="margin:0px 5px 0px 5px" class="btn red" @click="$emit('close')" >@lang('layout.Cancel')</button>
                </div>
            </div>
        </div>
    </transition> 
    
</script>


