
<style type="text/css">
    * {
    box-sizing: border-box;
}
.cmodal-mask {
    position: fixed;
    z-index: 9998;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, .5);
    transition: opacity .3s ease;
}

.cmodal-container {
    width: 700px;
    margin: 40px auto 0;
    padding: 20px 30px;
    background-color: #fff;
    border-radius: 2px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
    transition: all .3s ease;
    font-family: Helvetica, Arial, sans-serif;
}

.cmodal-header h3 {
    margin-top: 0;
    color: #42b983;
}

.cmodal-body {
    margin: 20px 0;
}

.text-right {
    text-align: right;
}

.cform-label {
    display: block;
    margin: 5px 0;
}

.form-label > .form-control {
    margin-top: 0.5em;
}



/*
 * The following styles are auto-applied to elements with
 * transition="modal" when their visibility is toggled
 * by Vue.js.
 *
 * You can easily play with the modal transition by editing
 * these styles.
 */

.cmodal-enter {
  opacity: 0;
}

.cmodal-leave-active {
  opacity: 0;
}

select.form-control{
    border: 1px solid #c2cad8;
}
.modal-enter .cmodal-container,
.modal-leave-active .cmodal-container {
  -webkit-transform: scale(1.1);
  transform: scale(1.1);
}
.form-horizontal .form-group{
    margin-left: 0px;
    margin-right: -15px;
}
</style>
<script type="x/template" id="Drivermodal-template">
    <transition name="Drivermodal">
        <div class="cmodal-mask" v-show="show">
            <div class="cmodal-container">
            <div class="col-md-12">
                    <form id="DriverModalForm">
                        <div class="form-group col-md-4">
                            <label>@lang("layout.Name")</label>
                            <input type="text" class="form-control" name="name" placeholder="{{__('layout.Name')}}"/>
                        </div> 
                        <div class="form-group col-md-4">
                            <label>@lang("layout.Code")</label>
                            <input type="text" class="form-control" name="code"  v-model="code" placeholder="{{__('layout.Code')}}"/>
                        </div>
                        
                        <div class="form-group col-md-4">
                            <label>@lang("layout.Email")</label>
                            <input type="text" class="form-control" name="email" placeholder="{{__('layout.Email')}}"/>
                        </div>
                        <div class="form-group col-md-6">
                            <label>@lang("layout.DriverType")</label>
							<select name="driver_type" class="list-style form-control" style="border: 1px solid #c2cad8 !important;">
								<option selected value="OwnDriver">@lang('layout.OwnDriver')</option>
								<option value="ForeignDriver">@lang('layout.ForeignDriver')</option>
							</select>
                        </div>
                        <div class="form-group col-md-6">
                            <label>@lang("layout.PlateNumber")</label>
                            <input type="text" class="form-control"  name="plate_number" placeholder="{{__('layout.PlateNumber')}}"/>
                            
                        </div>
                        <div class="form-group col-md-6">
                            <label>@lang("layout.Phone")</label>
                            <input type="number" class="form-control"  name="phone" placeholder="{{__('layout.Phone')}}"/>
                            
                        </div>
                        <div class="form-group col-md-6">
                            <label>@lang("layout.Address")</label>
                            <input type="text" class="form-control"  name="address1" placeholder="{{__('layout.Address')}}"/>
                            
                        </div>
                        <div class="form-group col-md-6">
                            <label>@lang("layout.AccountsReceivable")</label>
                            <v-select  label="name"  :options="receivables" v-model="selectReceive"></v-select>  
                        </div>
                        <div class="form-group col-md-6">
                            <label>@lang("layout.AccountsPayable")</label>
                            <v-select  label="name"  :options="payables" v-model="selectPay"></v-select>
                            
                            
                        </div>
                        <div class="form-group col-md-6">
                            <label>@lang("layout.Type")</label>
                            <v-select  label="type"  :options="types" v-model="selectType"></v-select>
                        </div>

                        <div class="form-group col-md-6">
                            <label>@lang("layout.Class")</label>
                            <v-select  label="name" v-model="selectedClass"  :options="classes"></v-select>
                        </div>

                    </form>
                    </div>
                
                <div class="cmodal-footer text-right" >
                    <hr>
                    <input type="hidden" :value="code" name="code"/>
                    <button type="button" @click="onSubmit" class="btn blue">@lang('layout.Submit')</button>
                    <button type="button" style="margin:0px 5px 0px 5px" class="btn red" @click="$emit('close')" >@lang('layout.Cancel')</button>
                </div>
            </div>
        </div>
    </transition> 
    
</script>


