<style type="text/css">
    * {
    box-sizing: border-box;
}
.cmodal-mask {
    position: fixed;
    z-index: 9998;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, .5);
    transition: opacity .3s ease;
    display: flex;
    justify-content: center;
    align-items: center;
}
.cmodal-container {
    width: 700px;
    max-width: 90%;
    height: 40%;
    max-height: 600px;
    padding: 20px 30px 0px 30px;
    background-color: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 8px rgba(0, 0, 0, .33);
    transition: all .3s ease;
    font-family: Helvetica, Arial, sans-serif;
    overflow-y: auto;
    /* display: flex; */
    /* flex-direction: column; */
    /* justify-content: center; */
    /* align-items: center; */
    /* align-content: center; */
    transition: 1s;
}
.cmodal-container:hover{
    /* transform: scale(1.01); */
}
.cmodal-header h3 {
    margin-top: 0;
    color: #42b983;
}
.cmodal-body {
    margin: 20px 0;
}
.text-right {
    text-align: center;
}
.cform-label {
    display: block;
    margin: 5px 0;
}
.form-label > .form-control {
    margin-top: 0.5em;
}
/*
 * The following styles are auto-applied to elements with
 * transition="modal" when their visibility is toggled
 * by Vue.js.
 *
 * You can easily play with the modal transition by editing
 * these styles.
 */
.cmodal-enter {
  opacity: 0;
}
.cmodal-leave-active {
  opacity: 0;
}
select.form-control{
    border: 1px solid #c2cad8;
}
.modal-enter .cmodal-container,
.modal-leave-active .cmodal-container {
  -webkit-transform: scale(1.1);
  transform: scale(1.1);
}
.form-horizontal .form-group{
    margin-left: 0px;
    margin-right: -15px;
}
.firstRowContent{
    display: flex;
    justify-content: center;
}
.cmodalHeader{
    margin-bottom: 4em;
}
</style>
<script type="x/template" id="cmodal-template">
    <transition name="cmodal">
        <div class="cmodal-mask" v-show="show">
            <div class="cmodal-container">
                <div class="cmodalHeader">
                    <h3 style="text-align: center;">@lang('layout.NewMember')</h3>
                </div>
                <div class="col-md-12">
                    <form id="modalForm">
                        <div class="row firstRowContent">
                            <div class="form-group col-lg-4 col-md-4">
                                <label>@lang("layout.Name")</label>
                                <input type="text" class="form-control" name="name" autocomplete="off"/>
                            </div> 
                            <div class="form-group col-lg-4 col-md-4">
                                <label>@lang("layout.Code")</label>
                                <input type="number" class="form-control" name="code"  v-model="code"  autocomplete="off"/>
                            </div>
                            <div class="form-group col-lg-4 col-md-4">
                                <label>@lang("layout.Email")</label>
                                <input type="email" class="form-control"  name="email" autocomplete="off"/>
                            </div>
                        </div>
                        <!-- div class="form-group col-md-6">
                            <label class="control-label">@lang('layout.OpeningBalance')</label>
                            <div class="input-group">
                                <div class="col-md-6">
                                    <label class="radio-inline">
                                        <input type="radio" name="type" checked="checked" value="receivable" /> @lang('layout.Receivable') 
                                    </label>
                                </div> 
                                <div class="col-md-6">
                                    <label class="radio-inline">
                                        <input type="radio" name="type" value="payable" /> @lang('layout.Payable') 
                                    </label>
                                </div> 
                            </div> 
                        </div> -->
                        <!--<div class="form-group col-md-6">
                            <label>@lang("layout.Amount")</label>
                            <div class="input-group">
                                <input type="number" name="amount" placeholder="{{__('layout.Amount')}}" class="form-control">
                                <span class="input-group-addon">
                                    @{{defaultCurrency()["symbol"]}}
                                </span>
                            </div>
                        </div -->
                        <div class="row firstRowContent">
                            <div class="form-group col-lg-4 col-md-4">
                                <label>@lang("layout.Phone")</label>
                                <input type="number" class="form-control"  name="phone" autocomplete="off"/>   
                            </div>
                            <div class="form-group col-lg-4 col-md-4">
                                <label>@lang("layout.Address")</label>
                                <input type="text" class="form-control"  name="address1" autocomplete="off"/>
                            </div>
                            <div class="form-group col-lg-4 col-md-4">
                                <label>@lang("layout.AccountsReceivable")</label>
                                <v-select  label="name"  :options="receivables" v-model="selectReceive"></v-select>  
                            </div>
                        </div>
                        <div class="row firstRowContent">
                            <div class="form-group col-lg-4 col-md-4">
                                <label>@lang("layout.AccountsPayable")</label>
                                <v-select  label="name"  :options="payables" v-model="selectPay"></v-select>
                            </div>
                            <div class="form-group col-md-4">
                                <label>@lang("layout.Type")</label>
                                <v-select  label="type"  :options="types" v-model="selectType"></v-select>
                            </div>
                            <div class="form-group col-md-4">
                                <label>@lang("layout.Class")</label>
                                <v-select  label="name" v-model="selectedClass"  :options="classes"></v-select>
                            </div>
                        </div>
                        @if (fingerprint() =='true')
                        <div class="col-lg-4 col-md-4">
                            <label>@lang('layout.Fingerprint')</label>
                            <div class="col-md-12 mt-checkbox">
                                <label class="mt-checkbox mt-checkbox-outline">
                                    <input type="checkbox" name="addfinger">
                                    <span></span>
                                </label>
                            </div>
                        </div>
                        @endif
                    </form>
                </div>    
                <hr>
                <div class="cmodal-footer text-right" style="margin-top: 30px;">
                    <input type="hidden" :value="code" name="code"/>
                    <button type="button" @click="onSubmit" class="btn blue">@lang('layout.Submit')</button>
                    <button type="button" style="margin:0px 5px 0px 5px" class="btn red" @click="$emit('close')" >@lang('layout.Cancel')</button>
                </div>
            </div>
        </div>
    </transition> 
</script>