@extends('layouts.app')

@section('title',trans('layout.OpenLastYear'))

@section('content')

<div class="portlet light bordered">
    <div class="portlet-title">
        <div class="caption font-dark">
            <i class="icon-settings font-dark"></i>
            <span class="caption-subject bold uppercase">{{ trans('layout.OpenLastYear') }} </span>
        </div>
        <div class="tools"> </div>
        <div class="pull-right">
            <a href="{{route('lastYear.openCurrentYear')}}">
                <button class="btn btn-info">
                    <i class="fa"></i> @lang('layout.OpenCurrentYear')
                </button>
            </a>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <span style="color: red;"> @lang('layout.Note') : @lang('message.BackupNote') </span>
        <div class="panel panel-default">
            {{-- <div class="panel-heading">
                <h3 class="panel-title">{{ trans('backup.list') }} &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
                </h3>
            </div> --}}
            <table class="table table-condensed">
                <thead>
                    <th>#</th>
                    <th>{{ trans('backup.file_name') }}</th>
                    <th>{{ trans('backup.file_size') }}</th>
                    <th>{{ trans('backup.created_at') }}</th>
                    <th class="text-center">{{ trans('backup.actions') }}</th>
                </thead>
                <tbody>
                    @forelse($backups as $key => $backup)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $backup->getFilename() }}</td>
                        <td>{{ formatSizeUnits($backup->getSize()) }}</td>
                        <td>{{ convertDate(date('Y-m-d H:i:s', $backup->getMTime())) }}</td>
                        <td class="text-center">
                            <a href="{{ route('lastYear.index', ['action' => 'restore', 'file_name' => $backup->getFilename()]) }}"
                                id="restore_{{ str_replace('.gz', '', $backup->getFilename()) }}"
                                class="btn btn-warning btn-xs"
                                title="{{ trans('backup.restore') }}"><i class="fa fa-rotate-left"></i></a>
                            <a href="{{ route('lastYear.download', [$backup->getFilename()]) }}"
                                id="download_{{ str_replace('.gz', '', $backup->getFilename()) }}"
                                class="btn btn-info btn-xs"
                                title="{{ trans('backup.download') }}"><i class="fa fa-download"></i></a>
                            <a href="{{ route('lastYear.index', ['action' => 'delete', 'file_name' => $backup->getFilename()]) }}"
                                id="del_{{ str_replace('.gz', '', $backup->getFilename()) }}"
                                class="btn btn-danger btn-xs"
                                title="{{ trans('backup.delete') }}"><i class="fa fa-remove"></i></a>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="3">{{ trans('backup.empty') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
    <div class="col-md-4">
        @include('last_year.forms')
    </div>
</div>

@endsection
