@extends('layouts.app')

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CloseYearEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
            
                </div>
            </div>
            <div class="portlet-body form" id="app" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($closeYear, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['closeYear.update',$closeYear->id]]) !!}
                <div class="form-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Name'):</label>
                            <div class="col-md-9">
                                
                                <input type="text" name="name" value="{{$closeYear->name}}" class="form-control" placeholder="@lang('layout.Name')">
                                
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.CloseDate'):</label>
                            <div class="col-md-9">
                                <input type="text" name="close_date" class="form-control date" value="{{$closeYear->close_date}}">
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-3"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.OpeningDate'):</label>
                            <div class="col-md-9">
                                <input type="text" name="opening_date" class="form-control date" value="{{$closeYear->opening_date}}">
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                <textarea name="description" class="form-control" placeholder="@lang('layout.Description')">{{$closeYear->description}}</textarea>
                            </div>
                        </div>
                        
                    </div>
                
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.BaseCurrency'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.SelectCurrency')" label="code"
                                        v-model="selected_currency"
                                        :options="{{json_encode($currency)}}">
                                </v-select>
                                <input type="hidden" name="currency"
                                    v-model.number="(!selected_currency)?null:selected_currency.code">
                            </div>
                        </div> 
                    </div>    
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.SaleNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('sale_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                                
                            </div>
                        </div>
                    </div> 
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.PurchaseNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('purchase_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                        
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.PaymentNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('pay_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                        
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ReceiveNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('recive_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div>
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.LoanNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('loan_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div> 
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.DrawingNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('drawing_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div>
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.BuildNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('build_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div>

                </div>

                <div class = "row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.ProjectNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('project_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                        
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.ContractNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('contract_no',null,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                        
                            </div>
                        </div>
                    </div>
                </div>

                
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                    <a href="{{route('closeYear.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection

@push('scripts')
    <script>
         Vue.component('v-select', VueSelect.VueSelect);
        new Vue({
            el: '#app',
            data: {
                currency:{!! json_encode($currency) !!},
                selected_currency :{!! json_encode($selected_currency) !!}
            },
            created() {
            },
            computed: {
                
                },
            methods:{
               
     
            }
        });
    </script>
@endpush