@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">  @lang('layout.CreateNewCloseYear')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'closeYear.store','method'=>'POST','class'=>'form-horizontal', 'id'=>'overtime_form')) !!}
                {{ csrf_field() }}
                <div class="form-body">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Name'):</label>
                            <div class="col-md-9">
                                
                                <input type="text" name="name" class="form-control" placeholder="@lang('layout.Name')">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.CloseDate'):</label>
                            <div class="col-md-9">
                                <input type="text" name="close_date" class="form-control date" autocomplete="off">
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-3"> 
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.OpeningDate'):</label>
                            <div class="col-md-9">
                                <input type="text" name="opening_date" class="form-control date" autocomplete="off">
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.Description'):</label>
                            <div class="col-md-9">
                                <textarea name="description" class="form-control" placeholder="@lang('layout.Description')"></textarea>
                            </div>
                        </div>
                        
                    </div>
                  
                </div>
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.BaseCurrency'):</label>
                            <div class="col-md-9">
                                <v-select placeholder="@lang('layout.SelectCurrency')" label="code"
                                          v-model="selectedCurrency"
                                          :options="{{json_encode($currency)}}">
                                </v-select>
                                <input type="hidden" name="currency"
                                       v-model.number="(!selectedCurrency)?null:selectedCurrency.code">
                            </div>
                        </div> 
                    </div>    
                    
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.SaleNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('sale_no',$sale_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                                
                            </div>
                        </div>
                    </div> 
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.PurchaseNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('purchase_no',$purchase_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                           
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.PaymentNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('pay_no',$pay_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                           
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.ReceiveNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('recive_no',$receive_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div>
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.LoanNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('loan_no',$loan_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div> 
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.DrawingNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('drawing_no',$drawing_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div>
                    <div class="col-md-3">
                            <div class="form-group">
                                <label class="control-label col-md-3">@lang('layout.BuildNumber'):</label>
                                <div class="col-md-9">
                                    {{Form::number('build_no',$build_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                            
                                </div>
                            </div>
                    </div>

                </div>

                <div class = "row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.ProjectNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('project_no',$project_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                        
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="control-label col-md-3">@lang('layout.ContractNumber'):</label>
                            <div class="col-md-9">
                                {{Form::number('contract_no',$contract_number,['class' => 'form-control','step' => 'any','min' =>'0'])}}
                        
                            </div>
                        </div>
                    </div>
                </div>
               
                   
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" @click="handleSubmit($event)"
                            class="btn green">@lang('layout.Submit')</button>
                    <!-- <button type="button" class="btn blue"
                            @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button> -->
                    <a href="{{route('closeYear.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
@endsection
@push('scripts')
    <script>
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif

        $(document).ready(function () {
            $('#initial-value-example').persianDatepicker({
                observer: true,
                format: 'YYYY/MM/DD',
                altField: '#observer-example-alt',
                altFormat: 'u',
                autoClose: true,
            });
        });
        Vue.component("v-select", VueSelect.VueSelect);
        let home = {!! $homeCurrency !!};
        let vu = new Vue({
            el: '#app',
            data: {
                selectedCurrency: home,
                selectedOvertimeType : null,
                selectedEmployee     : null,
                qty:null,
                amount:null
            },


            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                saveAndNew() {
                    this.$validator.validate()
                        .then(valid => {
                            if (valid) {

                                var url = "{{route('overtime.store')}}";
                                form_id = 'overtime_form';
                                var data = $('#' + form_id).serialize();

                                axios.post(url, data)
                                    .then(function (response) {
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            toastr.success('', response.data.message);
                                            vu.selectedEmployee = null;
                                            vu.selectedOvertimeType = null;
                                        }
                                        else {
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        }
                                    })
                                    .catch(function (error) {
                                        console.log(error);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });

                            }
                        })
                }
            }
        })

    </script>
@endpush 