@extends('layouts.app')

@section('style')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
 <link href="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.css')}}" rel="stylesheet" type="text/css"/>
 <style>

 
     
 </style>
@stop


@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i> &nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.LaboratoryTestCreate') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::open(array('route' => 'laboratoryTest.store','method'=>'POST','class'=>'form-horizontal','id'=>'clothCategory-submit')) !!}
                {{ csrf_field() }}
                <div class="form-body">
                    <table id="table_content" class="table table-bordered">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th style="min-width: 300px">@lang('layout.Name') <span class="required"> * </span></th>
                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(item,index) in laboratoryTest">
                            <td><span class="badge badge3 badge-success badge-roundless"> @{{index+1}}</span></td>
                            <td class="highlight">
                                <input type="text" @keyup="addNew(index)" v-on:click="addNew(index)"
                                    name="name[]" class="form-control" autocomplete="off" tabindex="1">
                            </td> 

                            <td>
                                <span v-if="laboratoryTest.length >1 "  v-on:click="deleteItem('index')"><i
                                            class="paddint-both glyphicon glyphicon-trash" style="color: red;"></i></span>
                            </td>

                        </tr> 
                        <tr style="background-color: rgb(255, 255, 255);">
                            <td>
                                <center>
                                    <button type="button" class="btn btn-success" @click="addNew('index')">
                                        <i class="fa fa-plus" ></i>
                                    </button>
                                </center>
                            </td> 
                            <td></td>
                        </tr>

                        </tbody>
                    </table>
                </div>
                <div class="col-md-4 col-md-offset-4 text-center">
                    <br>
                    <button type="button" @click="handleSubmit($event)" class="btn green" >@lang('layout.Submit')</button>
                    <a href="{{route('laboratoryTest.index')}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}

            </div>

            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif


        let v = new Vue({
            el: '#app',
            data: {
                laboratoryTest:
                    [
                        {name: null}

                    ]
            },
            methods: {
                handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
                            regForm(e.target);
                        }
                    });
                },
                addNew(index) {
                    if (this.laboratoryTest[index + 1] == undefined) {
                        this.laboratoryTest.push({name: null});
                    }

                },

                deleteItem(index) {
                    this.laboratoryTest.splice(index, 1);
                }   

                

            }
        })
    </script>

@endpush
 