@extends('layouts.app')

@section('style')
    <style>
        .iconStyle{
            font-size: 20px;
        }

        .modal-container {
            max-height: 600px;
            width: 30% !important;
            max-width: 30% !important;
        }

    </style>
@endsection

@section('content')

<div id="print-modal" >

<report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
    v-if="is_show" 
    :value-type="'laboratory_test_details'"
    
    @closed="closeModal" >

    <div slot="body">
         <input type="hidden" name="id" value="{{$laboratory->id}}"/>
    </div>
</report-modal>
</div>


  





    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.LaboratoryTestShow')
            </div>
            <div class="tools">
            </div>
        </div>
        <div class="portlet-body">
            @if ($laboratory)
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i></i> @lang('layout.Type')
                        </th>
                        <th class="">
                            <i></i> @lang('layout.Number')
                        </th>
                        <th class="">
                            <i></i> @lang('layout.User')
                        </th>
                        <th>
                            <i></i> @lang('layout.Date')
                        </th>
                        <th>
                            <i></i> @lang('layout.Description')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=" "> {{ __('layout.'.ucfirst($laboratory->type))}}  </td>
                        <td class=""> {{ $laboratory->type_number}}  </td>
                        <td class=""> {{ $laboratory->username }}  </td>
                        <td> {{ convertDate($laboratory->date)}}  </td>
                        <td> {{ $laboratory->description }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            @endif
        </div>


    </div>

    <div class="row">
    <div class="col-md-12 col-sm-12">
        <div class="portlet green-meadow box">
            <div class="portlet-title">
                <div class="caption">
                </div>
                <div class="tools"></div>
                <div class="actions">
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                </div>
          
            </div>

            <div class="portlet-body">
                <div class="row static-info">
                    <div class="col-md-12 value">

                        <table class="table">
                            <thead>
                                <tr class="active">
                                    <td>@lang('layout.Number')</td>
                                    <td>@lang('layout.CarNumber')</td>
                                    <td>@lang('layout.Item')</td>
                                    <td>@lang('layout.Unit')</td>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="active">
                                    <td>{{$laboratory->number}}</td>
                                    <td>{{$laboratory->vehicle_number}}</td>
                                    <td>{{$laboratory->item_name}}</td>
                                    <td>{{$laboratory->measure_name}}</td>
                                </tr>
                            </tbody>
                        </table>
                        <br>

                        <div >
                            <table class="table table-bordered" >
                                <thead>
                                    <tr class="active">
                                       <th>@lang('layout.LaboratoryDescription')</th>
                                       <th>@lang('layout.LaboratoryQty')</th>
                                       <!-- <th></th> -->
                                    </tr>
                                </thead> 
                                <tbody>
                                    @foreach ($laboratory_tests as $item)
                                        <tr>
                                            
                                            <td>{{$item->name}}</td>
                                            <td>{{$item->test_qty}}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                        </div>
                    
                         
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@include('print.modal')
@push('scripts')

    <script>
 



    var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
            },

            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
            });

            new Vue({
            el:'#anchore-modal',
            methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
            }
            });
    </script>


@endpush
