@extends('layouts.factor-master')

@section('content')

	<h4 class="table-caption" style="text-align: center;">@lang('layout.LaboratoryTestReport')</h4>
  @if($from_date || $to_date)
  <table class="main-table">
    <tr>
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
  </table>
  <br>
  @endif

<?php 
$counter = 0;
?>



<table style="width: 100%; margin-top: 10px;">
    <tr>
        @foreach($data AS $record)
        <?php
          $laboratory_tests = $record['laboratory_tests'];
        ?>
        <td style=" width:25%">
            <table class="main-table"  style="font-size: 12px;" >
                    <tr class="bg">
                        <td class="center">@lang('layout.Date'): {{convertDate($record['date'])}}</td>
                        <td class="center">@lang('layout.Number'): ({{$record['number']}})</td>
                    </tr>
                    <tr class="bg">
                        <td class="center">@lang('layout.Item'): {{$record['item_name']}}</td>
                        <td class="center">@lang('layout.CarNumber'): {{$record['vehicle_number']}}</td>
                    </tr>
            </table>
            <table class="main-table" style="font-size: 12px;margin-bottom:5px">
                <thead>
                    <tr class="active">
                        <th class="center">@lang('layout.LaboratoryDescription')</th>
                        <th class="center">@lang('layout.LaboratoryQty')</th>
                    </tr>
                </thead> 
                <tbody>
                    @foreach($laboratory_tests AS $row)
                        <tr>
                            
                            <td class="center">{{$row['name']}}</td>
                            <td class="center">{{$row['test_qty']}}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table> 
        </td>
        <?php 
        ++$counter; 
        ?>
            @if($counter%3==0)
        </tr>
    </table>
        <table>
            <tr>
            @endif
        @endforeach

    </tr>
</table>







<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection