@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.LaboratoryTestEdit') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>

            <div class="portlet-body form" style="margin-bottom:50%;" id="app">
                <!-- BEGIN FORM-->
                {!! Form::model($laboratory, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['laboratory.update',$laboratory->id]]) !!}
                {{ csrf_field() }}
                <div class="form-body">

                    <div class="row">
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Type')</label>
                                    <select name="type" v-model="type" class="form-control">
                                        <option value="">@lang('layout.SelectType')</option>
                                        <option value="purchases">@lang('layout.Purchase')</option>
                                        <option value="builds">@lang('layout.Build')</option>
                                        <option value="transfer_and_loadings">@lang('layout.TransferAndLoading')</option>
                                        <option value="sales">@lang('layout.Sale')</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                         <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">@lang('layout.TypeNumber')</label>
                                    <input type="number" name="type_number" v-model="type_number" class="form-control">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-1 col-md-1 col-sm-2 col-xs-12">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label">&nbsp;</label>
                                    <button type="button" class="btn btn-info form-control" @click="searchType">
                                    <i class="fa fa-search"></i>@lang('layout.Search')</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Number')</label>
                                    {{Form::text('number',null,['class' => 'form-control','placeholder' => __('layout.number')])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Date')</label>
                                    {{Form::text('date',null,['class' => 'form-control date','placeholder' => __('layout.number')])}}
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label">@lang('layout.Description')</label>
                                    <textarea name="description" class="form-control">{{$laboratory->description}}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                    <v-select v-if='type' class="vue-select2" v-model="selected_item" label="name" :options="laboratory_item" @input="(editKey)?labSelectedMeasure():''" @keyup.native="editKey = true" @Click.native="editKey = true" ></v-select>
                                    <v-select v-if='!type' class="vue-select2" v-model="selected_item" label="name" @search="onItemSearch" :options="laboratory_item" @input="(editKey)?labSelectedMeasure():''" @keyup.native="editKey = true" @Click.native="editKey = true" ></v-select>
                                    <input type="hidden" name="item_id" :value="!selected_item?null:selected_item.item_id" >
                                    <input type="hidden" name="loading_detail_id" :value="!selected_item?null:(!selected_item.loadingDetail?type_detail_id:selected_item.loadingDetail.id)" >
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.Unit') </label>
                                    <select name="um_id" class="form-control" v-model="selected_measure">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(selected_item ==null)?false:true">
                                            <option v-for="measure in measure" :value="measure.measure_id">
                                                @{{measure.measure_name}}
                                            </option>
                                        </span>
                                    </select>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <label class="control-label ">@lang('layout.CarNumber')</label>
                                    <input type="text" name="vehicle_number" v-model="vehicle" class="form-control" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div class="row">
                        <table id="table_content" class="table table-bordered">
                            <thead style="background-color: #36c6d3; color:white"> 
                            <tr>
                                @foreach ($laboratoryTest as $key=>$value)
                                <th >{{$value['name']}}</th>
                                @endforeach
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                @foreach ($laboratoryTest as $key=>$value)
                                <td class="highlight">
                                    <input type="text" name="laboratory_test[{{$value['id']}}]" class="form-control" autocomplete="off" value="{{$value['test_qty']}}">
                                </td> 
                                @endforeach

                            </tr> 
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                    <button type="button" class="btn green" onclick="regForm(this)">@lang('layout.Submit')</button>
                    <a href="{{url()->previous()}}" class="btn default"><i
                                class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                </div>
                {!! Form::close() !!}
            </div>

            <!-- END FORM-->
        </div>



    </div>

@endsection
@push('scripts')
    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        var laboratory_item = {!! $laboratory_item!!}
        var selected_item = {!! $selected_item!!}

        var measureUnitList  = {!! $measureUnitList!!}

        let v = new Vue({
            el: '#app',
            data: {
                type_number:null,
                editKey: false,
                type:'',
                laboratory_item:laboratory_item,
                selected_item:selected_item,
                measure:measureUnitList,
                vehicle:null,
                type_detail_id:null,
                selected_measure:1
            },
            mounted: function () {
                @if($laboratory->type && $type_number)
                this.type = "{{$laboratory->type}}";
                this.type_number = "{{$type_number}}";
                @endif

                @if($laboratory->measure_id)
                this.selected_measure = "{{$laboratory->measure_id}}";
                @endif

                @if($laboratory->vehicle_number)
                this.vehicle = "{{$laboratory->vehicle_number}}";
                @endif

                @if($laboratory->type_detail_id)
                this.type_detail_id = "{{$laboratory->type_detail_id}}";
                @endif
             
            },
            methods: {
                searchType()
                {
                    if(this.type && this.type_number)
                    {
                        axios.get("{{route('laboratory.search')}}", {
                            params: {
                                type: this.type,
                                type_number: this.type_number,
                            }
                        })
                        .then(function (response) {
                            // console.log(333, response.data);
                            v.laboratory_item = [];
                            v.selected_item=null;
                            if (response.data.length > 0) {
                                v.laboratory_item = response.data;
                            }
                        })
                        .catch(function (error) {
                            v.laboratory_item = [];
                            v.selected_item=null;
                            console.log(error);
                        })
                    }
                },

                labSelectedMeasure(){
                    if(v.selected_item!=null){
                        // console.log(132, v.selected_item);
                        v.type_detail_id = null;
                        if (v.selected_item.measure) {
                            v.selected_measure = v.selected_item.measure.measure_id;
                            v.measure = v.selected_item.measure_list;
                        } else if(v.selected_item.um_id) {
                            v.selected_measure = v.selected_item.um_id;
                        }
                        if (v.selected_item.loadingDetail) {
                            if (v.selected_item.loadingDetail.driver_type == "OwnDriver") {
                                v.vehicle = v.selected_item.loadingDetail.vehicle_name + " " + v.selected_item.loadingDetail.palet_number;
                            } else{
                                v.vehicle = v.selected_item.loadingDetail.other_vehicle_name;
                            }
                        }
                    }
                },

                onItemSearch: _.debounce((search, loading) => {
                    // console.log(234, search);
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale',
                            keyword: search
                        }
                    })
                    .then(function(response) {
                            v.laboratory_item = [];
                            v.selected_item=null;
                        if (response.data.length > 0) {
                            v.laboratory_item = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }, getDebounceTime()),
             
            }
        })
    </script>

@endpush
 