@extends('layouts.factor-master')

@section('content')

<h3 class="table-caption" style="text-align: center;">@lang('layout.LaboratoryTestReport')</h3>

@if($from_date || $to_date)
<table class="main-table">
    <tr class="bg">
        @if($from_date)
            <td>
                <span>@lang('layout.FromDate')</span>:
                <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
            </td>
        @endif
        @if($to_date)
            <td>
                <span>@lang('layout.ToDate')</span>:
                <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
            </td>
        @endif
    </tr>
</table>
<br>
@endif


<table class="main-table">

 <tr class="bg">
  <td class="center">  @lang('layout.Record') </td>
    <th>@lang('layout.Number')</th>
    <th>@lang('layout.CarNumber')</th>
    <th>@lang('layout.Item')</th>
    <th>@lang('layout.Unit')</th>
    <th>@lang('layout.Date')</th>
    <th>@lang('layout.Description')</th>


 </tr>
<?php 
$count = 0;
?>


@foreach($data AS $record)
<tr>
  <td class="center">{{++$count}}</td>
  <td class="center">{{$record['number']}}</td>
  <td class="center">{{$record['vehicle_number']}}</td>
  <td class="center">{{$record['item_name']}}</td>
  <td class="center">{{$record['measure_name']}}</td>
  <td class="center">{{convertDate($record['date'])}}</td>
  <td class="center">{{$record['description']}}</td>
</tr>
@endforeach   

</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->



@endsection