@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i> @lang('layout.JournalInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th class="hidden-xs">
                            <i class="fa fa-bars"></i> @lang('layout.ID')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-bars"></i> @lang('layout.Number')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-comment"></i> @lang('layout.Description')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-user"></i> @lang('layout.Member')  
                        </th>
                        <th>
                            <i class="fa fa-text-width"></i> @lang('layout.Date') 
                        </th>
                        <th>
                            <i class="fa fa-money"></i> @lang('layout.Currency') 
                        </th>
                        <th>
                            <i class="fa fa-money"></i> @lang('layout.Rate') 
                        </th>
                         <th>
                            <i class="fa  fa-money"></i> @lang('layout.TotalDebit')
                        </th>
                         <th>
                            <i class="fa  fa-money"></i> @lang('layout.TotalCredit')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                        <td class="hidden-xs"> {{$info->id}}  </td>
                        <td class="hidden-xs"> {{$info->number}}  </td>
                        <td class="hidden-xs"> {{$info->general_description}}  </td>
                        <td class="hidden-xs"> {{$info->Member}}  </td>
                        <td class="hidden-xs"> {{convertDate($info->Date)}}  </td>
                        <td class="hidden-xs"> {{$info->unit}}  </td>
                        <td class="hidden-xs"> {{$info->rate}}  </td>
                        <td class="hidden-xs"> {{myRound($info->Total_Debit)}}  </td>
                        <td class="hidden-xs"> {{myRound($info->Total_Credit) }}  </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
      <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase"> @lang('layout.JournalDetails') </span>
                    </div>
                    <div class="tools"></div>
                      <div class="actions">
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Jounalentry_details"/>
                           <input type="hidden" name="id" value="{{$info->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="Jounalentry_details"/>
                           <input type="hidden" name="id" value="{{$info->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}}  
                    </div>
                </div> 
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="bill">
                        <thead>
                        <tr>
                            <th>@lang('layout.Account')</th>
                            <th>@lang('layout.Member')</th>
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Debit')</th>
                            <th>@lang('layout.Credit')</th>
                            <th>@lang('layout.Description')</th>
                            @if(systemConfig()[5] != 0 )
                            <th>@lang('layout.Project')</th>
                            @endif
                            @if(systemConfig()[20] == 1)
                            <th>@lang('menu.Contract')</th>
                            @endif


                        </tr>
                        </thead>`
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#bill').DataTable({
           ajax:'{{route("journalEntry.show",$info->id)}}',  
            scrollCollapse: true,
            paging: true,
            serverSide: true,
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
            columns: [    
                { data: 'Account', name: 'Account' },
                { data: 'Member', name: 'Member' },
                { data: 'currency', name: 'currency' },
                { data: 'debit', name: 'debit' },
                { data: 'credit', name: 'credit' },
                { data: 'Description', name: 'Description' },
                @if(systemConfig()[5] != 0 )
                { data: 'project_name', name: 'project.name' },
                @endif

                @if(systemConfig()[20] == 1)
                { data: 'contract_name', name: 'contracts.company_name' },
                @endif

                // 
        ]
        });
    });

</script>

@endpush
