@extends('layouts.app')

@section('content')

    <div id="print-modal">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'journalEntry'" @closed="closeModal">
            <div slot="body">

                                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">

                       <ul class="nav nav-tabs">
                           
                           <li class="active">
                               <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                           </li>
                           @if(systemConfig()[2] != 0 )
                                   @permission(['customreport-list'])
                           <li class="">
                               <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                           </li>
                           @endpermission
                           @endif
                       </ul>
                       <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                   <div class="portlet light bordered">
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" name="from_date"
                                                               autocomplete="off">
                    
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" name="to_date"
                                                               autocomplete="off">
                    
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                   </div>
                           </div> 

                           <div class="tab-pane" id="tab2"> 
                              <div class="portlet light bordered">
                                   <div class="portlet-body">

                                       <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                           @csrf
                                           <input type="hidden" name="part_name" value="journal_entry_index">


                                           <div class="col-md-12 col-sm-12 col-xs-12">

                                               <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                   <div class="form-group">
                                                   <table class="table table-striped table-bordered table-advance table-hover">
                                                               <tr>
                                                                   <td style="text-align: center;">@{{ row.Name }}</td>
                                                               </tr>
                                                               <tr>
                                                                   <td style="text-align: center;">
                                                                       <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                       <label class="switch">
                                                                           <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                           :checked="row.checkedColumn">
                                                                           <span class="slider round"></span>
                                                                       </label>

                                                                       <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                   </td>
                                                               </tr>
                                                           </table>
                                                   </div>
                                               </div>
                                           </div>
                                           <div class="margiv-top-10">
                                               <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                           </div>
                                   </form>
                                   </div>
                           </div>
                   </div>
                   </div>
               </div>
           </div>
           <!----------------------------------------------
           ----Begin Report Body And Custome Report-------
           ----------------------------------------------->
            </div>
        </report-modal>
    </div>

<!-- <div class="row"> -->
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.JournalEntryList')</span>
            </div>
            <div class="tools"> </div> 
            <div class="pull-right">

                @permission('journalEntry-export')

                   <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="anchore-modal-link" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                        </span>
     
                @endpermission
                @permission('journalEntry-create')  
                <a href="{{route('journalEntry.create')}}">
                    <button class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                @endpermission 
            </div>
        </div>
        <div class="portlet-body">
            <div class="row" v-cloak id="company_ll">
                <company @company="setCompany"></company>
            </div>

            <table class="table table-bordered table-hover" id="journalEntry">
                <thead>
                    <tr> 
                       {{-- <th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Date')</th>
						<th>
                            <i class="fa fa-money"></i> @lang('layout.Currency') 
                        </th>
                        <th>
                            <i class="fa fa-money"></i> @lang('layout.Rate') 
                        </th>
                         <th>
                            <i class="fa  fa-money"></i> @lang('layout.TotalDebit')
                        </th>
                         <th>
                            <i class="fa  fa-money"></i> @lang('layout.TotalCredit')
                        </th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead> 
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
<!-- </div> -->

<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->

@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

<script>
var cust_rep = {!!customeReportNewData('journal_entry_index')!!};
    let data_table = null;

    let data = {
        selected: '{!! getCompanyID() !!}'
    };
 $(document).ready(function() {
    $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
     data_table = $('#journalEntry').DataTable( {
        ajax:           '{{route("journalEntry.index")}}',
        pageLength:'{{getPageRows()}}',
        order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
        responsive:'{{responsiveDataTable()}}',
        pagingType:'{{paginationType()}}',
        //scrollY:        450,
        scrollCollapse: true,
        serverSide: true,
        paging:         true,
        columns: [
        /*{ data: 'id', name: 'id' },*/
        { data: 'number', name: 'number' },
        { data: 'Description', name: 'Description' },
        { data: 'Member', name: 'Member' },
        { data: 'Date', name: 'Date' },
        { data: 'unit', name: 'unit' },
        { data: 'rate', name: 'rate' },
        { data: 'Total_Debit', name: 'Total_Debit' },
        { data: 'Total_Credit', name: 'Total_Credit' },
        { data: 'user', name: 'user' },
        { data: 'action', name: 'action', searchable: false, orderable: false }

        ] 
    });
});


 let vmCompany = new Vue({

     el: '#company_ll',
     methods: {
         setCompany: function (event) {
             console.log('company emitted from child',event.company);
             data.selected = event.company;

             if(data_table != null && typeof  data_table=='object')
             {
                 data_table.clear();
                 data_table.ajax.reload();
             }


         }
     }
 });

 var Modal=Vue.component('modal', {
  template: '#modal-template',
  methods: {
    ok: function() {
      this.$emit('ok')
    }
  }
})


     var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                customReportData:
                [
                 {Name: '#', column_name: 'auto_number',checkedColumn:(cust_rep.auto_number)?'checked':'',column_percentage:(cust_rep.auto_number___percent)?cust_rep.auto_number___percent:''},
                 {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
                 {Name: '@lang("layout.Account")', column_name: 'account',checkedColumn:(cust_rep.account)?'checked':'',column_percentage:(cust_rep.account___percent)?cust_rep.account___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Debit")', column_name: 'debit',checkedColumn:(cust_rep.debit)?'checked':'',column_percentage:(cust_rep.debit___percent)?cust_rep.debit___percent:''},
                 {Name: '@lang("layout.Credit")', column_name: 'credit',checkedColumn:(cust_rep.credit)?'checked':'',column_percentage:(cust_rep.credit___percent)?cust_rep.credit___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("menu.Contract")', column_name: 'contract',checkedColumn:(cust_rep.contract)?'checked':'',column_percentage:(cust_rep.contract___percent)?cust_rep.contract___percent:''},

                  ],
                  cust_rep:cust_rep
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

</script>


@endpush
