@extends('layouts.app')
@section('content')
 
@section('style')

    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">

      <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }

        .dashboard-stat2 {
            padding: 2px !important;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        .totals tr td {
            padding: 8px 7px 9px;
        }
        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }
        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;
        }
        .input_style {
            min-width: 110px;
        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }
        .badge{
            height: 33px !important;
            padding: 9px 8px !important;
            font-size: 14px!important;
        }
        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }
        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }
        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
         .totals tr td {
            padding: 4px 7px 9px;
        }

        .dashboard-stat2 {
            padding: 0;
        }


        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }

        th, td {
            text-align: left;
            padding-bottom: 0px;
        }

        tr {
            border-bottom: 1px solid #ddd;
        }

        tr:nth-child(even) {

            background-color: #f2f2f2
        }

        [v-cloak] {
            display: none;
        }

        .row-height {
            height: 55px;
        }

        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }

        .v-autocomplete-list {
            z-index: 1000 !important;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;

        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }




        .dashboard-stat2 {
            padding-bottom: 0;
        }

        .dashboard-tabel td {
            padding: 0 4px;

        }

        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }

        .paddint-both {
            padding: 5px;
        }

        .paddint-both:hover {
            color: red;
        }
      </style>

    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }

        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;

        }
        .input_style {
            min-width: 110px;


        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }

        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }


        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }


        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }



    </style>
@stop
    <div class="row">
       
        <div class="portlet light bg-inverse" style="min-height:100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewJournalEntry')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 35%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'journalEntry.store','method' => 'POST','class' => 'form-horizontal','id'=>'journal-form'])}}
                    <div class="form-body" id="app" v-cloak>
                        <div class="row">
                            <div class="col-lg-9 col-md-9 col-sm-6 col-xs-12">
                                <div class="row" id="header_feilds">
                                    <div class="col-lg-4 col-md-10 col-sm-7 col-xs-12">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">@lang('layout.SelectMember') </label>
                                            <div class="col-md-8">
                                                <v-select class="vue-select2" v-model="selectedMember" label="memberName"
                                                           :options="member" @input="getJournalAccounts($event)">
                                                </v-select>
                                                <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.memberId">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-10 col-sm-7 col-xs-12">
                                        <div class="form-group">
                                            <label class="control-label col-md-3">@lang('layout.Date')</label>
                                            <div class="col-md-8">
                                                <input type="text"  name="date"  class="form-control date" >
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <div class="form-group">
                                            <label class="control-label col-md-4">@lang('layout.Description') </label>
                                            <div class="col-md-8">
                                                {!! Form::textarea('general_description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' =>3, 'cols' =>6)) !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-10">
                                    <div class="dashboard-stat2">
                                        <table class="totals" width="100%">
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.TotalDebit') :</small>
                                                </td>
                                                <td class="text-right"><span data-counter="counterup"
                                                    data-value="8000">@{{totalDebit.toFixed(2)}}</span>
                                                    <small class="font-green-sharp">@{{currencySymbol}}</small>
                                                    <input type="hidden" name="debitTotal" :value="totalDebit">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.TotalCredit') :</small>
                                                </td>
                                                <td class="text-right">
                                                    <span class="text-right" data-counter="counterup"
                                                    data-value="8000">@{{totalCredit.toFixed(2)}}</span>
                                                    <small class="font-green-sharp">@{{currencySymbol}}</small>
                                                    <input type="hidden" name="creditTotal" :value="totalCredit">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
 
                        <div v-if="payments.length >0" class="row">
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 8px;"> # </th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SelectAccount')</th>
                                            <th class="text-center" style="width: 100px;"> @lang('layout.Rate')</th>
                                            <th class="text-center" style="width: 100px;">@lang('layout.Currency')</th>
                                            <th class="text-center" style="width: 80px;">@lang('layout.Type')</th>
                                            <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                                            <th class="text-center">@lang('layout.Debit')</th>
                                            <th class="text-center">@lang('layout.Credit')</th>
                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                            <th style="min-width: 20px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>  
                                    <tr v-for="(payment,Index) in (!selectedMember)?null: payments" class="even">
                                        <td class="td_one"> <span class="badge badge3 badge-success badge-roundless"> @{{Index+1}} </span>
                                        </td>
                                        <td class="td_one">
                                            <v-autocomplete :items="payment.items" v-model="payment.item" :get-label='getLabel'
                                                            :min-len='0'
                                                            :component-item='tpl' v-on:update-items='updatePayment'
                                                            :input-attrs="{}"
                                                            @focus="setPaymentIndex(Index)"
                                                            placeholder="@lang('layout.SelectAccount')">
                                            </v-autocomplete> 
                                            <input type="hidden" name="account_id[]" :value="!payment.item?null:payment.item.id">
                                            <input type="hidden" name="type[]" :value="!payment.item?null:payment.item.type">

                                        </td>

                                        <td>
                                            <input v-bind:disabled="!payment.item?true:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="!payment.item?null:payment.item.rate "
                                                   class="form-control"
                                                   placeholder=" @lang('layout.Rate')" required/>
                                            <input v-if="payment.item" type="hidden" name="rate[]"
                                                   v-bind:value="payment.item.rate">
                                        <td>

                                            <input type="text" name="payment_Currency[]" class="form-control"
                                                   v-model="!payment.item?null:payment.item.code"
                                                   placeholder=" @lang('layout.Currency')" required disabled/>

                                            <input v-if="payment.item" type="hidden" name="payment_currency[]"
                                                   v-bind:value="payment.item.code"/>

                                        </td>
                                        <td>

                                            <input type="text" name="types" class="form-control"
                                                   v-model="!payment.item?null:payment.item.type"
                                                   placeholder=" @lang('layout.Type')" required disabled/>

                                        </td>
                                        <td>

                                            <input type="text" name="types" class="form-control"
                                                   v-model="!payment.item?null:payment.item.balance"
                                                   placeholder="@lang('layout.Balance')" required disabled/>

                                        </td>

                                        <td class="td_one">
                                            <div class="input-group">
                                                <input type="number"  name="debit[]" v-model="!payment.item?null:payment.item.debit" :disabled="!payment.item?true:!!payment.item.credit" class="form-control" placeholder="@lang('layout.Debit')">
                                                <input v-if="!payment.item?null:!!payment.item.credit" type="hidden" name="debit[]" :value="0">
                                                <span class="input-group-addon">
                                                @{{selectedCurrecny}}
                                            </span>
                                            </div>
                                        </td>
                                        <td class="td_one">
                                            <div class="input-group">
                                                <input type="number" name="credit[]"   v-model="!payment.item?null:payment.item.credit"  :disabled="!payment.item?true:!!payment.item.debit"  class="form-control" placeholder="@lang('layout.Credit')">
                                                <input v-if="!payment.item?null:!!payment.item.debit" type="hidden" name="credit[]" :value="0">
                                                <span class="input-group-addon">
                                                 @{{selectedCurrecny}}
                                            </span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="input-group">

                                                {!! Form::text('description[]', null, array('placeholder' =>__('layout.Description'),'class' => 'form-control')) !!}
                                                {{--<span class="input-group-addon">@{{(!payment.item)?null:payment.item.code}}</span>--}}
                                            </div>
                                        </td>
                                       

                                        <td>
                                            <span  v-on:click="deletePayment(Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                        </td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-11 text-center">
                    <div v-show="isError = true">
                      <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('journalEntry.index')}}" class="btn green"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>

                     </div>
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
<script type="text/x-template" id="checkbox-template">

    <div>
        <b>#@{{item.id}}</b>
        <span>@{{ item.name }}</span>
        {{--<span>@{{item.qty }}</span>--}}
        {{--<span>@{{item.description}}</span>--}}
    </div>
</script>

@endsection
@push('scripts')
 
<script src="{{url('/vue/v-autocomplete.js')}}"></script>
<script>

 

    Vue.use(VAutocomplete.default)
 

    var temp = Vue.component('my-checkbox', {
        template: '#checkbox-template',
        props: {
            item: {required: true},
            searchText: {required: true}
        }

    });

     Vue.component('v-select',{
        props : ['selectedItem','selectMember.accounts'],
        template:`<select  class="form-control" v-model="selectedItem">
                        <option disabled value="">@lang('layout.Account')</option>
                            <option v-for="acc in selectMember.accounts"
                                    :value='acc'>@{{acc.name }}
                            </option>
                    </select>`
    });

        Vue.component("v-select", VueSelect.VueSelect);
        var Member    = {!!$member!!}
    var v=new Vue({
        el: '#app',
        data: { 
            selectedAccount:[],
            selectedMember:null,
            member:Member,
            credit:null,
            debit:null,

             rows: [
                {
                    credit:null,
                    debit:null
                },
                {
                  credit:null,
                  debit:null
                },
            ],
            payments: [
               
            ],
            paymentIndex:0,
            tpl: temp,
        },



        computed: {

                  isError: function () {
                    var isError = false

                    if(this.totalDebit == this.totalCredit)
                    {
                        isError=true;
                    }
                    else {
                        return false;
                    }
                },
                   totalDebit: function ()
                    {
                        var sum = 0;
                        for (var i = 0; i < this.payments.length; i++)
                        {
                            if(this.payments[i].item &&  this.payments[i].item.debit)
                            sum += this.payments[i].item.debit/ this.payments[i].item.rate
                        }
                        return sum;
                    },
                    totalCredit: function ()
                    {
                        var sum = 0;
                        for (var i = 0; i < this.payments.length; i++)
                        {
                            if(this.payments[i].item && this.payments[i].item.credit)
                            sum += this.payments[i].item.credit/ this.payments[i].item.rate
                        }
                        return sum;
                    },
                    totalAmount:function()
                    {
                        var value=0;
                        for( var i=0; i<this.rows.length;i++)
                        {
                            if(this.rows[i].debit)
                            {
                                value =parseInt(this.rows[i].debit)/ parseInt((this.selectedAccount)?this.selectedAccount.rate:0);
                            }
                            if(this.rows[i].credit)
                            {
                                value =parseInt(this.rows[i].credit)/ parseInt((this.selectedAccount)?this.selectedAccount.rate:0);
                            }
                        }
                        return value;
                    },
                    selectedCurrecny:function()
                    {
                        return (this.selectedAccount)?this.selectedAccount.currency:null;
                    },
                    currencySymbol:function()
                    {
                        return (this.selectedAccount)?this.selectedAccount.symbol:null;
                    },
                },
        methods: {
                getJournalAccounts(e){
              // console.log('payments',this.payments);
              let member_id=e.memberId
               console.log('ss',member_id);
               console.log('ss',e.memberId);

              if(member_id)
              {
                console.log('ss',member_id);
                axios.get("{{route('callMethod.search')}}",{
                    params:{
                      method_name:'journalAccounts',
                      id:member_id
                    }
                  })
                  .then(function(response){
                    v.payments= [];

                    if(response.data.length >0)
                    {
                        console.log('data',response.data);
                        v.payment=response.data;
                        v.selectedMember.accounts=response.data;
                        v.payments.push( {
                        items: response.data,
                        item: null,

                    });
                    
                    }
                    
                  })
                  .catch(function(error){
                    console.log(error);
                  });
              }

            },
            itemSelected (item) {
                alert('selected');
                console.log('Selected item!', item)
            },
            itemClicked (item) {
                console.log('You clicked an item!', item)
                alert('clicked');
            },
            getLabel (item) {
                if (item) {
                    return item.name
                }
                return ''
            },
            deletePayment(index){
                this.payments.splice(index, 1)
            },
            //       
            updatePayment (text) {
                if(this.selectedMember)
                  {
                    
                       var Animals1 = this.selectedMember.accounts.slice();

                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {

                                if (Animals1.findIndex((item) => item.name == this.payments[i].item.name) != -1)
                                    Animals1.splice(Animals1.findIndex((item) => item.name == this.payments[i].item.name), 1)

                            }
                        }
                  }  
               

                this.payments[this.paymentIndex].items = Animals1.filter((item) => {
                    return (new RegExp(text)).test(item.name)
                })
                if (this.paymentIndex == this.payments.length - 1)
                    this.newPayment()
                if (this.payments[this.paymentIndex].item != null)
                    this.payeds;

            },
            setPaymentIndex(index){
                this.paymentIndex = index;
                this.updatePayment('')
            },
            newPayment(){
                this.payments.push({
                        items: [],
                        item: null,
                    }
                )
            },  
            addrow(index){

                if((this.rows.length-1) == index){
                    this.rows.push({
                          credit:null,
                          debit:null
                        });
                }
            },
            deleteRow: function (index) {
               this.rows.splice(index, 1)
            },
                
        }
    });

</script>


@endpush