@extends('layouts.app')
@section('content')
 
@section('style')

    <link rel="stylesheet" href="{{url('/vue/v-autocomplete.css')}}">

      <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }

        .dashboard-stat2 {
            padding: 2px !important;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        .totals tr td {
            padding: 8px 7px 9px;
        }
        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }
        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;
        }
        .input_style {
            min-width: 110px;
        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }
        .badge{
            height: 33px !important;
            padding: 9px 8px !important;
            font-size: 14px!important;
        }
        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }
        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }
        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }
         .totals tr td {
            padding: 4px 7px 9px;
        }

        .dashboard-stat2 {
            padding: 0;
        }


        table {
            border-collapse: collapse;
            border-spacing: 0;
            width: 100%;
            border: 1px solid #ddd;
        }

        th, td {
            text-align: left;
            padding-bottom: 0px;
        }

        tr {
            border-bottom: 1px solid #ddd;
        }

        tr:nth-child(even) {

            background-color: #f2f2f2
        }

        [v-cloak] {
            display: none;
        }

        .row-height {
            height: 55px;
        }

        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            padding: 5px 15px;
        }

        .v-autocomplete-list {
            z-index: 1000 !important;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;

        }
        .v-autocomplete .v-autocomplete-input-group .v-autocomplete-input {
            height: 22px;
            font-size: 16px;
        }

        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }
        .v-autocomplete .v-autocomplete-list {
            position: absolute;
        }




        .dashboard-stat2 {
            padding-bottom: 0;
        }

        .dashboard-tabel td {
            padding: 0 4px;

        }

        .badge3 {
            ext-align: center;
            width: 100%;
            font-size: 18px !important;
            line-height: 34px;
            height: 34px;
            color: #fff;
            padding: 3px 6px;
        }

        .paddint-both {
            padding: 5px;
        }

        .paddint-both:hover {
            color: red;
        }
      </style>

    <style type="text/css">
        #table_content thead th {
            background-color: rgb(84, 199, 211);
            color: #ffffff;
            font-size: 14px;
        }
        #table_content>tbody>tr.odd>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: rgb(224, 234, 234);
        }

        #table_content>tbody>tr.even>td {
            padding: 0px;
            border: 1px solid #33373a3d;
            background-color: #eceff361;
        }

        #table_content>tbody>tr.even>td.td_one, #table_content>tbody>tr.odd>td.td_one{
            font-size: 14px;
            color: #404040;
            font-weight: bold;

        }
        .input_style {
            min-width: 110px;


        }
        .inner_input {
            min-width: 80px;
            height: 30px;
        }

        td a i {
            color: #686868;
            font-size: 16px;
            margin: 10px;
            vertical-align: middle;
            border: none;
        }


        #table_content tr.even td input:focus,#table_content tr.odd td input:focus {
            outline: 2px solid #191919 !important;
        }
        #table_content>tbody>tr.odd>td>.input-group>.input-group-addon {
            border: none;
            background-color: rgb(197, 200, 208);
        }
        #table_content>tbody>tr.even>td>.input-group>.input-group-addon {
            border: none;
        }
        #table_content tr:nth-child(odd) { background-color:#eee !important; }
        #table_content tr:nth-child(even) { background-color:#fff !important; }


        .inpu-number-fild{
            background-color: white;
            height: 34px;
            border: none;
        }
        #table_content input[type=number], select {
            height: 34px;
            border: none !important;
        }
        .input-has-error {
            outline: 1px solid #ff0000 !important;
            background-color: #ff000014;
        }



    </style>
@stop
    <div class="row">
       
        <div class="portlet light bg-inverse" style="min-height:100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.CreateNewJournalEntry')</span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom: 35%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'journalEntry.store','method' => 'POST','class' => 'form-horizontal','id'=>'journal-form'])}}
                    <div class="form-body" id="app" v-cloak>
                        <div class="row">
                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
							<div class="row">
                                    {{-- <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                            <label class="control-label">@lang('layout.SelectMember') </label>
                                                <v-select class="vue-select2" v-model="selectedMember" label="memberName" :options="member" @input="getJournalAccounts($event)">
                                                </v-select>
                                                <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.memberId">
                                           
                                    </div> --}}
                                    <div class="col-lg-4 col-md-4 col-sm-7 col-xs-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                                <input type="text"  name="date"  class="form-control date" autocomplete="off">
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                        <label class="control-label">@lang('layout.Number')</label>
										<input type="text" name="number" class="form-control"
											   v-validate="'required'" data-vv-as="@lang('layout.Number')" v-model="number">

										<span class="required">@{{ errors.first('number') }}</span>   
									</div>
                                </div>
								<div class="row">	
									<div class="col-lg-8 col-md-8 col-sm-12 col-xs-12" style="padding: 0px;">
										<div :class="pcurrency_len">
											<label class="control-label">@lang('layout.Currency')</label>
											<select class="form-control" v-model="paymentCurrency" style="outline:1px solid #c2cad8 !important"
													v-on:change="setPaymentSize(paymentCurrency.code), getJournalAccountsCurrency(paymentCurrency.code)">
												<option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
											</select>
											<input type="hidden" name="currency"
												   v-bind:value="paymentCurrency.code"/>
										</div>
										<div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
											<label class="control-label">@lang('layout.Rate') </label>
											<div :class="{'has-error':paymentCurrency.exchange_rate < 0}">
												<div class="input-group">
													<input v-model="selected_rate" class="form-control"
														   type="number" min="0" step="any"
														   :readonly="selectedCurrency.code==paymentCurrency.code">
													<span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
												</div>
												<input type="hidden" name="select_rate" :value="selected_rate">
											</div>
										</div>
									</div>
                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label class="control-label">@lang('layout.Description') </label>
                                                {!! Form::textarea('general_description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' =>1, 'cols' =>6)) !!}
                                    </div>
								</div>
                            </div>
                                <div class="col-lg-3 col-md-3 col-sm-3 col-xs-10">
								<div class="row">	
                                    <div class="dashboard-stat2">
                                        <table class="totals" width="100%">
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.TotalDebit') :</small>
                                                </td>
                                                <td class="text-right"><span data-counter="counterup"
                                                    data-value="8000">@{{myRound(totalDebit)}}</span>
                                                    <small class="font-green-sharp">@{{paymentCurrency.symbol}}</small>
                                                    <input type="hidden" name="debitTotal" :value="totalDebit">
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <small>@lang('layout.TotalCredit') :</small>
                                                </td>
                                                <td class="text-right">
                                                    <span class="text-right" data-counter="counterup"
                                                    data-value="8000">@{{myRound(totalCredit)}}</span>
                                                    <small class="font-green-sharp">@{{paymentCurrency.symbol}}</small>
                                                    <input type="hidden" name="creditTotal" :value="totalCredit">
													
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
						<br/>
                        <div v-if="payments.length >0" class="row">
                            <div class="table-responsive333">
                                <table id="table_content" class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th class="text-center" style="min-width: 8px;"> # </th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.Member')</th>
                                            <th class="text-center" style="min-width: 160px;">@lang('layout.SelectAccount')</th>
                                            <!-- th class="text-center" style="width: 100px;"> @lang('layout.Rate')</th -->
                                            <th class="text-center" style="width: 100px;">@lang('layout.Currency')</th>
                                            <th class="text-center" style="min-width: 50px;">@lang('layout.Type')</th>
                                            <th class="text-center" style="min-width: 60px;"> @lang('layout.Amount')</th>
                                            <th class="text-center">@lang('layout.Debit')</th>
                                            <th class="text-center">@lang('layout.Credit')</th>
                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                            @if(systemConfig()[5] != 0 )
                                            <th class="text-center" style="min-width: 120px;">@lang('layout.Project')</th>
                                            @endif
                                            
                                            @if(systemConfig()[20] == 1)
                                            <th class="text-center" style="min-width: 120px;">@lang('menu.Contract')</th>
                                            @endif

                                            <th style="min-width: 20px;"></th>
                                        </tr>
                                    </thead>
                                    <tbody>  
                                    <tr v-for="(payment,Index) in payments" class="even">
                                        <td class="td_one"> <span class="badge badge3 badge-roundless" style="background: transparent !important; color: #191919;"> @{{Index+1}} </span>
                                        </td>
                                        <td class="highlight" style="vertical-align: middle;">
                                            <v-select label="name" v-model="payment.member" :options="temp_member_list" @search="MemberSearchRow"  @input="getJournalAccounts(Index)"
                                            @click.native="newPayment(Index)" placeholder="@lang('layout.Select')">
                                            </v-select>
                                            <input type="hidden" name="row_member_id[]" :value="(payment.member==null)?null:payment.member.id">
                                        </td>
                                        <td class="td_one">
											 <v-select class="vue-select2" v-model="payment.item" label="name"
                                                           :options="payment.items" :min-len='0'
                                                            :component-item='tpl' v-on:update-items='updatePayment'
                                                            @focus="setPaymentIndex(Index)"
                                                            @click.native="newPayment(Index)"
                                                            placeholder="@lang('layout.SelectAccount')" >
                                             </v-select>
											
                                            <input type="hidden" :name="'account_id['+Index+']'" :value="!payment.item?null:payment.item.id">
                                            <input type="hidden" :name="'type['+Index+']'" :value="!payment.item?null:payment.item.type">

                                        </td>
                                        <!-- td>
                                            <input v-bind:disabled="!payment.item?true:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="!payment.item?null:payment.item.rate "
                                                   class="form-control"
                                                   placeholder=" @lang('layout.Rate')" required/>
                                            <input v-if="payment.item" type="hidden" name="rate[]"
                                                   v-bind:value="payment.item.rate">
                                       </td -->
									   <td>

                                            <input type="text" :name="'payment_Currency['+Index+']'" class="form-control"
                                                   v-model="!payment.item?null:payment.item.code"
                                                   placeholder=" @lang('layout.Currency')" required disabled/>

                                            <input v-if="payment.item" type="hidden" :name="'payment_currency['+Index+']'"
                                                   v-bind:value="payment.item.code"/>

                                        </td>
                                        <td>

                                            <input type="text" :name="'types['+Index+']'" class="form-control"
                                                   v-model="!payment.item?null:payment.item.type"
                                                   placeholder=" @lang('layout.Type')" required disabled/>

                                        </td>
                                        <td>

                                            <input type="text" :name="'types['+Index+']'" class="form-control"
                                                   v-model="!payment.item?null:payment.item.balance"
                                                   placeholder="@lang('layout.Balance')" required disabled/>

                                        </td>

                                        <td class="td_one">
                                            <div class="input-group">
                                                <vue-numeric v-if="payment.item"
                                                    class="form-control"
                                                    :readonly="!payment.item?true:!!payment.item.credit"
                                                    v-model="payment.item.debit"
                                                    :max="99999999999999"
                                                    currency=""
                                                    :precision="precision()"
                                                    placeholder="@lang('layout.Debit')"
                                                    >
                                                </vue-numeric>
                                                <input type="hidden" :name="'debit['+Index+']'" v-model="!payment.item?null:payment.item.debit" class="form-control" placeholder="@lang('layout.Debit')">
                                                <input v-if="!payment.item?null:!!payment.item.credit" type="hidden" :name="'debit['+Index+']'" :value="0">
                                                <span class="input-group-addon">
                                                @{{paymentCurrency.symbol}}
                                            </span>
                                            </div>
                                        </td>
                                        <td class="td_one">
                                            <div class="input-group">
                                                <vue-numeric v-if="payment.item"
                                                    class="form-control"
                                                    :readonly="!payment.item?true:!!payment.item.debit"
                                                    v-model="payment.item.credit"
                                                    :max="99999999999999"
                                                    currency=""
                                                    :precision="precision()"
                                                    placeholder="@lang('layout.Credit')"
                                                    >
                                                </vue-numeric>
                                                <input type="hidden" :name="'credit['+Index+']'" v-model="!payment.item?null:payment.item.credit"   class="form-control" placeholder="@lang('layout.Credit')">
                                                <input v-if="!payment.item?null:!!payment.item.debit" type="hidden" :name="'credit['+Index+']'" :value="0">
                                                <span class="input-group-addon">
                                                    @{{paymentCurrency.symbol}}
                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="">

                                                {!! Form::text('description[]', null, array('placeholder' =>__('layout.Description'),'class' => 'form-control')) !!}
                                            </div>
                                        </td>
                                       

                                        @if(systemConfig()[5] != 0 )
                                        <td>
                                        <v-select class="vue-select2" label="name" @search="ProjectSearch"
                                                :options="project_list" v-model="!payment.item?null:payment.item.selectedProject">
                                        </v-select>
                                        <input type="hidden" :name="'project_id['+Index+']'" v-model.number="(!payment.item)?null:(!payment.item.selectedProject)?null:payment.item.selectedProject.project_id">
                                        
                                        </td>
                                        @endif
                                        
                                        
                                        @if(systemConfig()[20] == 1)
                                        <td>
                                        <v-select class="vue-select2" label="company_name" @search="searchContracts"
                                                :options="contract_list" v-model="!payment.item?null:payment.item.selectedContract">
                                        </v-select>
                                        <input type="hidden" :name="'contract_id['+Index+']'" v-model.number="(!payment.item)?null:(!payment.item.selectedContract)?null:payment.item.selectedContract.id">
                                        
                                        </td>
                                        @endif
                                        <td>
                                            <span  v-on:click="deletePayment(Index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                        </td>
                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
						
						<div class="col-xs-12 col-sm-12 col-md-11 text-center" style="margin-top: 10px;">
                            <div>
                            <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>
                            <button type="button" class="btn blue" @click="saveAndNew($event)" >@lang('layout.SaveAndNew')</button>
                            <a href="{{route('journalEntry.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                            </div>

                     </div>

                    </div>
                    
                {!! Form::close() !!}
            </div>
            <!-- END FORM-->
        </div>
    </div>
<script type="text/x-template" id="checkbox-template">

    <div>
        <b>#@{{item.id}}</b>
        <span>@{{ item.name }}</span>
        {{--<span>@{{item.qty }}</span>--}}
        {{--<span>@{{item.description}}</span>--}}
    </div>
</script>

@endsection
@push('scripts')
 
<script src="{{url('/vue/v-autocomplete.js')}}"></script>
<script>

    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.use(VAutocomplete.default)
    Vue.use(VueNumeric.default)
 
    var temp = Vue.component('my-checkbox', {
        template: '#checkbox-template',
        props: {
            item: {required: true},
            searchText: {required: true}
        }
    });

     Vue.component('v-select',{
        props : ['selectedItem','selectMember.accounts'],
 template:`<select  class="form-control" v-model="selectedItem"><option disabled value="">@lang('layout.Account')</option><option v-for="acc in selectMember.accounts":value='acc'>@{{acc.name }}</option></select>`
    });

        Vue.component("v-select", VueSelect.VueSelect);
		var Currency  = {!! $currency!!}
        var two ={!!json_encode(getHomeCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";
    var v = new Vue({
        el: '#app',
        data: { 
			selectedCurrency: two,
			selectedCurrencyTemp: null,
			paymentCurrency: two,
			selectedCurrency2: null,
			currency:{!! json_encode(getCurrencies()) !!},
			currency1:{!! json_encode(getCurrencies()) !!},
			currency_len: 'col-md-12',
			rate_len: 'col-md-0',
			pcurrency_len: 'col-md-12',
			prate_len: 'col-md-0',
			selected_rate: two['exchange_rate'],
            code: code,
            totalCredit1:0,
            totalDebit1:0,
			number: "{{$number}}",
            selectedAccount:[],
            selectedProject: null,
            project_list: [],
            items:[],
            selectedMember:null,
            member:[],
            temp_member_list:[],
            credit:null,
            debit:null,

             rows: [
                {
                    credit:null,
                    debit:null
                },
                {
                  credit:null,
                  debit:null
                },
            ],
            payments: [
               
            ],
            paymentIndex:0,
            tpl: temp,
            contract_list:[]
        },


        mounted:function(){
			
			axios.get("{{route('callMethod.search')}}",{
                    params:{
                      method_name:'journalAccounts',
                      currency:this.paymentCurrency.code,
                      homeCurrency:this.code,
                      id:null
                    }
                  })
                  .then(function(response){
                    v.payments= [];

                    if(response.data.length >0)
                    {
                        // console.log('data',response.data);
                        v.payment=response.data;
                        v.items=response.data;
                        v.payments.push( {
                        items: response.data,
                        item: null,
                        member: null,

                    });
                    
                    }
					
                    // console.log('nee',this.payments);
                    
                  })
                  .catch(function(error){
                    console.log(error);
                  });
				  
				  
		},

        computed: {

                
                   totalDebit: function ()
                    {
                        var sum = 0;
                        for (var i = 0; i < this.payments.length; i++)
                        {
                            if(this.payments[i].item &&  this.payments[i].item.debit)
                            // sum += ((this.payments[i].item.debit/ this.payments[i].item.rate) * this.selected_rate)
                            sum += Number.parseFloat(this.payments[i].item.debit);
                        }
						
						this.totalDebit1 = sum;
                        return sum;
                    },
                    totalCredit: function ()
                    {
                        var sum = 0;
                        for (var i = 0; i < this.payments.length; i++)
                        {
                            if(this.payments[i].item && this.payments[i].item.credit)
                            // sum += ((this.payments[i].item.credit/ this.payments[i].item.rate) * this.selected_rate)
                            sum += Number.parseFloat(this.payments[i].item.credit)
                        }
						
						this.totalCredit1 = sum;
                        return sum;
                    },
                    totalAmount:function()
                    {
                        var value=0;
                        for( var i=0; i<this.rows.length;i++)
                        {
                            if(this.rows[i].debit)
                            {
                                value =parseInt(this.rows[i].debit)/ parseInt((this.selectedAccount)?this.selectedAccount.rate:0);
                            }
                            if(this.rows[i].credit)
                            {
                                value =parseInt(this.rows[i].credit)/ parseInt((this.selectedAccount)?this.selectedAccount.rate:0);
                            }
                        }
                        return value;
                    },
                    selectedCurrecny:function()
                    {
                        return (this.selectedAccount)?this.selectedAccount.currency:null;
                    },
                    currencySymbol:function()
                    {
                        return (this.selectedAccount)?this.selectedAccount.symbol:null;
                    },
                },
        methods: {
            MemberSearchRow: _.debounce((search, loading) => {
                loading(true);
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.temp_member_list = [];
                        v.temp_member_list = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

                getJournalAccounts(index){
                    if (this.payments[index].member != null){
                    
                        let member_id= this.payments[index].member.id;	
                        if(member_id){

                        // console.log('ss',member_id , v.paymentCurrency.code, this.code);
                        axios.get("{{route('callMethod.search')}}",{
                            params:{
                            method_name:'journalAccounts',
                            currency:v.paymentCurrency.code,
                            homeCurrency:this.code,
                            id:member_id
                            }
                        })
                        .then(function(response){

                            if(response.data.length >0)
                            {
                                // v.payments= [];
                                // console.log('data',response.data);
                                v.payments[index].items=response.data;
                                // v.selectedMember.accounts=response.data;
                                // v.payments.push( {
                                // items: response.data,
                                // item: null,
                                // member: null,

                                // });
                            
                            }
                            
                        })
                        .catch(function(error){
                            console.log(error);
                        });
                        }
                    }
                },                
			getJournalAccountsCurrency(currency){
				if(currency){
                if(this.selectedMember){
				var member_id = this.selectedMember.memberId;
                }else{
                var member_id = null;
                }
                axios.get("{{route('callMethod.search')}}",{
                    params:{
                      method_name:'journalAccounts',
                      currency:currency,
                      homeCurrency:this.code,
                      id:member_id
                    }
                  })
                  .then(function(response){

                    if(response.data.length >0)
                    {
						v.payments= [];
                        // console.log('data',response.data);
                        v.payment=response.data;
						if(member_id){
							v.selectedMember.accounts=response.data;
						}
                        v.payments.push( {
                        items: response.data,
                        item: null,
                        member: null,

                    });
                    
                    }
                    
                  })
                  .catch(function(error){
                    console.log(error);
                  });
				}
            },

            // Search Project
            ProjectSearch:_.debounce((search,loading)=>{
                v.project_list=[];
                loading(true);
                axios.get("{{route('callMethod.search')}}",{
                params:{
                    method_name:'serarchProject',
                    keyword:search,
                }
                })
                .then(function (response)
                {
                    this.project_list=[];
                    if(response.data.length>0)
                    {
                    v.project_list=response.data;
                    // console.log('test 22',v.project_list);
                    }
                    loading(false);
                })
                .catch(function (error)
                {
                    console.log(error);
                });
            },getDebounceTime()),

            // Search Contract
            searchContracts(search, loading) {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'anyTable',
                        keyword: search,
                        table_name: 'contracts',
                        search_column:'company_name'
                    }
                })
                .then(function (response) {
                    v.contract_list = [];
                    if (response.data.length > 0) {
                        v.contract_list = response.data;
                    }
                    loading(false);
                })
                .catch(function (error) {
                    console.log(error);
                })
            },


            itemSelected (item) {
                alert('selected');
                console.log('Selected item!', item)
            },
            itemClicked (item) {
                console.log('You clicked an item!', item)
                alert('clicked');
            },
            getLabel (item) {
                if (item) {
                    return item.name
                }
                return ''
            },
            deletePayment(index){
                this.payments.splice(index, 1)
            },
            //       
            updatePayment (text) {
                if(this.selectedMember)
                  {
                    
                       var Animals1 = this.selectedMember.accounts.slice();

                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {

                                if (Animals1.findIndex((item) => item.name == this.payments[i].item.name) != -1)
                                    Animals1.splice(Animals1.findIndex((item) => item.name == this.payments[i].item.name), 1)

                            }
                        }
                  
                this.payments[this.paymentIndex].items = Animals1.filter((item) => {
                    return (new RegExp(text)).test(item.name)
                })
                if (this.paymentIndex == this.payments.length - 1)
                    this.newPayment()
                if (this.payments[this.paymentIndex].item != null)
                    this.payeds;
				  }else{
					if(v.payments.length == 0){
						v.payments.push( {
							items: v.payment,
							item: null,
							member: null,

						});
					}else if(this.paymentIndex == this.payments.length - 1){
						v.payments.push( {
							items: v.payment,
							item: null,
							member: null,

						});
					}
				  }

            },
            setPaymentIndex(index){
                this.paymentIndex = index;
                this.updatePayment('')
            },
            newPayment(index){
				if (this.payments[index + 1] == undefined) {
                        this.payments.push({
                        items: v.payment,
                        item: null,
                        member: null,
                    })
                }
            },  
            addrow(index){

                if((this.rows.length-1) == index){
                    this.rows.push({
                          credit:null,
                          debit:null
                        });
                }
            },
            deleteRow: function (index) {
               this.rows.splice(index, 1)
            },
			
			
			setPaymentSize(selected_code) {
                    this.selected_rate = this.paymentCurrency.exchange_rate;

                    if (selected_code == this.code) {
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
			handleSubmit(e) {
                    this.$validator.validate().then(valid => {
                        if (valid) {
                            // alert(e.target);
							
							if(this.totalDebit1 == this.totalCredit1 && this.totalDebit1 > 0 && this.totalCredit1 > 0)
							{	
								var currencyCheck = false;
								for (var i = 0; i < this.payments.length; i++)
									{
										if(this.payments[i].item){
										if(this.payments[i].item.code == this.code || this.payments[i].item.code == this.paymentCurrency.code){
								        currencyCheck = true;
										}
										}
										
								// console.log('ss',this.payments[i].item.code, this.payments[i].item.rate );
									}
								// console.log('ss',this.code, this.paymentCurrency.code, this.paymentCurrency.exchange_rate);
								
								if(currencyCheck){
								regForm(e.target);
								}else{
								alert('change currency');	
								}
							}
                        }
                    });
                },
                saveAndNew()
                {
                    this.$validator.validate()
                    .then(valid =>{
                        if(valid)
                        {
                            if(this.totalDebit1 == this.totalCredit1 && this.totalDebit1 > 0 && this.totalCredit1 > 0)
							{	
								var currencyCheck = false;
								for (var i = 0; i < this.payments.length; i++)
									{
										if(this.payments[i].item){
										if(this.payments[i].item.code == this.code || this.payments[i].item.code == this.paymentCurrency.code){
								        currencyCheck = true;
										}
										}
									}
                                if (currencyCheck) {   
                                    var url="{{route('journalEntry.store')}}";
                                    form_id='journal-form';
                                    var data= $('#'+form_id).serialize();
                                    // console.log(444, data);
                                    toggleBlock(true);
                                    axios.post(url,data)
                                    .then(function(response){
                                            toggleBlock(0);
                                            if(response.data.result==1)
                                            {
                                                $('#'+form_id).trigger('reset');
                                                
                                                toastr.success('',response.data.message); 
                                                location.reload();
                                            
                                            }
                                            else
                                            {
                                                var message="{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                toastr.warning('',message);
                                            }
                                    })
                                    .catch(function(error){
                                    toggleBlock(0);
                                        console.log(error);
                                        var message="{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('',message);
                                    });
                            
                               }
                            }
                        }
                    })
                },
                
        }
    });

</script>


@endpush