@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('journal_entry_index');
$_auto_number=!in_array('auto_number', $report);
$_number=!in_array('number', $report);
$_date=!in_array('date', $report);
$_description=!in_array('description', $report);
$_member=!in_array('member', $report);
$_account=!in_array('account', $report);
$_currency=!in_array('currency', $report);
$_debit=!in_array('debit', $report);
$_credit=!in_array('credit', $report);
$_user=!in_array('user', $report);
$_contract=!in_array('contract', $report);




$report_percent = customeReportNewPercent('journal_entry_index');
    $_auto_number_percent= (array_key_exists('auto_number___percent', $report_percent))?$report_percent['auto_number___percent']:null;
    $_number_percent= (array_key_exists('number___percent', $report_percent))?$report_percent['number___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_member_percent= (array_key_exists('member___percent', $report_percent))?$report_percent['member___percent']:null;
    $_account_percent= (array_key_exists('account___percent', $report_percent))?$report_percent['account___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_debit_percent= (array_key_exists('debit___percent', $report_percent))?$report_percent['debit___percent']:null;
    $_credit_number_percent= (array_key_exists('credit_number___percent', $report_percent))?$report_percent['credit_number___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_contract_percent= (array_key_exists('contract___percent', $report_percent))?$report_percent['contract___percent']:null;
  
?>



<h3 class="table-caption" style="text-align: center;">@lang('layout.JournalEntryReport')</h3>
@if($from_date || $to_date)
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif   {{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif   {{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
<br>
@endif
  <table class="main-table">

 <thead>
    <tr class="bg">
   @if($_auto_number)<td class="center" @if($_auto_number_percent) width="{{$_auto_number_percent}}%" @endif> @lang('layout.Record') </td>@endif
   @if($_number)<td class="center" @if($_number_percent) width="{{$_number_percent}}%" @endif> @lang('layout.Number')</td>@endif
   @if($_date)<td class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif> @lang('layout.Date')</td>@endif
   @if($_description)<td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif> @lang('layout.Description')</td>@endif
   @if($_member)<td class="center" @if($_member_percent) width="{{$_member_percent}}%" @endif> @lang('layout.Member')</td>@endif
   @if($_account)<td class="center" @if($_account_percent) width="{{$_account_percent}}%" @endif> @lang('layout.Account')</td>@endif
   @if($_currency)<td class="center" @if($_currency_percent) width="{{$_currency_percent}}%" @endif> @lang('layout.Currency')</td>@endif
   @if($_debit)<td class="center" @if($_debit_percent) width="{{$_debit_percent}}%" @endif> @lang('layout.Debit')</td>@endif
   @if($_credit)<td class="center" @if($_credit_number_percent) width="{{$_credit_number_percent}}%" @endif> @lang('layout.Credit')</td>@endif

   @if(systemConfig()[20] == 1)
   @if($_contract)<td class="center" @if($_contract_percent) width="{{$_contract_percent}}%" @endif> @lang('menu.Contract')</td>@endif
   @endif

   @if($_user)<td class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif> @lang('layout.User')</td>@endif

 </tr>
 </thead>
 <?php
 $count = 0;
 ?>
 @foreach($data AS $record)
 <tr>
 @if($_auto_number)<td class="center">{{++$count}}</td>@endif
 @if($_number)<td  class="center">{{$record->number}}</td>@endif
 @if($_date)<td  class="center">{{convertDate($record->Date)}}</td>@endif
 @if($_description)<td style="@if($_description_percent) text-align: justify; @endif"  class="center">{{$record->Description}}</td>@endif
 @if($_member)<td  style="text-align: justify">{{$record->Member}}</td>@endif
 @if($_account)<td  class="center">{{$record->Account}}</td>@endif
 @if($_currency)<td  class="center">{{$record->unit}}</td>@endif
 @if($_debit)<td  class="center">{{myRound($record->Debit)}}</td>@endif
 @if($_credit)<td  class="center">{{myRound($record->Credit)}}</td>@endif

 @if(systemConfig()[20] == 1)
 @if($_contract)<td  class="center">{{$record->contract_name}}</td>@endif
 @endif

 @if($_user)<td  style="text-align: center">{{$record->user}}</td>@endif
</tr>
  @endforeach   
</table>


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection