@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->

    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.JobTitleList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">

                    @permission('jobTitle-create')
                    <a href="{{route('jobTitle.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="inventorySite">
                    <thead>
                    <tr>
                       {{-- <th>#</th>--}}
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.CreatedAt')</th>
                        <th>@lang('layout.UpdatedAt')</th>
                        <th>@lang('layout.Action')</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop

@push('scripts')

    <script>

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#inventorySite').DataTable({
                ajax: '{{route("jobTitle.index")}}',
                pageLength: '{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                  /*  {data: 'id', name: 'id'},*/
                    {data: 'number', name: 'number'},
                    {data: 'name', name: 'name'},
                    {data: 'description', name: 'description'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'updated_at', name: 'updated_at'},
                    {data: 'action', searchable: false, orderable: false}
                ]
            });
        });
    </script>


@endpush
