@extends('layouts.app')
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.15/css/dataTables.bootstrap.min.css">
@section('content')
<!-- BEGIN CONTENT -->
<!-- BEGIN PAGE BAR -->
{{--<div class="page-bar">--}}
    {{--<ul class="page-breadcrumb">--}}
        {{--<li>--}}
            {{--<a href="index.html">Home</a>--}}
            {{--<i class="fa fa-circle"></i>--}}
        {{--</li>--}}
        {{--<li>--}}
            {{--<a href="#">Tables</a>--}}
            {{--<i class="fa fa-circle"></i>--}}
        {{--</li>--}}
        {{--<li>--}}
            {{--<span>Datatables</span>--}}
        {{--</li>--}}
    {{--</ul>--}}
   {{----}}
{{--</div>--}}
<!-- END PAGE BAR -->


<!-- END PAGE HEADER-->
@if (Session('message'))
    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>
        <p >{{ Session('message') }}</p>
    </div>
    {{--<div class="alert alert-success ">--}}
        {{--<ul>--}}
            {{--<li >{{ Session('message') }}</li>--}}
        {{--</ul>--}}
    {{--</div>--}}
@endif
@if (count($errors) > 0)

    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>

    {{--</div>--}}
    {{--<div class="alert alert-danger">--}}
        {{--<ul>--}}
            @foreach ($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        {{--</ul>--}}
    </div>

@endif
<!-- BEGIN TAB PORTLET-->


<div class="row">

    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">Items Inventory list</span>
            </div>
            <div class="tools"> </div>
            <div class="btn-group pull-right">

                <a href="{{route('item.create')}}">
                    <button id="sample_editable_1_new" class="btn green btn-sm btn-outline">
                        <i class="fa fa-plus"></i> Add New
                    </button></a>
            </div>
        </div>
        <div class="portlet-body">
            <table class="table table-striped table-bordered table-hover" id="inventory">
                <thead>
                <tr>
                    <th>Code</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Precent</th>
                    <th>Measure</th>
                    <th>Quantities</th>
                </tr>
                </thead>
                <tfoot>
                <tr>
                    <th>Code</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Precent</th>
                    <th>Measure</th>
                    <th>Quantities</th>
                </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>


<!-- END TAB PORTLET-->

<!-- END CONTENT BODY -->


@stop

@push('scripts')

<script>

    $(document).ready(function() {


        $('#inventory').DataTable( {
            ajax:           '{{route("inventory.index")}}',
            scrollY:        450,
            scrollCollapse: true,
            paging:         true,
            columns: [
            { data: 'id', name: 'id' },
            { data: 'name', name: 'name' },
            { data: 'description', name: 'description' },
            { data: 'percent', name: 'percent' },
            { data: 'measure', name: 'measure' },
            { data: 'qut', name: 'account' },
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


            ]


    } );


    } );
</script>


@endpush
