@extends('layouts.app')

@section('content')
    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemPayrollTypeList')</span>
                </div>
                <div class="tools">

                </div>
                <div class="btn-group pull-right">
                    <div id="measure">

                        @permission('itemTypePayroll-create')
                        <a href="{{route('item.type.payroll.create')}}" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </a>
                        @endpermission

                    </div>
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="itemTypePayroll">
                    <thead>
                    <tr>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

@stop
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#itemTypePayroll').DataTable({
                ajax: '{{route("item.type.payroll.index")}}',
                paging: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                server: true,
                serverSide: true,
                columns: [
                    {data: 'name', name: 'item_type_payrolls.name'},
                    {data: 'type', name: 'item_type_payrolls.type'},
                    {data: 'account_name', name: 'account_name', orderable: false, searchable: false},
                    {data: 'description', name: 'item_type_payrolls.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });

        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
    </script>
@endpush
