@extends('layouts.app')
@section('content')
<div class="row">
    @if (count($errors) > 0)
    <div class="m-heading-1 border-red m-bordered errors-action">
        <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
        <ul class="error-body">
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif
    <div class="portlet light bg-inverse" style="min-height: 100%;">
        <div class="portlet-title">
            <div class="caption">
                <i class="icon-equalizer font-green-haze"></i>&nbsp;
                <span class="caption-subject font-green-haze bold uppercase">@lang('layout.ItemPayrollType') </span>
                <!-- <span class="caption-helper">some info...</span> -->
            </div>
            <div class="tools">

            </div>
        </div>
        <div class="portlet-body form" id="app" style="margin-bottom: 30%;">
            {{Form::open(['route' => ['item.type.payroll.update',$ac->id],'method' => 'PATCH'])}}
            <div class="form-body">
                <div id="app" v-cloak>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name">@lang('layout.Name')</label>
                                <input type="text" placeholder="@lang('layout.Name')" name="name"
                                       class="form-control" value="{{$ac->name}}" required>
                            </div>
                        </div>
                    </div>

                    <hr>

                    <div class="row">
                        <div class="col-lg-6 col-sm-12">
                            <label for="payroll-type" class="form-label">@lang('layout.SelectPayrollType')</label>
                            <select name="payrollType" id="payroll-type" v-model="payrollTypeSelect"
                                    class="form-control">
                                <option>@lang('layout.Select')</option>
                                <option v-for="payroll in payrollType" :value="payroll.tag"> @{{ payroll.name }}
                                </option>
                            </select>
                        </div>

                        <div class="col-md-6 div col-sm-12"  v-if="payrollTypeSelect == 'EmployeeOtherCharge' || payrollTypeSelect == 'CompanyOtherCharge'">
                            <div class="form-group">
                                <label for="account">@lang('layout.Select')</label>
                                <select name="account" class="form-control" id="account" v-model="account_id">
                                    <option >@lang('layout.Select')</option>
                                    <template v-if="payrollTypeSelect == 'EmployeeOtherCharge'">
                                        <option v-for="account in  employeeOtherCharge" :value="account.id"> @{{
                                            account.name }}
                                        </option>
                                    </template>

                                    <template v-else>
                                        <option v-for="account in companyOtherCharge" :value="account.id">@{{
                                            account.name }}
                                        </option>
                                    </template>
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <label for="description" class="form-label">@lang('layout.Description')</label>
                            <textarea cols="30" rows="5" name="description" class="form-control">{{ $ac->description }}</textarea>
                        </div>
                    </div>
                </div>
                <!--/row-->
            </div>
            <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                <button type="button" @click="handleSubmit($event)" class="btn green">@lang('layout.Submit')</button>

                <a href="{{route('item.type.payroll.index')}}" class="btn default">
                    <i class="fa fa-mail-reply"></i> @lang('layout.Cancel')
                </a>
            </div>
            {{Form::close()}}
        </div>
        <!-- END FORM-->
    </div>
</div>
@endsection
@push('scripts')

<script>
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    ////
    Vue.component("v-select", VueSelect.VueSelect);

    let accounts = {!! $accounts !!};



    var app = new Vue({
        el: '#app',
        data: {
            payrollType: [
                {tag: 'Simple', name: "@lang('layout.Simple')"},
                {tag: 'EmployeeOtherCharge', name: "@lang('layout.EmployeeOtherCharge')"},
                {tag: 'CompanyOtherCharge', name: "@lang('layout.CompanyOtherCharge')"}
            ],
            payrollTypeSelect: '{!! $ac->type !!}',
            account_id: '{!! $ac->account_id!!}',
        },

        computed: {
            employeeOtherCharge() {
                return accounts.filter((account) => {
                    return (account.type == 'expense' || account.type == 'costOfGoodSold')
                })
            },

            companyOtherCharge() {
                return accounts.filter((account) => {
                    return (account.type == 'income') || (account.type == 'otherIncome')
                });
            },

        },
        methods: {

            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        regForm(e.target);
                    }
                });
            },
        }
    });
</script>
@endpush