@extends('layouts.app')
@section('content')
    <!-- END PAGE HEADER-->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'itemNoneCostCode'" @closed="closeModal">
            <div slot="body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.Category')</label>  
                            <v-select label="name" :options="category" v-model="selected_category"></v-select>
                            <input type="hidden" name="category_id" :value="(!selected_category)?null:selected_category.id">
                        </div>
                    </div>
                      <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">@lang('layout.Type')</label>
                            <select class="form-control" name="report_type">
                                <option value="">@lang('layout.Select')</option>
                                <option value="summary">@lang('layout.Summary')</option>
                                <option value="details">@lang('layout.Details')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>
    <!-- BEGIN TAB PORTLET-->
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.ItemNoneCostList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    @permission('itemNoneCost-export')
                    <span id="anchore-modal">
                             <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                <i class="fa fa-print"></i>
                             </a>
                        </span>
                    @endpermission
                    @permission('itemNoneCost-create')
                    <a href="{{route('itemNoneCostCode.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template  v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered " cellspacing="0" id="itemNoneCost">
                    <thead>
                        <tr>
                            <th>@lang('layout.ID')</th>
                            <th>@lang('layout.ReferenceNumber')</th>
                            <th>@lang('layout.Category')</th>
                            <th>@lang('layout.Date')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.User')</th>
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- <div id="factor-obj" >
        @if (Session('message'))
        <object  data="{{url('factor22.pdf')}}" type="application/pdf" width="0" height="0"> </object>
        @endif
            </div> -->
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        function factorPrint(id) {
            $.ajax({
                // This PHP file will generate the PDF and save it to your server
                // $pdf->Output('path/to/pdf/file.pdf', 'F');
                url: "{{url('/')}}/salePrint/" + id,
                type: 'get',
                cache: false,
            }).done(function () {
                var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
                $('#factor-obj').html(s);
                // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            })
                .fail(function () {
                    console.log("error");
                });


        }

        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table = $('#itemNoneCost').DataTable({
                ajax: '{{route("itemNoneCostCode.index")}}',
                order: [["{{orderByColumn()=='number'?0:2}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'id', name: 'item_none_costs.id'},
                    {data: 'ref_no', name: 'item_none_costs.ref_no'},
                    {data: 'category', name: 'category',orderable:false,searchable:false},
                    {data: 'date', name: 'date',orderable:false,searchable:false},
                    {data: 'description', name: 'item_none_costs.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions',orderable:false,searchable:false}

                ]
            });


        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if(typeof data_table =='object'){
                        data_table.clear();
                        data_table.ajax.reload();
                    }

                }
            }
        });

        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                category:{!! $category !!},
                selected_category:null
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                }
            }
        });

        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });


        Vue.component('v-select', VueSelect.VueSelect)

    </script>


@endpush
