@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>

    </style>
@stop
@section('content')

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditItemNoneCost') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">

                </div>
            </div>


            <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- begin sale order modal -->


                {{Form::model($itemNoneCost,['route' => ['itemNoneCostCode.update',$itemNoneCost->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'itemNoneCost-form','files'=> true])}}
                {{ csrf_field() }}

                <div class="form-body">
                    <input type="hidden" name="edit_sale" value="{{$edit_sale}}">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <p style="color: red">@lang('layout.Note'): @lang('layout.AdjustmentNote')</p>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            <input type="text" name="ref_no" value="{{$itemNoneCost->ref_no}}"
                                                   class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            <input type="text" name="date" value="{{$itemNoneCost->date}}"
                                                   class="form-control date">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" v-model="selected_account"
                                                      :options="accounts"></v-select>
                                            <input type="hidden" name="account_id"
                                                   :value="(selected_account)?selected_account.id:null">
                                        </div>
                                    </div>
                                </div>


                            </div>
                            <div class="row">


                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <v-select label="name" :options="adjustmentCategory" v-model="selected_adjustment_category"></v-select>
                                            <input type="hidden" name="category_id" :value="(!selected_adjustment_category)?null:selected_adjustment_category.id">
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-8 col-md-9 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            <textarea name="description" class="form-control"
                                                      rows="3">{{$itemNoneCost->description}}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal.toFixed(precision())))}}</span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>


                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                        <tr>
                            <th>#</th>
                            <th v-show="showWhat('sale_category')=='yes'" style="min-width: 100px">@lang('layout.Category') </th>
                            <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                            <th style="min-width: 100px">@lang('layout.SiteName') </th>
                            <th style="min-width: 50px">@lang('layout.Code') </th>
                            <th v-show="showWhat('expire_date')=='yes'">@lang('layout.ExpireDate') </th>
                            <th style="min-width: 50px">@lang('layout.Quantity') </th>
                            <th style="min-width: 50px">@lang('layout.OnHand') </th>
                            <th v-show="showWhat('other_measure')=='yes'" class="other_measure" style="min-width: 50px">@lang('layout.OMeasureValue1')</th>
                            <th v-show="showWhat('other_measure2')=='yes'" class="other_measure" style="min-width: 50px">@lang('layout.OMeasureValue2')</th>
                            <th style="min-width: 100px">@lang('layout.Measure') </th>
                            @if(itemBrand()=="true")
                            <th style="min-width: 50px;">@lang('layout.Brand')</th>
                            @endif
                            @if(showLocation()=="true")
                            <th style="min-width: 50px;">@lang('layout.Location')</th>
                            @endif
                            @if(systemConfig()[9] == 0 )
                            <th style="min-width: 50px">@lang('layout.Width') </th>
                            @endif
                            @if(getShowWing()!="false")
                            <th style="min-width: 50px">@lang('layout.Wing') </th>
                            @endif
                            @if(systemConfig()[9] != 0 )
                            @if(itemPicture()=="true")
                            <th style="min-width: 100px">@lang('layout.Photo') </th>
                            @endif
                            @endif
                            <th style="min-width: 50px">@lang('layout.NewCost') </th>
                            <th style="min-width: 50px">@lang('layout.Total') </th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr v-for="(item,index) in inventories">
                            <td>@{{index+1}}</td>
                            <td v-show="showWhat('sale_category')=='yes'" class="highlight">
                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @keyup.native="itemCategoryChange(index)" @click.native="addNew('inventory',index), itemCategoryChange(index)"></v-select>
                            <input type="hidden" :name="'inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                            </td>
                            <td class="highlight">
                            <v-select label="name" v-model="item.inventory" :options="temp_items" @search="onItemSearch" @input="(editKey)?(onItemLoadCode(index), addIndex(index)):''" @keyup.native="editKey = true" @click.native="addNew('inventory',index), addIndex(index), editKey = true" ></v-select>
                            <input type="hidden" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">

                            <input type="hidden" :name="'main_stocks_id['+index+']'" :value="(!item)?null:item.main_stocks_id">
                            <input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(!item)?null:item.m_stocks_in_id">
                            </td>

                            <td>
                            <div class="input-group">
                                <v-select placeholder="@lang('layout.SiteName') " label="name" :options="(item.item==null)?sites:item.item.site_list" v-model="(!item.item)?null:item.item.site"></v-select>
                                <input type="hidden" :name="'site_id['+index+']'" :value="(item.item)?item.item.site.id:null">
                            </div>
                            </td>
                            <td>
                            <div class="input-group">
                                <input :name="'code['+index+']'" :value="(!item.item)?null:item.item.code" ref="code" @input="setNewRate(index)" type="text"
                                oninput = "autowidths(event)"
                                class="form-control chan_length" placeholder="@lang('layout.Code')">
                            </div>
                            </td>
                            <td v-show="showWhat('expire_date')=='yes'">
                            <date_picker :name="'expire_date['+index+']'" v-model="(!item.item)?null:item.item.expire_date" 
                            oninput = "autowidths(event)"
                            class="chan_length" placeholder="@lang('layout.ExpireDate')"></date_picker>
                            </td>
                            <td>
                            <input type="number" :name="'quantity['+index+']'" v-model.number="(item.item==null)?null:item.item.quantity" ref="quantity" @input="setNewRate(index)"
                            oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">

                            </td>

                            <td>
                            @{{myRound((item.item==null)?null:(item.item.quantity) )}}
                            </td>
                            <td v-show="showWhat('other_measure')=='yes'" class="other_measure">
                            <input type="number" :name="'other_measure_amount['+index+']'" v-model.number="(item.item==null)?null:item.item.other_measure" 
                            oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')">
                            </td>
                            <td v-show="showWhat('other_measure2')=='yes'" class="other_measure">
                            <input type="number" :name="'other_measure_amount2['+index+']'" v-model.number="(item.item==null)?null:item.item.other_measure2"
                            oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                            </td>
                            <td class="highlight">
                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                <option value="null">@lang('layout.Select')</option>
                                <span v-if="(item.item ==null)?false:true">
                                <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                    @{{measure.measure_name}}
                                </option>
                                </span>
                            </select>

                            <input type="hidden" :name="'measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                            </td>
                            @if(itemBrand()=="true")
                            <td>
                            <v-select placeholder="@lang('layout.Brand')" label="name" :options="brandAll" v-model="item.selectedBrand"></v-select>
                            <input type="hidden" :name="'brand_id['+index+']'" :value="(item.selectedBrand)?item.selectedBrand.id:null">
                            </td>
                            @endif
                            @if(showLocation()=="true")
                            <td>
                            <input :name="'location['+index+']'" :value="(item.item==null)?null:item.item.location" ref="location" @input="setNewRate(index)" type="text"
                            oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Location')">
                            </td>
                            @endif
                            @if(systemConfig()[9] == 0 )
                            <td>
                            <div class="input-group">
                                <input :name="'widths['+index+']'" :value="(item.item==null)?null:item.item.widths" ref="widths" @input="setNewRate(index)" type="number"
                                oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Width')">
                            </div>
                            </td>
                            @endif
                            @if(getShowWing()!="false")
                            <td>
                            <div class="input-group">
                                <input :name="'khada['+index+']'" :value="(item.item==null)?null:item.item.khada" ref="khada" @input="setNewRate(index)" type="number"
                                oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                            </div>
                            </td>
                            @endif
                            @if(systemConfig()[9] == 1 )
                            @if(itemPicture()=="true")
                            <td>
                            <div class="input-group">
                                <input :name="'photo['+index+']'" type="file" class="form-control" placeholder="@lang('layout.Photo')">
                                <input type="hidden" :name="'last_image['+index+']'" v-model="(item.item==null)?null:item.item.image">

                            </div>
                            </td>
                            @endif
                            @endif
                            <td>
                            <div class="input-group">
                                <input type="number" :name="'inventory_price['+index+']'" placeholder="@lang('layout.Cost')" :value="(item.item==null)?null:purchaseNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate(index)"
                                oninput = "autowidths(event)" class="form-control chan_length">
                                <span class="input-group-addon">
                                @{{selected_currency.symbol}}
                                </span>
                            </div>

                            </td>
                            <td>
                            @{{ (item.item==null)?null:getItemTotals(item.item,selected_currency.rate,null,null,1) }}
                            <b>@{{selected_currency.symbol}}</b>
                            </td>
                            <td>
                                <span v-if="inventories.length > 1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                            </td>
                        </tr>
                        </tbody>
                    </table>

                        <hr>

                    </div>
                    <button v-if="inventories.length <= 0 " type="button" class="btn default"
                            @click="addNew('inventory',0)">@lang('layout.AddItem')
                    </button>

                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('itemNoneCostCode.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                        </div>
                    </div>


                </div>

                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);


        // end new member

        var inventory_category = {!! $inventory_category !!};
        var accounts = {!! $accounts !!};
        var itemNoneCost = {!! $itemNoneCost !!};
        var selectedItems = {!! $selectedItems !!};
        var adjustmentCategory= {!! $adjustmentCategory !!};
        var v = new Vue({
            el: '#appInvoice',
            data: {
                sites: {!!json_encode($site) !!},
                brandAll: {!!$brand!!},
                selected_currency: defaultCurrency(),
                temp_items: [],
                inventory_category: inventory_category,
                selectedIndex: 0,
                selected_iventory_category: null,

                inventories: [],
                accounts: accounts,
                selected_account: null,
                editKey: false,
                itemNoneCost: itemNoneCost,
                selected_item: selectedItems,
                adjustmentCategory:adjustmentCategory,
                selected_adjustment_category:null
            },
            computed: {


                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['cost'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit));
                            }

                        }

                    }

                    return sum;
                },

                // check payed amount

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['new_rate'];
                                if (rate <= 0 && new_rate <= 0) {
                                    // isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
            },
            mounted: function () {
                // initialize the selected item
                if (this.itemNoneCost) {
                    this.category = this.itemNoneCost.category;
                    
                    // initialize the selected item
                    for (var i = 0; i < this.selected_item.length; i++) {
                        var selectedBrand = _.find({!!$brand!!}, (o) => o.id == this.selected_item[i]['brand_id']);
                        var item_category = _.find(this.inventory_category, (o) => o.id == this.selected_item[i]['inventory_category_id']);
                        // console.log(123, this.selected_item[i]);
                        this.inventories.push({
                        item: this.selected_item[i],
                        inventory: this.selected_item[i],
                        item_category: item_category,
                        main_stocks_id:  this.selected_item[i].main_stock_id, 
                        m_stocks_in_id:  this.selected_item[i].m_stocks_in_id, 
                        selectedBrand:  selectedBrand
                        });
                    }
                    this.inventories.push({
                        item: null,
                        inventory: null,
                        item_category: null,
                        selectedBrand: null,
                        main_stocks_id: null, m_stocks_in_id: null
                    });

                    this.selected_account = _.find(this.accounts, (a) => a.id == this.itemNoneCost.account_id);
                    this.selected_adjustment_category=_.find(this.adjustmentCategory, (a) => a.id == this.itemNoneCost.category_id);

                }
            },
            methods:
                {
                    // begin item search
                    onItemSearch: _.debounce((search, loading) => {
                        var selectedIndex = v.selectedIndex;
                        
                        let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'itemSearchNameRoll',
                                    keyword: search,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                            .then(function(response) {
                                v.temp_items = [];

                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                console.log('new', v.temp_items);
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            });
                    }, getDebounceTime()),

                    //ajax call to get items

                    //ajax call to get items code
                    onItemLoadCode(selectedIndex) {
                        v.selectedIndex = selectedIndex;

                        if (v.inventories[selectedIndex].inventory != null) {
                            // console.log('klk',v.inventories[selectedIndex].inventory,v.main_inventories);
                            var inventory_id = v.inventories[selectedIndex].inventory.id;
                            // let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchPurchaseRoll',
                                    inventory_id: inventory_id,
                                    // inventory_category_id: inventory_category_id,
                                }
                            })
                            .then(function(response) {
                                v.inventories[selectedIndex].item = null;
                                if (response.data.length > 0) {
                                    v.inventories[selectedIndex].item = response.data[0];
                                    v.temp_items = [];

                                    // console.log('gg');

                                    // v.onItemSearchCodeSelect(selectedIndex);

                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }

                    },

                    // end item search
                    //ajax call to get items code
                    selectCode(selectedIndex) {
                        if (v.inventories[selectedIndex].item != null && v.inventories[selectedIndex].selectedBrand != null) {

                            console.log('12', v.inventories[selectedIndex]);
                            var selectedBrandId = v.inventories[selectedIndex].selectedBrand.id;
                            var site_id = v.inventories[selectedIndex].item.site.id;
                            var inventory_id = v.inventories[selectedIndex].item.site.inventory_id;

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'getItemCodePurches',
                                        inventory_id: inventory_id,
                                        site_id: site_id,
                                        selectedBrandId: selectedBrandId,
                                    }
                                })
                                .then(function(response) {

                                    console.log('ggll', response.data);
                                    if (response.data.length > 0) {
                                        v.inventories[selectedIndex].maxCode = response.data;

                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })
                        }

                    },

                    // end item search

                    addIndex(index) {
                        // this.temp_items = [];
                        v.selectedIndex = index;
                    },

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // set new price
                    setNewRate(index) {
                        if (this.inventories[index].item) {
                        // console.log('123',this.inventories);
                        this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;

                        this.inventories[index].item.code = this.$refs.code[index].value;
                        // this.inventories[index].item.lengths = this.$refs.lengths[index].value;
                        if (this.$refs.widths) {
                            this.inventories[index].item.widths = this.$refs.widths[index].value;
                            @if(getShowWing()!="false")
                            this.inventories[index].item.khada = this.$refs.khada[index].value;
                            @endif
                        }
                        @if(getShowWing()!="false")
                        if (this.$refs.khada) {
                            this.inventories[index].item.khada = this.$refs.khada[index].value;
                        }
                        @endif
                        if (this.$refs.location) {
                            this.inventories[index].item.location = this.$refs.location[index].value;
                        }
                        this.inventories[index].item.quantity = this.$refs.quantity[index].value;
                        }

                    },


                    itemCategoryChange(index) {

                        v.selectedIndex = index;
                        v.selected_iventory_category = this.inventories[index]['item_category'];

                        let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                            method_name: 'itemSearchNameRoll',
                            inventory_category_id: inventory_category_id
                            }
                        })
                        .then(function(response) {
                            v.inventories[index]['item'] = null;
                            v.inventories[index]['inventory'] = null;
                            v.temp_items = [];

                            if (response.data.length > 0) {
                            v.temp_items = response.data;
                            }

                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                    },
                    
                    // generic function for adding item to list
                    addNew(type = null, index) {
                        
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({
                                        item: null,
                                        inventory: null,
                                        item_category: null,
                                        selectedBrand: null,
                                        main_stocks_id: null, 
                                        m_stocks_in_id: null
                                        });
                                }
                            }


                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }

                        }

                    },
                    //

                },


        });

    </script>



@endpush